<?php
// Check if Live Composer is active
if ( defined( 'DS_LIVE_COMPOSER_URL' ) ) {

	// Register Module
	add_action('dslc_hook_register_modules',
	     create_function('', 'return dslc_register_module( "Intruder_Slider" );')
	);

	class Intruder_Slider extends DSLC_Module {

	 	// Module Attributes
		var $module_id       = 'Intruder_Slider';
		var $module_title    = 'Intruder Slider';
		var $module_icon     = 'file-image-o';
		var $module_category = 'elements';

	 	// Module Options
		function options() {

			$all_post_types = get_post_types();
			$unwanted = array( 'attachment', 'revision', 'nav_menu_item', 'wpcf7_contact_form', 'dslc_templates' );
			foreach( $unwanted as $u ) {
				unset( $all_post_types[$u] );
			}

			$post_types = array();

			$post_types[] = array( 'value' => 'post', 'label' => __( 'Post', 'intruder' ));
			$post_types[] = array( 'value' => 'page', 'label' => __( 'Page', 'intruder' ));

			foreach( $all_post_types as $post_type => $name ) {
				if ( strpos( $name, 'dslc_' ) !== false ) {
					$post_types[] = array( 'value' => $post_type, 'label' => ucfirst( substr($name, 5) ) );
				}
			}

			// The options array
			$options = array(

				array(
					'label' => __( 'Show On', 'intruder' ),
					'id'    => 'css_show_on',
					'std'   => 'desktop tablet phone',
					'type'  => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Desktop', 'intruder' ),
							'value' => 'desktop'
						),
						array(
							'label' => __( 'Tablet', 'intruder' ),
							'value' => 'tablet'
						),
						array(
							'label' => __( 'Phone', 'intruder' ),
							'value' => 'phone'
						),
					),
				),

 				array(
					'label'                 => __( 'Slider Height', 'intruder' ),
					'id'                    => 'slider_height',
					'std'                   => '100',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-slider li',
					'affect_on_change_rule' => 'height',
					'min'                   => 50,
					'max'                   => 100,
					'ext'                   => 'vh'
				),

				array(
					'label' => __( 'Sliding Mode', 'intruder' ),
					'id'    => 'slider_mode',
					'std'   => 'horizontal',
					'type'  => 'select',
					'choices' => array(
						array(
							'label' => __( 'Fade', 'intruder' ),
							'value' => 'fade'
						),
						array(
							'label' => __( 'Horizontal', 'intruder' ),
							'value' => 'horizontal'
						),
						array(
							'label' => __( 'Vertical', 'intruder' ),
							'value' => 'vertical'
						),
					)
				),

				array(
					'label' => __( 'Auto Scroll', 'intruder' ),
					'id'    => 'slider_auto',
					'std'   => 'on',
					'type'  => 'select',
					'choices' => array(
						array(
							'label' => __( 'On', 'intruder' ),
							'value' => '1'
						),
						array(
							'label' => __( 'Off', 'intruder' ),
							'value' => '0'
						),
					)
				),

				array(
					'label' => __( 'Slider Pause (in milliseconds)', 'intruder' ),
					'id'    => 'slider_pause',
					'std'   => '4000',
					'type'  => 'text'
				),

				array(
					'label'   => __( 'Post type', 'intruder' ),
					'id'      => 'slider_post_type',
					'std'     => 'post',
					'type'    => 'select',
					'tab'     => __( 'Query', 'intruder' ),
					'choices' => $post_types
				),

				array(
					'label' => __( 'Number Of Slides', 'intruder' ),
					'id'    => 'slider_number',
					'std'   => '3',
					'type'  => 'text',
					'tab'   => __( 'Query', 'intruder' ),
				),

				array(
					'label' => __( 'Order By', 'intruder' ),
					'id' => 'orderby',
					'std' => 'date',
					'type' => 'select',
					'tab' => __( 'Query', 'intruder' ),
					'choices' => array(
						array(
							'label' => __( 'Publish Date', 'intruder' ),
							'value' => 'date'
						),
						array(
							'label' => __( 'Modified Date', 'intruder' ),
							'value' => 'modified'
						),
						array(
							'label' => __( 'Random', 'intruder' ),
							'value' => 'rand'
						),
						array(
							'label' => __( 'Alphabetic', 'intruder' ),
							'value' => 'title'
						),
						array(
							'label' => __( 'Comment Count', 'intruder' ),
							'value' => 'comment_count'
						),
					)
				),
				array(
					'label' => __( 'Order', 'intruder' ),
					'id' => 'order',
					'std' => 'DESC',
					'type' => 'select',
					'tab' => __( 'Query', 'intruder' ),
					'choices' => array(
						array(
							'label' => __( 'Ascending', 'intruder' ),
							'value' => 'ASC'
						),
						array(
							'label' => __( 'Descending', 'intruder' ),
							'value' => 'DESC'
						)
					)
				),

				array(
					'label' => __( 'Sticky Posts', 'intruder' ),
					'id' => 'sticky_posts',
					'help' => __( 'If enabled sticky posts will be pushed to the top. If disabled sticky posts will follow regular order.', 'intruder' ),
					'std' => 'enabled',
					'type' => 'select',
					'tab' => __( 'Query', 'intruder' ),
					'choices' => array(
						array(
							'label' => __( 'Enabled', 'intruder' ),
							'value' => 'enabled'
						),
						array(
							'label' => __( 'Disabled', 'intruder' ),
							'value' => 'disabled'
						)
					)
				),
				array(
					'label' => __( 'Include (IDs)', 'intruder' ),
					'id' => 'query_post_in',
					'std' => '',
					'type' => 'text',
					'tab' => __( 'Query', 'intruder' ),
				),
				array(
					'label' => __( 'Exclude (IDs)', 'intruder' ),
					'id' => 'query_post_not_in',
					'std' => '',
					'type' => 'text',
					'tab' => __( 'Query', 'intruder' ),
				),

				/* ====== Title ====== */

				array(
					'label'                 => __( 'Color', 'intruder' ),
					'id'                    => 'st_css_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'h2 a',
					'affect_on_change_rule' => 'color',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Title', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Size', 'intruder' ),
					'id'                    => 'st_css_font_size',
					'std'                   => '70',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'h2',
					'affect_on_change_rule' => 'font-size',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Title', 'intruder' ),
					'ext'                   => 'px'
				),

				array(
					'label'                 => __( 'Font Weight', 'intruder' ),
					'id'                    => 'st_css_font_weight',
					'std'                   => '900',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'h2',
					'affect_on_change_rule' => 'font-weight',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Title', 'intruder' ),
					'ext'                   => '',
					'min'                   => 100,
					'max'                   => 900,
					'increment'             => 100
				),

				array(
					'label'                 => __( 'Font Family', 'intruder' ),
					'id'                    => 'st_css_font_family',
					'std'                   => 'Merriweather',
					'type'                  => 'font',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'h2',
					'affect_on_change_rule' => 'font-family',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Title', 'intruder' ),
				),

				array(
					'label'                 => __( 'Line Height', 'intruder' ),
					'id'                    => 'st_css_line_height',
					'std'                   => '90',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'h2',
					'affect_on_change_rule' => 'line-height',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Title', 'intruder' ),
					'ext'                   => 'px'
				),

				array(
					'label' => __( 'Text Transform', 'intruder' ),
					'id'    => 'st_css_text_transform',
					'std'   => 'uppercase',
					'type'  => 'select',
					'choices' => array(
						array(
							'label' => __( 'None', 'intruder' ),
							'value' => 'none'
						),
						array(
							'label' => __( 'Capitalize', 'intruder' ),
							'value' => 'capitalize'
						),
						array(
							'label' => __( 'Uppercase', 'intruder' ),
							'value' => 'uppercase'
						),
						array(
							'label' => __( 'Lowercase', 'intruder' ),
							'value' => 'lowercase'
						),
					),
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'h2',
					'affect_on_change_rule' => 'text-transform',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Title', 'intruder' ),
				),

				array(
					'label'                 => __( 'Margin Bottom', 'intruder' ),
					'id'                    => 'st_css_margin_bottom',
					'std'                   => '0',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'h2',
					'affect_on_change_rule' => 'margin-bottom',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Title', 'intruder' ),
					'ext'                   => 'px',
				),

				/* ====== Excerpt ====== */

				array(
					'label'                 => __( 'Color', 'intruder' ),
					'id'                    => 'se_css_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'p',
					'affect_on_change_rule' => 'color',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Excerpt', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Size', 'intruder' ),
					'id'                    => 'se_css_font_size',
					'std'                   => '30',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'p',
					'affect_on_change_rule' => 'font-size',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Excerpt', 'intruder' ),
					'ext'                   => 'px'
				),

				array(
					'label'                 => __( 'Font Family', 'intruder' ),
					'id'                    => 'se_css_font_family',
					'std'                   => 'Merriweather Sans',
					'type'                  => 'font',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'p',
					'affect_on_change_rule' => 'font-family',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Excerpt', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Weight', 'intruder' ),
					'id'                    => 'se_css_font_weight',
					'std'                   => '400',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'p',
					'affect_on_change_rule' => 'font-weight',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Excerpt', 'intruder' ),
					'ext'                   => '',
					'min'                   => 100,
					'max'                   => 400,
					'increment'             => 100
				),

				array(
					'label'                 => __( 'Font Style', 'intruder' ),
					'id'                    => 'se_css_cats_font_style',
					'std'                   => 'italic',
					'type'                  => 'select',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'p',
					'affect_on_change_rule' => 'font-style',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Excerpt', 'intruder' ),
					'choices' 				=> array(
						array(
							'label' => __( 'Normal', 'intruder' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'intruder' ),
							'value' => 'italic',
						),
					)
				),

				array(
					'label'                 => __( 'Line Height', 'intruder' ),
					'id'                    => 'se_css_line_height',
					'std'                   => '45',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'p',
					'affect_on_change_rule' => 'line-height',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Excerpt', 'intruder' ),
					'ext'                   => 'px'
				),

				array(
					'label'                 => __( 'Margin Bottom', 'intruder' ),
					'id'                    => 'se_css_margin_bottom',
					'std'                   => '42',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => 'p',
					'affect_on_change_rule' => 'margin-bottom',
					'section'               => 'styling',
					'tab'                   => __( 'Slide Excerpt', 'intruder' ),
					'ext'                   => 'px',
				),

				/* ====== Read More ====== */

				array(
					'label'                 => __( 'Border Color', 'intruder' ),
					'id'                    => 'srmb_css_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.slider-more span,.slider-more i',
					'affect_on_change_rule' => 'border-color',
					'section'               => 'styling',
					'tab'                   => __( 'Read More', 'intruder' ),
				),

				array(
					'label'                 => __( 'Color', 'intruder' ),
					'id'                    => 'srm_css_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.slider-more span, .slider-more i',
					'affect_on_change_rule' => 'color',
					'section'               => 'styling',
					'tab'                   => __( 'Read More', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Family', 'intruder' ),
					'id'                    => 'srm_css_font_family',
					'std'                   => 'Merriweather Sans',
					'type'                  => 'font',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.slider-more span',
					'affect_on_change_rule' => 'font-family',
					'section'               => 'styling',
					'tab'                   => __( 'Read More', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Weight', 'intruder' ),
					'id'                    => 'srm_css_font_weight',
					'std'                   => '400',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.slider-more span',
					'affect_on_change_rule' => 'font-weight',
					'section'               => 'styling',
					'tab'                   => __( 'Read More', 'intruder' ),
					'ext'                   => '',
					'min'                   => 100,
					'max'                   => 900,
					'increment'             => 100
				),

				array(
					'label'                 => __( 'Font Style', 'intruder' ),
					'id'                    => 'srm_css_cats_font_style',
					'std'                   => 'italic',
					'type'                  => 'select',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.slider-more span',
					'affect_on_change_rule' => 'font-style',
					'section'               => 'styling',
					'tab'                   => __( 'Read More', 'intruder' ),
					'choices' 				=> array(
						array(
							'label' => __( 'Normal', 'intruder' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'intruder' ),
							'value' => 'italic',
						),
					)
				),

			);

			$options = array_merge( $options, $this->shared_options( 'animation_options', array( 'hover_opts' => false ) ) );
			$options = array_merge( $options, $this->presets_options() );

			// Return the array
			return apply_filters( 'dslc_module_options', $options, $this->module_id );

		}

	 	// Module Output
	    function output( $options ) {

	    	// REQUIRED
	    	$this->module_start( $options );

	    	wp_enqueue_script( 'intruder-slider' );

			$post_type = esc_html( $options['slider_post_type'] );
			$mode      = esc_html( $options['slider_mode'] );
			$auto      = esc_html( $options['slider_auto'] );
			$pause     = isset( $options['slider_pause'] ) ? absint( $options['slider_pause'] ) : 4000;
			$number    = isset( $options['slider_number'] ) ? absint( $options['slider_number'] ) : 3;

			$args = array(
						'post_type'      => $post_type,
						'posts_per_page' => $number,
						'order' => $options['order'],
						'orderby' => $options['orderby'],
					);


			// Sticky Posts
			if ( $options['sticky_posts'] == 'disabled' )
				$args['ignore_sticky_posts'] = true;

			// Exlcude and Include arrays
			$exclude = array();
			$include = array();

			// Exclude current post
			if ( is_singular( get_post_type() ) )
				$exclude[] = get_the_ID();

			// Exclude posts ( option )
			if ( $options['query_post_not_in'] )
				$exclude = array_merge( $exclude, explode( ' ', $options['query_post_not_in'] ) );

			// Include posts ( option )
			if ( $options['query_post_in'] )
				$include = array_merge( $include, explode( ' ', $options['query_post_in'] ) );

			// Include query parameter
			if ( ! empty( $include ) )
				$args['post__in'] = $include;

			// Exclude query parameter
			if ( ! empty( $exclude ) )
				$args['post__not_in'] = $exclude;


			$slider = new WP_Query( $args );
			/* Used for preview only, adds min-height for image. */
			$preview_class = intruder_is_active_lc() == true ? 'preview' : ''; ?>


			<?php if ( $slider->have_posts() ) : ?>

				<ul class="intruder-slider no-margin <?php echo $preview_class; ?>" data-mode="<?php echo $mode; ?>" data-auto="<?php echo $auto; ?>" data-pause="<?php echo $pause; ?>">

				<?php while( $slider->have_posts() ) : $slider->the_post(); ?>

					<?php
						if ( has_post_thumbnail() )
							$img = get_the_image( array( 'echo' => false, 'size' => 'full', 'format' => 'array' ) );
						else {
							echo '<img src="'. THEME_URI .'images/default-image.jpg" />';
						}
					?>

					<li style="background-image: url( '<?php echo esc_url( $img['src'] ); ?>' );">
						<div class="wrap text-center">
							<div class="slider-caption">
								<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
								<?php the_excerpt(); ?>
								<a href="<?php the_permalink(); ?>" class="slider-more">
									<span><?php _e( 'Read More', 'intruder' ); ?></span> <i class="fa fa-angle-double-right"></i>
								</a>
							</div>
						</div>
					</li>

				<?php endwhile; ?>

				</ul>

			<?php endif; ?>

			<script>
			jQuery(document).ready(function(){
				init_intruder_slider();
			});
			</script>

			<?php wp_reset_postdata();

	    	// REQUIRED
	    	$this->module_end( $options );

	     }

	}

}

 ?>