<?php
class Intruder_Widget_Popular extends WP_Widget {

	public function __construct() {

		$widget_options = array(
			'classname'   => 'intruder_widget_popular_posts',
			'description' => __( 'Displays most popular posts.', 'intruder' )
		);

		parent::__construct(
			'Intruder_Widget_Popular',
			THEME_NAME . ' ' . __( 'Popular Posts', 'intruder' ),
			$widget_options
		);
	}

	public function form( $instance ) {

		$title      = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number     = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		$show_date  = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
		$categories = isset( $instance['categories'] ) ? $instance['categories'] : array();
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'intruder' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:', 'intruder' ); ?></label>
			<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" />
		</p>

		<p>
			<input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php _e( 'Display post date?', 'intruder' ); ?></label>
		</p>

		<p class="widget-select-container">
 			<label for="<?php echo $this->get_field_id( 'categories' ); ?>"><?php _e( 'Choose Categories:', 'intruder' ); ?></label>
			<select name="<?php echo $this->get_field_name( 'categories' ); ?>[]" id="<?php echo $this->get_field_id( 'categories' ); ?>"  style="height: 200px" class="widefat" multiple="multiple">
			<?php $cats = get_categories(array('hide_empty' => 0 )); ?>
			<?php foreach( $cats as $cat ) : ?>
				<option value="<?php echo absint( $cat->cat_ID ); ?>" <?php echo in_array( $cat->cat_ID, $categories ) ? 'selected="selected"' : ''; ?>><?php echo esc_attr( $cat->cat_name ); ?></option>
			<?php endforeach; ?>
			</select>
		</p>

		<?php
	}

	public function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$instance['title']      = strip_tags( $new_instance['title'] );
		$instance['number']     = (int) $new_instance['number'];
		$instance['show_date']  = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
		$instance['categories'] = isset( $new_instance['categories'] ) ? $new_instance['categories'] : array();

		return $instance;
	}

	public function widget( $args, $instance ) {

		extract( $args );

		$title     = strip_tags( $instance['title'] );
		$number    = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		$show_date = (bool) $instance['show_date'];
		$cats      = array();

		if ( ! empty( $instance['categories'] ) ) {
			foreach( $instance['categories'] as $cat ) {
				$cats[] = (int) $cat;
			}
		}

		$query = new WP_Query( apply_filters( 'widget_posts_args', array(
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => true,
			'category__in' 		  => $cats,
			'orderby' 			  => 'comment_count',
		) ) );

		if ( $query->have_posts() ) :

			echo $args['before_widget'];

			if ( $title )
				echo $args['before_title'] . $title . $args['after_title'];
			?>

			<ul>

			<?php while ( $query->have_posts() ) : $query->the_post(); ?>

				<li class="popular-post clear">

					<?php if ( has_post_thumbnail() ) : ?>
						<div class="widget-image-wrap">
							<?php the_post_thumbnail(); ?>
						</div>
					<?php endif ?>

					<div class="post-info">
						<a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a>
						<?php if ( $show_date ) : ?>
							<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' ago'; ?></time>
						<?php endif; ?>
					</div>

				</li>

			<?php endwhile; ?>

			</ul>

			<?php
			echo $args['after_widget'];

			// Reset the global $the_post as this query will have stomped on it
			wp_reset_postdata();

		endif; // End check if there are posts.
	}

}