<?php

// Check if Live Composer is active
if ( defined( 'DS_LIVE_COMPOSER_URL' ) ) {

	// Register Module
	add_action('dslc_hook_register_modules',
	     create_function('', 'return dslc_register_module( "Circle_Progress" );')
	);

	class Circle_Progress extends DSLC_Module {

	 	// Module Attributes
		var $module_id       = 'Circle_Progress';
		var $module_title    = 'Circle Progress';
		var $module_icon     = 'circle';
		var $module_category = 'elements';

	 	// Module Options
	    function options() {

	    	$options = array(
	    		array(
	    			'label' => __( 'Show On', 'intruder' ),
	    			'id' => 'cp_show_on',
	    			'std' => 'desktop tablet phone',
	    			'type' => 'checkbox',
	    			'choices' => array(
	    				array(
	    					'label' => __( 'Desktop', 'intruder' ),
	    					'value' => 'desktop'
	    				),
	    				array(
	    					'label' => __( 'Tablet', 'intruder' ),
	    					'value' => 'tablet'
	    				),
	    				array(
	    					'label' => __( 'Phone', 'intruder' ),
	    					'value' => 'phone'
	    				),
	    			),
	    		),

	    		array(
					'label'               => __( 'Circle Color', 'intruder' ),
					'id'                  => 'cp_circle_color',
					'std'                 => '#e1e3e4',
					'type'                => 'color',
					'refresh_on_change'   => false,
					'affect_on_change_el' => '.dslc-non-existing',
					'section'             => 'styling'
	    		),

	    		array(
					'label'               => __( 'Circle Line Color', 'intruder' ),
					'id'                  => 'cp_circle_line_color',
					'std'                 => '#00bff3',
					'type'                => 'color',
					'refresh_on_change'   => false,
					'affect_on_change_el' => '.dslc-non-existing',
					'section'             => 'styling'
	    		),

	    		array(
					'label'                 => __( 'Circle Text Color', 'intruder' ),
					'id'                    => 'cp_circle_text',
					'std'                   => '#807e7e',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_rule' => 'color',
					'affect_on_change_el'   => '.intruder-circle-progress span',
					'section'               => 'styling',
					'tab'                   => __( 'Circle Text', 'intruder' ),
	    		),

	    		array(
	    			'label'                 => __( 'Font Family', 'intruder' ),
	    			'id'                    => 'cp_font_family',
	    			'std'                   => 'Merriweather',
	    			'type'                  => 'font',
	    			'refresh_on_change'     => false,
	    			'affect_on_change_el'   => '.intruder-circle-progress span',
	    			'affect_on_change_rule' => 'font-family',
	    			'section'               => 'styling',
	    			'tab'                   => __( 'Circle Text', 'intruder' ),
	    		),

	    		array(
	    			'label'                 => __( 'Font Size', 'intruder' ),
	    			'id'                    => 'cp_circle_fz',
	    			'std'                   => '40',
	    			'type'                  => 'slider',
	    			'refresh_on_change'     => false,
	    			'affect_on_change_el'   => '.intruder-circle-progress span',
	    			'affect_on_change_rule' => 'font-size',
	    			'ext'                   => 'px',
	    			'section'               => 'styling',
	    			'tab'                   => __( 'Circle Text', 'intruder' ),
	    		),

				 array(
				 	'label'                 => __( 'Font Weight', 'intruder' ),
				 	'id'                    => 'cp_font_weight',
				 	'std'                   => '700',
				 	'type'                  => 'slider',
				 	'refresh_on_change'     => false,
	    			'affect_on_change_el'   => '.intruder-circle-progress span',
				 	'affect_on_change_rule' => 'font-weight',
				 	'ext'                   => '',
				 	'min'                   => 100,
				 	'max'                   => 900,
				 	'increment'             => 100,
				 	'section'               => 'styling',
				 	'tab'                   => __( 'Circle Text', 'intruder' ),
				 ),

	    		array(
					'label'             => __( 'Circle Title:', 'intruder' ),
					'id'                => 'cp_title',
					'std'               => __( 'Satisfied Users', 'intruder' ),
					'type'              => 'text',
	    		),

	    		array(
					'label'             => __( 'Number in circle:', 'intruder' ),
					'id'                => 'cp_number',
					'std'               => '10000',
					'type'              => 'text'
	    		),

				array(
					'label'               => __( 'Start Value', 'intruder' ),
					'id'                  => 'cp_start_value',
					'std'                 => '10',
					'type'                => 'slider',
					'refresh_on_change'   => false,
					'affect_on_change_el' => '.dslc-non-existing',
					'ext'                 => '%',
					'min'                 => '0',
					'max'                 => '100',
					'increment'           => '1',
				),

				array(
					'label'               => __( 'End Value', 'intruder' ),
					'id'                  => 'cp_end_value',
					'std'                 => '99',
					'type'                => 'slider',
					'refresh_on_change'   => false,
					'affect_on_change_el' => '.dslc-non-existing',
					'ext'                 => '%',
					'min'                 => '0',
					'max'                 => '100',
					'increment'           => '1',
				),

				array(
					'label'               => __( 'Thickness', 'intruder' ),
					'id'                  => 'cp_thickness',
					'std'                 => '23',
					'type'                => 'slider',
					'refresh_on_change'   => false,
					'affect_on_change_el' => '.dslc-non-existing',
					'ext'                 => 'px',
					'min'                 => '1',
					'max'                 => '100',
					'increment'           => '1',
				),

	    		array(
					'label'                 => __( 'Title Text Color', 'intruder' ),
					'id'                    => 'cp_title_text',
					'std'                   => '#666666',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_rule' => 'color',
					'affect_on_change_el'   => '.intruder-circle-progress-title',
					'section'               => 'styling',
					'tab'                   => __( 'Title Text', 'intruder' ),
	    		),

	    		array(
	    			'label'                 => __( 'Font Family', 'intruder' ),
	    			'id'                    => 'cp_title_font_family',
	    			'std'                   => 'Merriweather',
	    			'type'                  => 'font',
	    			'refresh_on_change'     => false,
	    			'affect_on_change_el'   => '.intruder-circle-progress-title',
	    			'affect_on_change_rule' => 'font-family',
	    			'section'               => 'styling',
	    			'tab'                   => __( 'Title Text', 'intruder' ),
	    		),

	    		array(
	    			'label'                 => __( 'Font Size', 'intruder' ),
	    			'id'                    => 'cp_title_fz',
	    			'std'                   => '20',
	    			'type'                  => 'slider',
	    			'refresh_on_change'     => false,
	    			'affect_on_change_el'   => '.intruder-circle-progress-title',
	    			'affect_on_change_rule' => 'font-size',
	    			'ext'                   => 'px',
	    			'section'               => 'styling',
	    			'tab'                   => __( 'Title Text', 'intruder' ),
	    		),

				 array(
				 	'label'                 => __( 'Font Weight', 'intruder' ),
				 	'id'                    => 'cp_title_font_weight',
				 	'std'                   => '400',
				 	'type'                  => 'slider',
				 	'refresh_on_change'     => false,
	    			'affect_on_change_el'   => '.intruder-circle-progress-title',
				 	'affect_on_change_rule' => 'font-weight',
				 	'ext'                   => '',
				 	'min'                   => 100,
				 	'max'                   => 900,
				 	'increment'             => 100,
				 	'section'               => 'styling',
				 	'tab'                   => __( 'Title Text', 'intruder' ),
				 ),

    		);

			$options = array_merge( $options, $this->shared_options( 'animation_options', array( 'hover_opts' => false ) ) );
			$options = array_merge( $options, $this->presets_options() );

    		// Return the array
    		return apply_filters( 'dslc_module_options', $options, $this->module_id );
	    }

	 	// Module Output
	    function output( $options ) {

	    	// REQUIRED
	    	$this->module_start( $options );

	    	wp_enqueue_script( 'intruder-inview' );
	    	wp_enqueue_script( 'intruder-circle-progress' );

			$start_value  = esc_attr( $options['cp_start_value'] ) / 100;
			$end_value    = esc_attr( $options['cp_end_value'] ) / 100;
			$cp_thickness = absint( $options['cp_thickness'] );

			$cp_circle_color      = esc_attr( $options['cp_circle_color'] );
			$cp_circle_line_color = esc_attr( $options['cp_circle_line_color'] );
			?>

	    	<div class="intruder-circle-progress" data-animation-start-value="<?php echo $start_value; ?>" data-value="<?php echo $end_value; ?>" data-thickness="<?php echo $cp_thickness; ?>" data-size="210" data-num="<?php echo absint( $options['cp_number'] ); ?>" data-fill="{ &quot;color&quot;: &quot;<?php echo $cp_circle_line_color; ?>&quot; }" data-empty-fill="<?php echo $cp_circle_color; ?>"><span></span>
	    	</div>

	    	<span class="intruder-circle-progress-title"><?php echo esc_html( $options['cp_title'] ); ?></span>

	    	<script>
			jQuery(document).ready(function(){
	    		init_circle_progres();
	    	});
	    	</script>

	    	<?php
	    	// REQUIRED
	    	$this->module_end( $options );

	    }

	}

}

