<?php

/* Theme Customizer setup. */
add_action( 'customize_register', 'intruder_customizer_options', 20 );

/**
 * Sets up the theme customizer sections, controls, and settings.
 *
 * @since  1.0.0
 * @access public
 * @param  object  $wp_customize
 * @return void
 */
function intruder_customizer_options( $wp_customize ) {

	/* === Site Identity === */

	$wp_customize->add_setting( 'logo', array(
		'default'           => trailingslashit( get_template_directory_uri() ) . 'images/logo.png',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'logo',
	        array(
				'label'       => __( 'Logo Upload', 'intruder' ),
				'description' => __( 'If you remove logo, site title will be used instead.', 'intruder' ),
				'section'     => 'title_tagline',
				'settings'    => 'logo',
	        )
	    )
	);

	$wp_customize->add_setting( 'transparent_header', array(
		'default'           => 1,
		'sanitize_callback' => 'customizer_sanitize_checkbox'
	) );

	$wp_customize->add_setting( 'theme_preloader', array(
		'default'           => 1,
		'sanitize_callback' => 'customizer_sanitize_checkbox'
	) );

	$wp_customize->add_control( 'theme_preloader', array(
		'label'    => __( 'Use theme preloader on front page?', 'intruder' ),
		'type'     => 'checkbox',
		'section'  => 'title_tagline',
		'settings' => 'theme_preloader',
	) );

	$wp_customize->add_control( 'transparent_header', array(
		'label'       => __( 'Transparent Header', 'intruder' ),
		'description' => __( 'Check this box to enable transparent header on front page template (used to create transparent slider effect, like on theme demo).', 'intruder' ),
		'type'        => 'checkbox',
		'section'     => 'title_tagline',
		'settings' => 'transparent_header',
	) );

	$wp_customize->add_setting( 'loop_title', array(
		'default'           => __( 'Tips & Articles', 'intruder' ),
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'loop_title', array(
		'label'    => __( 'Separator Title', 'intruder' ),
		'section'  => 'title_tagline',
		'settings' => 'loop_title',
	) );

	/*----------  Live Preview  ----------*/

	/* Load JavaScript files. */
	add_action( 'customize_preview_init', 'intruder_enqueue_customizer_scripts' );

	/* Enable live preview for WordPress theme features. */
	$wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
}


/**
 * Loads theme customizer JavaScript.
 *
 * @since  1.0.0
 * @access public
 * @return void
 */
function intruder_enqueue_customizer_scripts() {

	/* Use the .min script if SCRIPT_DEBUG is turned off. */
	$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_script(
		'intruder-customize',
		trailingslashit( get_template_directory_uri() ) . "js/theme-customizer{$suffix}.js",
		array( 'jquery', 'customize-preview' ),
		null,
		true
	);
}

/*==============================================
=            SANITIZATION CALLBACKS            =
==============================================*/

/**
 * Sanitizes checkbox fields in customizer.
 *
 * @since 1.0.0
 * @access public
 * @param  bool 	$input
 * @return int|bool
 */
function customizer_sanitize_checkbox( $input ) {
	return ( $input == 1 ) ? 1 : false;
}

/**
 * Sanitizes text in customizer.
 *
 * @since 1.0.0
 * @access public
 * @param  string 	$input
 * @return string
 */
function intruder_sanitize_text( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}

/**
 * Sanitizes opacity for background image. Returns 0, 1, and everything between 0.01-0.99.
 *
 * @since 1.0.0
 * @access public
 * @param  string  	$value
 * @return int|float
 */
function intruder_sanitize_opacity( $value ) {
    $value = abs( $value );

    if ( $value > 0 && $value < 1 )
        $value = number_format( $value, 2, '.', '' );

    return ( $value > 1 ) ? 1 : $value;
}

/*=====  End of SANITIZATION CALLBACKS  ======*/

?>