jQuery( document ).ready( function($) {

	/*=================================
	=            Preloader            =
	=================================*/

	var preloader = $('#theme-preloader');

	if ( preloader.length > 0 ) {
		$( '#theme-preloader' ).delay( 1000 ).fadeOut( 'slow', function() {
			$( this ).remove();
		});
	}

	/*===================================
	=            Menu Toggle            =
	===================================*/

	$( '.menu-toggle' ).click( function() {
		$( this ).parent().children( '.wrap, .menu-items' ).slideToggle();
		$( this ).toggleClass( 'active' );
		$('.bx-controls-direction').fadeToggle();
	});

	$(window).on('resize', function(){
		var width = $(this).width();
		if ( width > 989 )
			$('#menu-primary-items').removeAttr('style');
	});

	/*=====================================
	=            FitVids Setup            =
	=====================================*/

	$('#content').fitVids({ customSelector: "iframe[src*='wordpress.tv'], iframe[src*='www.dailymotion.com'], iframe[src*='blip.tv'], iframe[src*='www.viddler.com']"});

	/*=====================================
	=            Scroll To Top            =
	=====================================*/

	var stt = $('.scroll-to-top');

	$(window).scroll(function(){
		var current_height = $(this).scrollTop(),
		    total_height = $(document).height();
		if ( current_height > ( total_height * 0.6 ) ) {
			stt.css({'visibility': 'visible', 'opacity': 1});
		}
		else {
			stt.css({'visibility': 'hidden', 'opacity': 0});
		}
	});

	stt.click(function(e){
		e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, 600);
	});

	/*==================================
	=            NEWSLETTER            =
	==================================*/

	var newsletter_input = $( '#sidebar-subsidiary .newsletter-button' );
	if ( newsletter_input.length > 0 ) {
		var niw = newsletter_input.innerWidth();
		newsletter_input.prev().css( 'paddingRight', niw + 10 );
	}

});

/*=======================================
=            Intruder Slider            =
=======================================*/

function init_intruder_slider() {

	var slider = jQuery( '.intruder-slider' );

	var default_settings = {
		mode: 'horizontal',
		auto: true,
		pause: 4000,
		autoHover: true,
		adaptiveHeight: false,
		pager: true,
		prevText: '<i class="fa fa-chevron-left"></i>',
		nextText: '<i class="fa fa-chevron-right"></i>',
	};

	var user_settings = {
		mode: slider.data('mode'),
		auto: slider.data('auto'),
		pause: slider.data('pause'),
		autoHover: true,
		adaptiveHeight: false,
		pager: true,
		prevText: '<i class="fa fa-chevron-left"></i>',
		nextText: '<i class="fa fa-chevron-right"></i>',
	};

	user_settings.auto = user_settings.auto === 'on' ? true : false;

	var slider_settings = jQuery.extend({}, default_settings, user_settings);

	slider.each(function(){
		jQuery(this).bxSlider(slider_settings);
	});

}

/*================================================
=            Intruder Circle Progress            =
================================================*/

function init_circle_progres() {

	var intruderCircle = jQuery('.intruder-circle-progress');

	if ( intruderCircle.length > 0 ) {
		intruderCircle.one('inview', function(){
			intruderCircle.circleProgress().on('circle-animation-progress', function(event, progress) {
	        	jQuery(this).find('span').html(parseInt(jQuery(this).data('num') * progress));
	      	});
      	});
	}
}
