<?php

class intruder_Widget_Company_Info extends WP_Widget {

	function __construct() {

		$widget_options = array(
			'classname'   => 'intruder_widget_company_info',
			'description' => __( 'Displays company informations with image.', 'intruder' )
		);

		parent::__construct(
			'intruder_Widget_Company_Info',
			THEME_NAME . ' - ' . __( 'Company Info', 'intruder' ),
			$widget_options
		);

		add_action( 'admin_enqueue_scripts', array( &$this, 'intruder_widget_company_info_scripts' ) );
	}

	function intruder_widget_company_info_scripts( $hook ) {

		if ( $hook != 'widgets.php' )
			return;

		# Load media library.
		wp_enqueue_media();

		# Load widgets Javascript.
		wp_enqueue_script(
			'intruder-widgets',
			THEME_URI . 'js/widgets.js',
			array('jquery'),
			null,
			true
		);

	}

	function form( $instance ) {

		/* Defaults */
		$defaults = array( 'image' => '', 'title' => '', 'subtitle' => '', 'text' => '' );

		/* Merge $defaults with saved options */
		$instance = wp_parse_args( (array) $instance, $defaults );

		$image    = $instance['image'];
		$title    = $instance['title'];
		$subtitle = $instance['subtitle'];
		$text     = $instance['text'];

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'image' ); ?>"><?php _e( 'Image:', 'intruder' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'image' ); ?>" name="<?php echo $this->get_field_name( 'image' ); ?>" value="<?php echo esc_attr( $image ); ?>" style="margin-bottom: 10px;" />
			<button class="button-primary widget-image-uploader"><?php _e( 'Upload', 'intruder' ); ?></button>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'intruder' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'subtitle' ); ?>"><?php _e( 'Subtitle:', 'intruder' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'subtitle' ); ?>" name="<?php echo $this->get_field_name( 'subtitle' ); ?>" value="<?php echo esc_attr( $subtitle ); ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'text' ); ?>"><?php _e( 'Text', 'intruder' ); ?></label>
			<textarea class="widefat" cols="20" rows="16" id="<?php echo $this->get_field_id( 'text' ); ?>" name="<?php echo $this->get_field_name( 'text' ); ?>"><?php echo esc_textarea( $text ); ?></textarea>
		</p>

		<?php

	}

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

		$instance['image']    = esc_url_raw( $new_instance['image'] );
		$instance['title']    = sanitize_text_field( $new_instance['title'] );
		$instance['subtitle'] = sanitize_text_field( $new_instance['subtitle'] );

		if ( current_user_can( 'unfiltered_html' ) )
			$instance['text'] = $new_instance['text'];
		else
			$instance['text'] = wp_kses_post( stripslashes( $new_instance['text'] ) );

	    return $instance;
	}

	function widget( $args, $instance ) {

		extract( $args );

		$image    = esc_url( $instance['image'] );
		$title    = strip_tags( $instance['title'] );
		$subtitle = strip_tags( $instance['subtitle'] );
		$text     = ! empty( $instance['text'] ) ? $instance['text'] : '';

		echo $before_widget;

		if ( empty( $image ) ) // If there's no image, use regular h3 title.
			echo $before_title . apply_filters( 'widget_title',  $instance['title'], $instance, $this->id_base ) . $after_title;
		?>

 		<?php if ( ! empty( $image ) ) : ?>

 			<div class="company-top-wrap">

 				<div class="company-image">
 					<img src="<?php echo $image; ?>" alt="<?php echo ! empty( $title ) ? $title : ''; ?>">
 				</div><!-- .company-image -->

 				<div class="company-title-wrap">

	 			<?php if ( ! empty( $title ) ) : ?>
			 		<h3 class="company-title">
			 			<?php echo $title; ?>
			 		</h3>
			 	<?php endif; ?>

		 		<?php if ( ! empty( $subtitle ) ) : ?>
		 			<small><?php echo $subtitle; ?></small>
		 		<?php endif; ?>

 				</div><!-- .company-title-wrap -->

 			</div><!-- .company-top-wrap -->

	 	<?php endif; ?>

		<div class="company-text">
			<?php echo wpautop( $text ); ?>
		</div>

		<?php echo $after_widget;
	}

}

?>