<?php

class Losatom_Widget_Testimonial extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_testimonial', 
			'description' => __( 'Displays testimonials.', 'losatom' ) 
		);
				
		parent::__construct( 
			'Losatom_Widget_Testimonial', 
			THEME_NAME . ' - ' . __( 'Testimonials', 'losatom' ), 
			$widget_options 
		);	
	}

	function form( $instance ) {

		$title    = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$subtitle = isset( $instance['subtitle'] ) ? esc_attr( $instance['subtitle'] ) : '';
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php _e( 'Title:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat widget-heading" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
		</p>			
		
		<p>
			<label for="<?php echo $this->get_field_id( 'subtitle' ); ?>">
				<?php _e( 'Subtitle:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'subtitle' ); ?>" name="<?php echo $this->get_field_name( 'subtitle' ); ?>" value="<?php echo $subtitle; ?>" />
		</p>	

		<?php 
		unset( $instance['title'] );
		unset( $instance['subtitle'] );
 		$i = 1; 
 		$instance = array_chunk( $instance, 6, true );
 		?>		
	
		<?php foreach( $instance as $accordion ) : ?>

	 		<div class="accordion">
				
				<span class="dashicons dashicons-trash delete-accordion"></span>

	 			<h5 class="accordion-title"><?php _e( 'Testimonial', 'losatom' ); ?> <span><?php echo $i++; ?></span></h5>
				
				<div class="accordion-content">
					
					<?php foreach( $accordion as $key => $value ) : ?>

						<?php if ( strpos( $key, 'image' ) !== false ) : ?>
							
							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Image Link:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_url( $value ); ?>" />
								<a class="button losatom-upload"><?php _e( 'Upload Image', 'losatom' ); ?></a>
							</p>				
						
		 				<?php elseif ( strpos( $key, 'name' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Name:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_attr( $value ); ?>" />
							</p>	
		 						
		 				<?php elseif ( strpos( $key, 'content' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Text:', 'losatom' ); ?>
								</label>
								<textarea class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>"><?php echo esc_attr( $value ); ?></textarea>			
							</p>	
						
		 				<?php elseif ( strpos( $key, 'linkedin' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Linkedin:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_url( $value ); ?>" />
							</p>							

		 				<?php elseif ( strpos( $key, 'facebook' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Facebook:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_url( $value ); ?>" />
							</p>	

		 				<?php elseif ( strpos( $key, 'twitter' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Twitter:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_url( $value ); ?>" />
							</p>								

						<?php endif; ?>					

					<?php endforeach; ?>								
					
				</div><!-- .accordion-content -->

			</div><!-- .accordion -->
		
		<?php endforeach; // End accordion foreach loop. ?>						 

		<a href="#" class="add-new-button button"><?php _e( 'Add New Testimonial', 'losatom' ); ?></a>
		
		<!-- ACCORDION FOR CLONING -->
		<div class="accordion for-cloning hidden">
			
			<span class="dashicons dashicons-trash delete-accordion"></span>

			<h5 class="accordion-title"><?php _e( 'Testimonial', 'losatom' ); ?> <span>__x__</span></h5>
			
			<div class="accordion-content">
				
				<p>
					<label for="widget-losatom_widget_testimonial-__x__-image___y__">
						<?php _e( 'Image:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_testimonial-__x__-image___y__" name="widget-losatom_widget_testimonial[__x__][image___y__]" value="" />
					<a class="button losatom-upload"><?php _e( 'Upload Image', 'losatom' ); ?></a>
				</p>	

				<p>
					<label for="widget-losatom_widget_testimonial-__x__-name___y__">
						<?php _e( 'Name:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_testimonial-__x__-name___y__" name="widget-losatom_widget_testimonial[__x__][name___y__]" value="" />
				</p>		

				<p>
					<label for="widget-losatom_widget_testimonial-__x__-content___y__">
						<?php _e( 'Content:', 'losatom' ); ?>
					</label>	
					<textarea class="widefat" id="widget-losatom_widget_testimonial-__x__-content___y__" name="widget-losatom_widget_testimonial[__x__][content___y__]"></textarea>			
				</p>		

				<p>
					<label for="widget-losatom_widget_testimonial-__x__-linkedin___y__">
						<?php _e( 'Linkedin:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_testimonial-__x__-linkedin___y__" name="widget-losatom_widget_testimonial[__x__][linkedin___y__]" value="" />
				</p>		

				<p>
					<label for="widget-losatom_widget_testimonial-__x__-facebook___y__">
						<?php _e( 'Facebook:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_testimonial-__x__-facebook___y__" name="widget-losatom_widget_testimonial[__x__][facebook___y__]" value="" />
				</p>		

				<p>
					<label for="widget-losatom_widget_testimonial-__x__-twitter___y__">
						<?php _e( 'Twitter:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_testimonial-__x__-twitter___y__" name="widget-losatom_widget_testimonial[__x__][twitter___y__]" value="" />
				</p>											

			</div><!-- .accordion-content -->

		</div><!-- .accordion -->
		<!-- END ACCORDION FOR CLONING -->
		
		<?php 
	}
	
	function update( $new_instance, $old_instance ) {

		foreach( $new_instance as $key => $value ) {
			if ( strpos( $key, 'image' ) !== false )
				$new_instance[$key] = esc_url_raw( $value );
			elseif ( strpos( $key, 'linkedin' ) !== false || strpos( $key, 'facebook' ) !== false || strpos( $key, 'twitter' ) !== false )
				$new_instance[$key] = esc_url_raw( $value );
			else
				$new_instance[$key] = esc_attr( $value );
		}
			
	    return $new_instance;

	}
	
	function widget( $args, $instance ) {
	
		extract( $args );

		$is_landing_page = is_losatom_landing_page();
		$is_lp = ( true === $is_landing_page ) ? 'true' : 'false';
		wp_enqueue_script( 'losatom-slider' );
		wp_localize_script( 'losatom-custom-js', 'testimonialVars', array(
			'testimonial' => true,
			'is_landing_page' => $is_lp
		) );			
		
		$title    = isset( $instance['title'] ) ? $instance['title'] : '' ;
		$subtitle = isset( $instance['subtitle'] ) ? $instance['subtitle'] : '';
		unset( $instance['title'] );
		unset( $instance['subtitle'] );

		echo $before_widget; 
		?>

		<?php echo ( $is_landing_page ) ? '<div class="wrap">' : ''; ?>


		<div class="section-info text-center">
		
			<?php if ( ! empty( $title ) ) : ?>
				<h2 class="section-title text-center"><?php echo esc_attr( $title ); ?></h2>
			<?php endif; ?>

			<?php if ( ! empty( $subtitle ) ) : ?>
				<p class="section-description text-center"><?php echo esc_attr( $subtitle ); ?></p>
		 	<?php endif; ?>
		
		</div><!-- .section-info -->

		
		<ul class="testimonial">
		
		<?php
		
		$instance = array_chunk( $instance, 6, true );

		foreach( $instance as $testimonial ) {
			
			$i = 1; 

			/* Create variables first. */
			foreach ( $testimonial as $key => $value ) {
				if ( $i == 1 ) // 1. image
					$image = esc_url( $value );
				elseif ( $i == 2 ) // 2. name
					$name = esc_attr( $value );
				elseif ( $i == 3 ) // 3. content
					$content = esc_attr( $value );
				elseif ( $i == 4 ) // 4. linkedin
					$linkedin = esc_url( $value );
				elseif ( $i == 5 ) // 5. facebook
					$facebook = esc_url( $value );
				elseif ( $i == 6 ) // 6. twitter
					$twitter = esc_url( $value );
															
				$i++;
			}

			$i = 0; ?>

			<li>

				<div class="testimonial-wrap">

					<?php if ( ! empty( $image ) ) : ?>

						<div class="testimonial-image">
							<img src="<?php echo $image; ?>" alt="<?php echo $name; ?>" />
						</div>

					<?php endif; ?>
									
					<?php if ( ! empty( $content ) ) : ?>

						<div class="testimonial-content">

							<p><?php echo $content; ?></p>

							<p class="testimonial-author">

								<?php if ( ! empty( $linkedin ) ) : ?>								
									<a href="<?php echo $linkedin; ?>"><i class="fa fa-linkedin-square"></i></a>
								<?php endif; ?>

								<?php if ( ! empty( $facebook ) ) : ?>								
									<a href="<?php echo $facebook; ?>"><i class="fa fa-facebook-square"></i></a>
								<?php endif; ?>

								<?php if ( ! empty( $twitter ) ) : ?>								
									<a href="<?php echo $twitter; ?>"><i class="fa fa-twitter-square"></i></a>
								<?php endif; ?>

								<?php if ( ! empty( $name ) ) : ?>
									<cite><?php echo $name; ?></cite>
								<?php endif; ?>

							</p>
						</div><!-- .testimonial-content -->

					<?php endif; ?>
				
				</div><!-- .testimonial-wrap -->
				
			</li>

		<?php 
		} // End testimonial foreach loop. ?>
		
		</ul>
	
		<?php echo ( $is_landing_page ) ? '</div>' : ''; ?>

		<?php echo $after_widget;	
	}
		 
}

?>