<?php

class Losatom_Widget_Features extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_features', 
			'description' => __( 'Displays features / services with icon.', 'losatom' ) 
		);		

		parent::__construct( 
			'Losatom_Widget_Features', 
			THEME_NAME . ' - ' . __( 'Features', 'losatom' ), 
			$widget_options
		);
	}
		
	function form( $instance ) {
 		
		$widget_title    = isset( $instance['widget_title'] ) ? esc_attr( $instance['widget_title'] ) : '';
		$widget_subtitle = isset( $instance['widget_subtitle'] ) ? esc_attr( $instance['widget_subtitle'] ) : '';
		$type            = isset( $instance['display_type'] ) ? esc_attr( $instance['display_type'] ) : 'left_aligned';	
		$columns         = isset( $instance['columns'] ) ? absint( $instance['columns'] ) : 2;	

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php _e( 'Title:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat widget-heading" id="<?php echo $this->get_field_id( 'widget_title' ); ?>" name="<?php echo $this->get_field_name( 'widget_title' ); ?>" value="<?php echo $widget_title; ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'widget_subtitle' ); ?>">
				<?php _e( 'Subtitle:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'widget_subtitle' ); ?>" name="<?php echo $this->get_field_name( 'widget_subtitle' ); ?>" value="<?php echo $widget_subtitle; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'columns' ); ?>">
				<?php _e( 'Number of columns per row:', 'losatom' ); ?>
			</label>
			<?php echo ( is_customize_preview() ) ? '<br>' : ''; ?>
			<select name="<?php echo $this->get_field_name( 'columns' ); ?>" id="<?php echo $this->get_field_id( 'columns' ); ?>" class="widefat">
				<?php for( $i = 1; $i < 7; $i++ ) : ?>
					<option <?php selected( $i, $columns ); ?> value="<?php echo $i; ?>"><?php echo $i; ?></option>
				<?php endfor; ?>
			</select>			 

		</p>		

		<p>
			<?php _e( 'Icons position:', 'losatom' ); ?> &nbsp; 
			<input type="radio" name="<?php echo $this->get_field_name( 'display_type' ); ?>" id="<?php echo $this->get_field_id( 'radio_1' ); ?>" value="centered" <?php echo checked( $type, 'centered' ); ?>>
			<label for="<?php echo $this->get_field_id( 'radio_1' ); ?>"><?php _e( 'Center', 'losatom' ); ?></label>  &nbsp;
			<input type="radio" name="<?php echo $this->get_field_name( 'display_type' ); ?>" id="<?php echo $this->get_field_id( 'radio_2' ); ?>" value="left_aligned" <?php echo checked( $type, 'left_aligned' ); ?>>
			<label for="<?php echo $this->get_field_id( 'radio_2' ); ?>"><?php _e( 'Left', 'losatom' ); ?></label>
		</p>

		<?php 
		unset( $instance['widget_title'] );
		unset( $instance['widget_subtitle'] );
		unset( $instance['display_type'] );
		unset( $instance['columns'] );
 		$i = 1; 
 		$instance = array_chunk( $instance, 4, true );
 		?>		

		<?php foreach( $instance as $accordion ) : ?>

	 		<div class="accordion">
				
				<span class="dashicons dashicons-trash delete-accordion"></span>

	 			<h5 class="accordion-title"><?php _e( 'Feature', 'losatom' ); ?> <span><?php echo $i++; ?></span></h5>
				
				<div class="accordion-content">
					
					<?php foreach( $accordion as $key => $value ) : ?> 		
				 	
						<?php if ( strpos( $key, 'title' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>"><?php _e( 'Title:', 'losatom' ); ?></label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_attr( $value ); ?>" />
							</p>	

						<?php elseif ( strpos( $key, 'text' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>"><?php _e( 'Text:', 'losatom' ); ?></label>
								<textarea name="<?php echo $this->get_field_name( $key ); ?>" id="<?php echo $this->get_field_id( $key ); ?>" class="widefat"><?php echo esc_textarea( $value ); ?></textarea>
							</p>			

						<?php elseif ( strpos( $key, 'font_icon' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Select Font Icon:', 'losatom' ); ?>
								</label>
								<?php echo ( is_customize_preview() ) ? '<br>' : ''; ?>
								<select name="<?php echo $this->get_field_name( $key ); ?>" id="<?php echo $this->get_field_id( $key ); ?>" class="widefat fpicker">
									<?php 	
					 				foreach( $this->icons as $icon ) {
					 					$icon = ( $icon == '' ) ? $icon : 'fa ' . $icon;
										echo '<option '. selected( $icon, esc_attr( $value ) ) .' value="'. $icon .'">'. $icon .'</option>';
					 				}
									?>
								</select>			 

							</p>

						<?php else : ?>											

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Icon Font Size:', 'losatom' ); ?>
								</label> 
								<input type="number" class="px-size" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo $value != '' ? absint( $value ) : 80; ?>" />
								<code>px</code>
							</p>
						
				 
						<?php endif; ?>

					<?php endforeach; ?>								
					
				</div><!-- .accordion-content -->

			</div><!-- .accordion -->
		
		<?php endforeach; // End accordion foreach loop. ?>

		<a href="#" class="add-new-button button"><?php _e( 'Add New Feature', 'losatom' ); ?></a>
	
		<!-- ACCORDION FOR CLONING -->
		<div class="accordion for-cloning hidden">
			
			<span class="dashicons dashicons-trash delete-accordion"></span>

			<h5 class="accordion-title"><?php _e( 'Feature', 'losatom' ); ?> <span>__x__</span></h5>
			
			<div class="accordion-content">
				
 				<p>
					<label for="widget-losatom_widget_features-__x__-title___y__">
						<?php _e( 'Title:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_features-__x__-title___y__" name="widget-losatom_widget_features[__x__][title___y__]" value="" />
				</p>					

				<p>
					<label for="widget-losatom_widget_features-__x__-text___y__">
						<?php _e( 'Text', 'losatom' ); ?>
					</label>	
					<textarea class="widefat" id="widget-losatom_widget_features-__x__-text___y__" name="widget-losatom_widget_features[__x__][text___y__]"></textarea>			
				</p>			

				<p>
					<label for="widget-losatom_widget_features-__x__-font_icon___y__">
						<?php _e( 'Font Icon:', 'losatom' ); ?>
					</label>	
					<select class="widefat fpicker" id="widget-losatom_widget_features-__x__-font_icon___y__" name="widget-losatom_widget_features[__x__][font_icon___y__]">
						<?php 	
		 				foreach( $this->icons as $icon ) {
		 					$icon = ( $icon == '' ) ? $icon : 'fa ' . $icon;
							echo '<option value="'. $icon .'">'. $icon .'</option>';
		 				}
						?>
					</select>				
				</p>	

 				<p>
					<label for="widget-losatom_widget_features-__x__-font_size___y__">
						<?php _e( 'Icon Font Size:', 'losatom' ); ?>
					</label>			
					<input type="number" class="px-size" id="widget-losatom_widget_features-__x__-font_size___y__" name="widget-losatom_widget_features[__x__][font_size___y__]" value="80" />
				</p>	
 	
			</div><!-- .accordion-content -->

		</div><!-- .accordion -->
		<!-- END ACCORDION FOR CLONING -->
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		foreach( $new_instance as $key => $value ) {
			if ( strpos( $key, 'font_size' ) !== false )
				$new_instance[$key] = absint( $value );
			elseif ( strpos( $key, 'columns' ) !== false )
				$new_instance[$key] = absint( $value );			
			else
				$new_instance[$key] = esc_attr( $value );
		}
			
	    return $new_instance;

	}
	
	function widget( $args, $instance ) {

		extract( $args );

		$title    = isset( $instance['widget_title'] ) ? esc_attr( $instance['widget_title'] ) : '';
		$subtitle = isset( $instance['widget_subtitle'] ) ? esc_attr( $instance['widget_subtitle'] ) : '';
		$type     = isset( $instance['display_type'] ) ? esc_attr( $instance['display_type'] ) : 'left_aligned';
		$columns  = isset( $instance['columns'] ) ? absint( $instance['columns'] ) : 2;

		$is_landing_page = is_losatom_landing_page();
		
	 	$replace = 'class="' . $type . ' ';
		echo str_replace( 'class="', $replace, $before_widget );
		?>

		<?php echo '<div class="wrap"><div class="row">'; ?>

		<?php if ( ! empty( $title ) && ! empty( $subtitle ) ) : ?>

			<div class="section-info text-center">
			
				<?php if ( ! empty( $title ) ) : ?>
					<h2 class="section-title text-center"><?php echo $title; ?></h2>
				<?php endif; ?>

				<?php if ( ! empty( $subtitle ) ) : ?>
					<p class="section-description text-center"><?php echo $subtitle; ?></p>
			 	<?php endif; ?>
			
			</div><!-- .section-info -->

		<?php endif; ?>		
		
		<?php 

		unset( $instance['widget_title'] );
		unset( $instance['widget_subtitle'] );
		unset( $instance['display_type'] );
		unset( $instance['columns'] );

		$instance = array_chunk( $instance, 4, true );

		foreach( $instance as $feature ) {
			
			$i = 1; 

			/* Create variables first. */
			foreach ( $feature as $key => $value ) {

				if ( $i == 1 ) // 1. title
					$title = isset( $value ) ? esc_attr( $value ) : '';

				elseif ( $i == 2 ) // 2. text
					$text = isset( $value ) ? esc_attr( $value ) : '';

				elseif ( $i == 3 ) // 3. font_icon
					$font_icon = isset( $value ) ? esc_attr( $value ) : '';

				else // 4. font_size
					$font_size = isset( $value ) ? absint( $value ) : '80';

				$i++;
			}

			$i = 0; 	

			echo '<div class="feature-wrap col-1-' . $columns . '">';

			if ( ! empty( $font_icon ) ) {
				echo '<div class="feature-icon">'
					.'<i style="font-size: '. absint( $font_size ) .'px" class="'. $font_icon .'" data-sr="enter top move 50px over .7s"></i>'
					.'</div>';
			}

			echo '<div class="feature-content">';

			if ( ! empty( $title ) )
				echo '<h4 class="feature-content-title">' . strip_tags ( $title ) . '</h4>';		

			if ( ! empty( $text ) )		
				echo '<p>' . strip_tags( $text ) . '</p>';

			echo '</div><!--.feature-content-->';
			echo '</div><!--.col-1-' . $columns . '-->';

		}

		echo '</div><!-- .row --> </div><!-- .wrap -->';

 		echo $after_widget;	

	}

	protected $icons = array('custom-disable',
'fa-glass','fa-music','fa-search','fa-envelope-o','fa-heart','fa-star','fa-star-o','fa-user','fa-film','fa-th-large','fa-th','fa-th-list','fa-check','fa-remove','fa-close','fa-times','fa-search-plus','fa-search-minus','fa-power-off','fa-signal','fa-gear','fa-cog','fa-trash-o','fa-home','fa-file-o','fa-clock-o','fa-road','fa-download','fa-arrow-circle-o-down','fa-arrow-circle-o-up','fa-inbox','fa-play-circle-o','fa-rotate-right','fa-repeat','fa-refresh','fa-list-alt','fa-lock','fa-flag','fa-headphones','fa-volume-off','fa-volume-down','fa-volume-up','fa-qrcode','fa-barcode','fa-tag','fa-tags','fa-book','fa-bookmark','fa-print','fa-camera','fa-font','fa-bold','fa-italic','fa-text-height','fa-text-width','fa-align-left','fa-align-center','fa-align-right','fa-align-justify','fa-list','fa-dedent','fa-outdent','fa-indent','fa-video-camera','fa-photo','fa-image','fa-picture-o','fa-pencil','fa-map-marker','fa-adjust','fa-tint','fa-edit','fa-pencil-square-o','fa-share-square-o','fa-check-square-o','fa-arrows','fa-step-backward','fa-fast-backward','fa-backward','fa-play','fa-pause','fa-stop','fa-forward','fa-fast-forward','fa-step-forward','fa-eject','fa-chevron-left','fa-chevron-right','fa-plus-circle','fa-minus-circle','fa-times-circle','fa-check-circle','fa-question-circle','fa-info-circle','fa-crosshairs','fa-times-circle-o','fa-check-circle-o','fa-ban','fa-arrow-left','fa-arrow-right','fa-arrow-up','fa-arrow-down','fa-mail-forward','fa-share','fa-expand','fa-compress','fa-plus','fa-minus','fa-asterisk','fa-exclamation-circle','fa-gift','fa-leaf','fa-fire','fa-eye','fa-eye-slash','fa-warning','fa-exclamation-triangle','fa-plane','fa-calendar','fa-random','fa-comment','fa-magnet','fa-chevron-up','fa-chevron-down','fa-retweet','fa-shopping-cart','fa-folder','fa-folder-open','fa-arrows-v','fa-arrows-h','fa-bar-chart-o','fa-bar-chart','fa-twitter-square','fa-facebook-square','fa-camera-retro','fa-key','fa-gears','fa-cogs','fa-comments','fa-thumbs-o-up','fa-thumbs-o-down','fa-star-half','fa-heart-o','fa-sign-out','fa-linkedin-square','fa-thumb-tack','fa-external-link','fa-sign-in','fa-trophy','fa-github-square','fa-upload','fa-lemon-o','fa-phone','fa-square-o','fa-bookmark-o','fa-phone-square','fa-twitter','fa-facebook-f','fa-facebook','fa-github','fa-unlock','fa-credit-card','fa-rss','fa-hdd-o','fa-bullhorn','fa-bell','fa-certificate','fa-hand-o-right','fa-hand-o-left','fa-hand-o-up','fa-hand-o-down','fa-arrow-circle-left','fa-arrow-circle-right','fa-arrow-circle-up','fa-arrow-circle-down','fa-globe','fa-wrench','fa-tasks','fa-filter','fa-briefcase','fa-arrows-alt','fa-group','fa-users','fa-chain','fa-link','fa-cloud','fa-flask','fa-cut','fa-scissors','fa-copy','fa-files-o','fa-paperclip','fa-save','fa-floppy-o','fa-square','fa-navicon','fa-reorder','fa-bars','fa-list-ul','fa-list-ol','fa-strikethrough','fa-underline','fa-table','fa-magic','fa-truck','fa-pinterest','fa-pinterest-square','fa-google-plus-square','fa-google-plus','fa-money','fa-caret-down','fa-caret-up','fa-caret-left','fa-caret-right','fa-columns','fa-unsorted','fa-sort','fa-sort-down','fa-sort-desc','fa-sort-up','fa-sort-asc','fa-envelope','fa-linkedin','fa-rotate-left','fa-undo','fa-legal','fa-gavel','fa-dashboard','fa-tachometer','fa-comment-o','fa-comments-o','fa-flash','fa-bolt','fa-sitemap','fa-umbrella','fa-paste','fa-clipboard','fa-lightbulb-o','fa-exchange','fa-cloud-download','fa-cloud-upload','fa-user-md','fa-stethoscope','fa-suitcase','fa-bell-o','fa-coffee','fa-cutlery','fa-file-text-o','fa-building-o','fa-hospital-o','fa-ambulance','fa-medkit','fa-fighter-jet','fa-beer','fa-h-square','fa-plus-square','fa-angle-double-left','fa-angle-double-right','fa-angle-double-up','fa-angle-double-down','fa-angle-left','fa-angle-right','fa-angle-up','fa-angle-down','fa-desktop','fa-laptop','fa-tablet','fa-mobile-phone','fa-mobile','fa-circle-o','fa-quote-left','fa-quote-right','fa-spinner','fa-circle','fa-mail-reply','fa-reply','fa-github-alt','fa-folder-o','fa-folder-open-o','fa-smile-o','fa-frown-o','fa-meh-o','fa-gamepad','fa-keyboard-o','fa-flag-o','fa-flag-checkered','fa-terminal','fa-code','fa-mail-reply-all','fa-reply-all','fa-star-half-empty','fa-star-half-full','fa-star-half-o','fa-location-arrow','fa-crop','fa-code-fork','fa-unlink','fa-chain-broken','fa-question','fa-info','fa-exclamation','fa-superscript','fa-subscript','fa-eraser','fa-puzzle-piece','fa-microphone','fa-microphone-slash','fa-shield','fa-calendar-o','fa-fire-extinguisher','fa-rocket','fa-maxcdn','fa-chevron-circle-left','fa-chevron-circle-right','fa-chevron-circle-up','fa-chevron-circle-down','fa-html5','fa-css3','fa-anchor','fa-unlock-alt','fa-bullseye','fa-ellipsis-h','fa-ellipsis-v','fa-rss-square','fa-play-circle','fa-ticket','fa-minus-square','fa-minus-square-o','fa-level-up','fa-level-down','fa-check-square','fa-pencil-square','fa-external-link-square','fa-share-square','fa-compass','fa-toggle-down','fa-caret-square-o-down','fa-toggle-up','fa-caret-square-o-up','fa-toggle-right','fa-caret-square-o-right','fa-euro','fa-eur','fa-gbp','fa-dollar','fa-usd','fa-rupee','fa-inr','fa-cny','fa-rmb','fa-yen','fa-jpy','fa-ruble','fa-rouble','fa-rub','fa-won','fa-krw','fa-bitcoin','fa-btc','fa-file','fa-file-text','fa-sort-alpha-asc','fa-sort-alpha-desc','fa-sort-amount-asc','fa-sort-amount-desc','fa-sort-numeric-asc','fa-sort-numeric-desc','fa-thumbs-up','fa-thumbs-down','fa-youtube-square','fa-youtube','fa-xing','fa-xing-square','fa-youtube-play','fa-dropbox','fa-stack-overflow','fa-instagram','fa-flickr','fa-adn','fa-bitbucket','fa-bitbucket-square','fa-tumblr','fa-tumblr-square','fa-long-arrow-down','fa-long-arrow-up','fa-long-arrow-left','fa-long-arrow-right','fa-apple','fa-windows','fa-android','fa-linux','fa-dribbble','fa-skype','fa-foursquare','fa-trello','fa-female','fa-male','fa-gittip','fa-gratipay','fa-sun-o','fa-moon-o','fa-archive','fa-bug','fa-vk','fa-weibo','fa-renren','fa-pagelines','fa-stack-exchange','fa-arrow-circle-o-right','fa-arrow-circle-o-left','fa-toggle-left','fa-caret-square-o-left','fa-dot-circle-o','fa-wheelchair','fa-vimeo-square','fa-turkish-lira','fa-try','fa-plus-square-o','fa-space-shuttle','fa-slack','fa-envelope-square','fa-wordpress','fa-openid','fa-institution','fa-bank','fa-university','fa-mortar-board','fa-graduation-cap','fa-yahoo','fa-google','fa-reddit','fa-reddit-square','fa-stumbleupon-circle','fa-stumbleupon','fa-delicious','fa-digg','fa-pied-piper','fa-pied-piper-alt','fa-drupal','fa-joomla','fa-language','fa-fax','fa-building','fa-child','fa-paw','fa-spoon','fa-cube','fa-cubes','fa-behance','fa-behance-square','fa-steam','fa-steam-square','fa-recycle','fa-automobile','fa-car','fa-cab','fa-taxi','fa-tree','fa-spotify','fa-deviantart','fa-soundcloud','fa-database','fa-file-pdf-o','fa-file-word-o','fa-file-excel-o','fa-file-powerpoint-o','fa-file-photo-o','fa-file-picture-o','fa-file-image-o','fa-file-zip-o','fa-file-archive-o','fa-file-sound-o','fa-file-audio-o','fa-file-movie-o','fa-file-video-o','fa-file-code-o','fa-vine','fa-codepen','fa-jsfiddle','fa-life-bouy','fa-life-buoy','fa-life-saver','fa-support','fa-life-ring','fa-circle-o-notch','fa-ra','fa-rebel','fa-ge','fa-empire','fa-git-square','fa-git','fa-hacker-news','fa-tencent-weibo','fa-qq','fa-wechat','fa-weixin','fa-send','fa-paper-plane','fa-send-o','fa-paper-plane-o','fa-history','fa-genderless','fa-circle-thin','fa-header','fa-paragraph','fa-sliders','fa-share-alt','fa-share-alt-square','fa-bomb','fa-soccer-ball-o','fa-futbol-o','fa-tty','fa-binoculars','fa-plug','fa-slideshare','fa-twitch','fa-yelp','fa-newspaper-o','fa-wifi','fa-calculator','fa-paypal','fa-google-wallet','fa-cc-visa','fa-cc-mastercard','fa-cc-discover','fa-cc-amex','fa-cc-paypal','fa-cc-stripe','fa-bell-slash','fa-bell-slash-o','fa-trash','fa-copyright','fa-at','fa-eyedropper','fa-paint-brush','fa-birthday-cake','fa-area-chart','fa-pie-chart','fa-line-chart','fa-lastfm','fa-lastfm-square','fa-toggle-off','fa-toggle-on','fa-bicycle','fa-bus','fa-ioxhost','fa-angellist','fa-cc','fa-shekel','fa-sheqel','fa-ils','fa-meanpath','fa-buysellads','fa-connectdevelop','fa-dashcube','fa-forumbee','fa-leanpub','fa-sellsy','fa-shirtsinbulk','fa-simplybuilt','fa-skyatlas','fa-cart-plus','fa-cart-arrow-down','fa-diamond','fa-ship','fa-user-secret','fa-motorcycle','fa-street-view','fa-heartbeat','fa-venus','fa-mars','fa-mercury','fa-transgender','fa-transgender-alt','fa-venus-double','fa-mars-double','fa-venus-mars','fa-mars-stroke','fa-mars-stroke-v','fa-mars-stroke-h','fa-neuter','fa-facebook-official','fa-pinterest-p','fa-whatsapp','fa-server','fa-user-plus','fa-user-times','fa-hotel','fa-bed','fa-viacoin','fa-train','fa-subway','fa-medium',
	);

}

?>