<?php 

/* Register theme widgets. */
add_action( 'widgets_init', 'losatom_register_widgets' ); 

/** 
 * Registers custom widgets.
 *
 * @since  1.0.0
 * @access public
 * @return void
 */
function losatom_register_widgets() {
	
	/* Define THEME_NAME constant for use in widget titles (backend). */
	$theme = wp_get_theme();		
	
	defined( 'THEME_NAME' ) or define( 'THEME_NAME', $theme->get( 'Name' ) );	
	defined( 'THEME_DIR' )  or define( 'THEME_DIR', trailingslashit( get_template_directory() ) );

	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-slider.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-countdown.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-features.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-call-to-action.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-article.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-pricing-table.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-testimonial.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-popular-posts.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-latest-posts.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-video.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-contact.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-social.php' );
	require_once( trailingslashit( THEME_DIR ) . 'inc/widget-article-fullwidth.php' );
	
	register_widget( 'Losatom_Widget_Slider' );	
	register_widget( 'Losatom_Widget_Countdown' );	
	register_widget( 'Losatom_Widget_Features' );	
	register_widget( 'Losatom_Widget_CTA' );	
	register_widget( 'Losatom_Widget_Article' );	
	register_widget( 'Losatom_Widget_Article_FW' );	
	register_widget( 'Losatom_Widget_Table' );	
	register_widget( 'Losatom_Widget_Testimonial' );	
	register_widget( 'Losatom_Widget_Popular' );	
	register_widget( 'Losatom_Widget_Video' );	
	register_widget( 'Losatom_Widget_Latest_Posts' );	
	register_widget( 'Losatom_Widget_Contact' );	
	register_widget( 'Losatom_Widget_Social' );	

}	

/* Load JS and CSS for widgets. */
add_action( 'admin_enqueue_scripts', 'widget_load_scripts' );


/** 
 * Adds styles and scripts for widgets.
 *
 * @since  1.0.0
 * @access public
 * @return void
 */
function widget_load_scripts( $hook ) {
	
	if ( $hook != 'widgets.php' ) 
		return;
		
	$theme_dir = trailingslashit( get_template_directory_uri() );
	
	/* Required for custom upload buttons in widgets. */
	wp_enqueue_media();			
	
	/* Font Icon Font */
	wp_register_style( 'font-awesome', $theme_dir . 'admin/css/font-awesome.min.css' );
	wp_enqueue_style( 'font-awesome' );
	
	wp_enqueue_style( 'losatom-widgets', $theme_dir . 'admin/css/admin.css' );			

	/* Font icon picker style. */
	wp_enqueue_style( 'losatom-fip', $theme_dir . 'admin/css/jquery.fonticonpicker.min.css' );			

	/* Font icon picker script. */
	wp_enqueue_script( 
		'losatom-fipjs', 
		$theme_dir . 'admin/js/jquery.fonticonpicker.min.js',
		array( 'jquery' ), 
		null, 
		true 
	);		

	wp_enqueue_script( 
		'losatom-admin-widgets', 
		$theme_dir . 'admin/js/widgets.js', 
		array( 'jquery' ), 
		null, 
		true 
	);	

}
?>