<?php if ( is_active_sidebar( 'subsidiary' ) ) : // If the sidebar has widgets. ?>

	<aside <?php hybrid_attr( 'sidebar', 'subsidiary' ); ?>>

		<?php dynamic_sidebar( 'subsidiary' ); // Displays the subsidiary sidebar. ?>

 	</aside><!-- #sidebar-subsidiary -->

<?php else : ?>

	<aside id="sidebar-subsidiary" class=" section" role="complementary" aria-label="Subsidiary Sidebar" itemscope="itemscope" itemtype="http://schema.org/WPSideBar">
		
		<?php 

		the_widget(
			'Losatom_Widget_Contact',
			array(	
				'email'    => 'example@email.com',
				'phone'    => '+1 916-452-7874',
				'location' => '2 Daly Ave, Ottawa, Canada',
			),
			array(
				'before_widget' => '<div class="widget losatom_widget_contact">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
				'widget_id'     => 'cta'
			)
		);

		the_widget(
			'Losatom_Widget_Social',
			array(	
				'facebook'   => 'http://facebook.com',
				'twitter'    => 'http://twitter.com',
				'googleplus' => 'http://plus.google.com',
				'youtube'    => 'http://youtube.com',
				'linkedin'   => 'http://linkedin.com',
				'instagram'  => 'http://instagram.com',
				'pinterest'  => 'http://pinterest.com',
				'github'     => 'http://github.com',
			),
			array(
				'before_widget' => '<div class="widget losatom_widget_social">',
				'after_widget'  => '</div>',
			)
		);

		 ?>

	</aside>

<?php endif; // End widgets check. ?>

