<?php if ( true === losatom_display_on_front() ) : // Checks whether to show loop meta or not. ?>

	<?php 
	$loop_attr = hybrid_get_attr( 'loop-meta' ); 
	$theme_dir = trailingslashit( get_template_directory_uri() );
	$bg        = get_theme_mod( 'loop_img', $theme_dir . 'images/sep.jpg' );
	$loop_attr = str_replace( 'class', 'style="background-image: url('. $bg .');" class', $loop_attr );
	?>

	<div <?php echo $loop_attr; ?>>
		
		<div class="wrap">

			<?php 
			if ( is_front_page() || is_home() || is_singular() ) : 
				$title =  get_theme_mod( 'loop_title', __( 'From the blog', 'losatom' ) ); 
				$desc  = '<p>' . get_theme_mod( 'loop_subtitle', __( 'Latest posts from our blog', 'losatom' ) ) . '</p>';		
			elseif ( is_404() ) : 
				$title = 'Nothing Found';
				$desc  = '<p>'. __( 'Apologies, but no entries were found.', 'losatom' ) . '</p>';
				
			else : 
				$title = hybrid_get_loop_title(); 
				$desc  = hybrid_get_loop_description();
				
				if ( empty( $desc ) ) {
					// If there's no category description.
					if ( is_category() ) {
						$text = __( 'You are browsing the category', 'losatom' );
						$desc = '<p>' . $text . ' '. $title . '.</p>';
					}

					if ( is_author() )
						$desc = '<p>' . __( 'All posts by this author page' , 'losatom' ) . '</p>';

					if ( is_tag() )
						$desc = '<p>' . __( 'You are browsing posts tagged with' , 'losatom' ) . ' ' . $title . '.</p>';
				}
		 
			endif; 
			?>

			<h1 <?php hybrid_attr( 'loop-title' ); ?>><?php echo $title; ?></h1>

			<?php hybrid_get_menu( 'breadcrumbs' ); // Loads the menu/breadcrumbs.php template. ?>		

		</div><!-- .wrap -->

	</div><!-- .loop-meta -->

<?php endif; // End loop meta check. ?>