(function( $ ) {

	/*
	 * Shows a live preview of changing the site title.
	 */
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			if ( ! $( '#site-title img' ).length ) 
				$( '#site-title a' ).html( to );
		} ); // value.bind
	} ); // wp.customize

	/*
	 * Shows a live preview of changing the site description.
	 */
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '#site-description' ).html( to );
		} ); // value.bind

	} ); // wp.customize	

	/*
	 * Shows a live preview of changing the call text.
	 */ 
	wp.customize( 'call_text', function( value ) {
		value.bind( function( to ) {
			var span = $( '#phone-number span' ).clone();
			$( '#phone-number' ).text( to ).append( span );
		});
	});	

	/*
	 * Shows a live preview of changing the phone number.
	 */ 
	wp.customize( 'phone_number', function( value ) {
		value.bind( function( to ) {
			$( '#phone-number span' ).text( to );
		});
	});	

	/*
	 * Shows a live preview of changing the loop / blog title.
	 */ 
	wp.customize( 'loop_title', function( value ) {
		value.bind( function( to ) {
			$( '.loop-title' ).text( to );
		});
	});	 

	/*
	 * Shows a live preview of changing footer text.
	 */ 
	wp.customize( 'footer_text', function( value ) {
		value.bind( function( to ) {
			$( '.credit span' ).text( to );
		});
	});	 

}( jQuery ));