<?php

class Losatom_Widget_Video extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_video', 
			'description' => __( 'Displays video.', 'losatom' ) 
		);		

		parent::__construct( 
			'losatom_widget_video', 
			THEME_NAME . ' - ' . __( 'Video', 'losatom' ), 
			$widget_options 
		);	
	}

	function form( $instance ) {

		$title    = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';				
		$subtitle = isset( $instance['subtitle'] ) ? esc_attr( $instance['subtitle'] ) : '';				
		$content  = isset( $instance['content'] ) ? esc_textarea( $instance['content'] ) : '';				
		
		?>
	
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php _e( 'Title:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
		</p>		

		<p>
			<label for="<?php echo $this->get_field_id( 'subtitle' ); ?>">
				<?php _e( 'Subtitle:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'subtitle' ); ?>" name="<?php echo $this->get_field_name( 'subtitle' ); ?>" value="<?php echo $subtitle; ?>" />
		</p>				 

		<p>
			<label for="<?php echo $this->get_field_id( 'content' ); ?>">
				<?php _e( 'Content:', 'losatom' ); ?>
			</label>
			<textarea class="widefat" cols="8" rows="8" id="<?php echo $this->get_field_id('content'); ?>" name="<?php echo $this->get_field_name('content'); ?>"><?php echo $content; ?></textarea>			
		</p>		
		 	
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
		
		$instance['title']    = esc_attr( $new_instance['title'] ); 
		$instance['subtitle'] = esc_attr( $new_instance['subtitle'] ); 

		if ( current_user_can('unfiltered_html') )
			$instance['content'] =  $new_instance['content'];
		else
			$instance['content'] = stripslashes( wp_filter_post_kses( addslashes( $new_instance['content'] ) ) ); // wp_filter_post_kses() expects slashed

	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$title    = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$subtitle = isset( $instance['subtitle'] ) ? esc_attr( $instance['subtitle'] ) : '';
		$content  = isset( $instance['content'] ) ? $instance['content'] : '';
		
		echo $before_widget; ?>
 		
		<?php if ( ! empty( $title ) && ! empty( $subtitle ) ) : ?>

			<div class="section-info text-center">
			
				<?php if ( ! empty( $title ) ) : ?>
					<h2 class="section-title text-center"><?php echo $title; ?></h2>
				<?php endif; ?>

				<?php if ( ! empty( $subtitle ) ) : ?>
					<p class="section-description text-center"><?php echo $subtitle; ?></p>
			 	<?php endif; ?>
			
			</div><!-- .section-info -->

		<?php endif; ?>		

 		<?php 

 		echo '<div class="wrap">' . $content . '</div>';



		echo $after_widget;	
 	}
		 
}

?>