<?php

class Losatom_Widget_Table extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_table', 
			'description' => __( 'Displays pricing tables.', 'losatom' ) 
		);	
			
		parent::__construct( 
			'Losatom_Widget_Table', 
			THEME_NAME . ' - ' . __( 'Pricing Tables', 'losatom' ), 
			$widget_options 
		);			
	}
		
	function form( $instance ) {

		$widget_title    = isset( $instance['widget_title'] ) ? esc_attr( $instance['widget_title'] ) : '';
		$widget_subtitle = isset( $instance['widget_subtitle'] ) ? esc_attr( $instance['widget_subtitle'] ) : '';

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php _e( 'Title', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat widget-heading" id="<?php echo $this->get_field_id( 'widget_title' ); ?>" name="<?php echo $this->get_field_name( 'widget_title' ); ?>" value="<?php echo $widget_title; ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'widget_subtitle' ); ?>">
				<?php _e( 'Subtitle:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'widget_subtitle' ); ?>" name="<?php echo $this->get_field_name( 'widget_subtitle' ); ?>" value="<?php echo $widget_subtitle; ?>" />
		</p>					
 
		<?php 
		unset( $instance['widget_title'] );
		unset( $instance['widget_subtitle'] );
 		$i = 1; 
 		$instance = array_chunk( $instance, 6, true );
 		?>		

		<?php foreach( $instance as $accordion ) : ?>

	 		<div class="accordion">
				
				<span class="dashicons dashicons-trash delete-accordion"></span>

	 			<h5 class="accordion-title"><?php _e( 'Table', 'losatom' ); ?> <span><?php echo $i++; ?></span></h5>
				
				<div class="accordion-content">
					
					<?php foreach( $accordion as $key => $value ) : ?> 		

						<?php if ( strpos( $key, 'title' ) !== false ) : ?>						

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Table Title:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_attr( $value ); ?>" />
							</p>	
						
						<?php elseif ( strpos( $key, 'price' ) !== false ) : ?>						

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>"><?php _e( 'Price:', 'losatom' ); ?></label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_attr( $value ); ?>" />
							</p>				

						<?php elseif ( strpos( $key, 'duration' ) !== false ) : ?>		

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Duration:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_attr( $value ); ?>" />
							</p>	

						<?php elseif ( strpos( $key, 'content' ) !== false ) : ?>								

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Content items (one per line)', 'losatom' ); ?>
								</label>
								<textarea class="widefat" rows="10" cols="10" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>"><?php echo esc_textarea( $value ); ?></textarea>			
							</p>					

						<?php elseif ( strpos( $key, 'button_text' ) !== false ) : ?>								
						
							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Button Text:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_attr( $value ); ?>" />
							</p>	

						<?php else : ?>											
				 
							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Button Link:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_url( $value ); ?>" />
							</p>	

						<?php endif; ?>

					<?php endforeach; ?>								
					
				</div><!-- .accordion-content -->

			</div><!-- .accordion -->
		
		<?php endforeach; // End accordion foreach loop. ?>

		<a href="#" class="add-new-button button"><?php _e( 'Add New Table', 'losatom' ); ?></a>

		<!-- ACCORDION FOR CLONING -->
		<div class="accordion for-cloning hidden">
			
			<span class="dashicons dashicons-trash delete-accordion"></span>

			<h5 class="accordion-title"><?php _e( 'Table', 'losatom' ); ?> <span>__x__</span></h5>
			
			<div class="accordion-content">
				
				<p>
					<label for="widget-losatom_widget_table-__x__-title___y__">
						<?php _e( 'Table Title:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_table-__x__-title___y__" name="widget-losatom_widget_table[__x__][title___y__]" value="" />
				</p>	

				<p>
					<label for="widget-losatom_widget_table-__x__-price___y__">
						<?php _e( 'Table Price:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_table-__x__-price___y__" name="widget-losatom_widget_table[__x__][price___y__]" value="" />
				</p>	

				<p>
					<label for="widget-losatom_widget_table-__x__-duration___y__">
						<?php _e( 'Duration:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_table-__x__-duration___y__" name="widget-losatom_widget_table[__x__][duration___y__]" value="" />
				</p>	

				<p>
					<label for="widget-losatom_widget_table-__x__-content___y__">
						<?php _e( 'Content items (one per line) 4', 'losatom' ); ?>
					</label>	
					<textarea rows="10" cols="10" class="widefat" id="widget-losatom_widget_table-__x__-content___y__" name="widget-losatom_widget_table[__x__][content___y__]"></textarea>			
				</p>		

				<p>
					<label for="widget-losatom_widget_table-__x__-button_text___y__">
						<?php _e( 'Button Text:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_table-__x__-button_text___y__" name="widget-losatom_widget_table[__x__][button_text___y__]" value="" />
				</p>	

				<p>
					<label for="widget-losatom_widget_table-__x__-button_link___y__">
						<?php _e( 'Button Text:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_table-__x__-button_link___y__" name="widget-losatom_widget_table[__x__][button_link___y__]" value="" />
				</p>									

			</div><!-- .accordion-content -->

		</div><!-- .accordion -->
		<!-- END ACCORDION FOR CLONING -->
 	
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {

		foreach( $new_instance as $key => $value ) {
			if ( strpos( $key, 'button_link' ) !== false )
				$new_instance[$key] = esc_url_raw( $value );
			elseif ( strpos( $key, 'content' ) !== false )
				$new_instance[$key] = esc_textarea( $value );
			else
				$new_instance[$key] = esc_attr( $value );
		}
			
	    return $new_instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );

		$is_landing_page = is_losatom_landing_page();
		
		$title    = isset( $instance['widget_title'] ) ? $instance['widget_title'] : '' ;
		$subtitle = isset( $instance['widget_subtitle'] ) ? $instance['widget_subtitle'] : '';
		unset( $instance['widget_title'] );
		unset( $instance['widget_subtitle'] );

		echo $before_widget; 
		?>

		<?php echo '<div class="wrap"><div class="row">'; ?>

		<div class="section-info text-center">
		
			<?php if ( ! empty( $title ) ) : ?>
				<h2 class="section-title text-center"><?php echo esc_attr( $title ); ?></h2>
			<?php endif; ?>

			<?php if ( ! empty( $subtitle ) ) : ?>
				<p class="section-description text-center"><?php echo esc_attr( $subtitle ); ?></p>
		 	<?php endif; ?>
		
		</div><!-- .section-info -->

		<?php 

		$instance = array_chunk( $instance, 6, true );

		foreach( $instance as $table ) {
			
			$i = 1; 

			/* Create variables first. */
			foreach ( $table as $key => $value ) {

				if ( $i == 1 ) // 1. title
					$title = isset( $value ) ? esc_attr( $value ) : '';

				elseif ( $i == 2 ) // 2. price
					$price = isset( $value ) ? esc_attr( $value ) : '';

				elseif ( $i == 3 ) // 3. duration
					$duration = isset( $value ) ? esc_attr( $value ) : '';

				elseif ( $i == 4 ) // 4. content
					$content = isset( $value ) ? esc_attr( $value ) : '';

				elseif ( $i == 5 ) // 5. button_text
					$button_text = isset( $value ) ? esc_attr( $value ) : '';

				else // 6. button_link
					$button_link = isset( $value ) ? esc_url( $value ) : '#';

				$i++;
			}

			$i = 0; 		
			$count     = count( $instance );
			$css_class = $count > 4 ? 4 : $count;	

			$animation = '';

			if ( $is_landing_page ) 
				$animation = 'data-sr="enter top move 100px over 1s"';

			echo '<div class="col-1-' . $css_class .'"'. $animation .'>';

			if ( ! empty( $title ) )
				echo '<h3 class="table-title">' . $title . '</h3>';

			$table = '';

			$table .= '<div class="table-price-wrap">';

			if ( ! empty( $price ) )
				$table .= '<span class="table-price">' . $price .'</span>';

			if ( ! empty( $duration ) ) 
				$table .= '<span class="table-duration">/' . $duration . '</span>';

			$table .= '</div>';
			
			if ( ! empty( $content ) ) {
				$content = trim( $content );
				$table .= '<ul class="table-list">';
				$table .= '<li>';
				$table .= str_replace( "\n", '</li><li>', $content );
				$table .= '</li>';  
				$table .= '</ul>';
			}

			if ( ! empty( $button_text ) ) 
				$table .= '<a class="button table-button" href="'. $button_link .'">'. $button_text .'</a>';
			
			if ( ! empty( $table ) ) 
				echo '<div class="table-content">' . $table . '</div>';

			echo '</div>';
		}
		

	echo '</div><!-- .row --></div><!-- .wrap -->'; 

	echo $after_widget;	
 	
 	}
		 
}

?>