<?php 

class Losatom_Widget_Countdown extends WP_Widget {

	function __construct() {

		$options = array(
			'classname'   => 'losatom_widget_countdown',
			'description' => __( 'Displays time left until some event.', 'losatom' )
		);

		parent::__construct( 
			'Losatom_Widget_Countdown', 
			THEME_NAME . ' - ' . __( 'Countdown', 'losatom' ), 
			$options
		);
	}

	function form( $instance ) {
		
		$month   = isset( $instance['month'] ) ? esc_attr( $instance['month'] ) : date('M');				
		$day     = isset( $instance['day'] ) ? (int)( $instance['day'] ) : date('d');				
		$year    = isset( $instance['year'] ) ? (int)( $instance['year'] ) : date('Y');				
		$hours   = isset( $instance['hours'] ) ? $this->losatom_leading_zero( $instance['hours'] ) : date('H');		
		$minutes = isset( $instance['minutes'] ) ? $this->losatom_leading_zero( $instance['minutes'] ) : date('i');	

		/* Time string localizations, singular and plural. */
		$day_s  = isset( $instance['day_s'] ) ? esc_attr( $instance['day_s'] ) : 'day';
		$day_m  = isset( $instance['day_m'] ) ? esc_attr( $instance['day_m'] ) : 'days';
		
		$hour_s = isset( $instance['hour_s'] ) ? esc_attr( $instance['hour_s'] ) : 'hour';
		$hour_m = isset( $instance['hour_m'] ) ? esc_attr( $instance['hour_m'] ) : 'hours';
		
		$min_s  = isset( $instance['min_s'] ) ? esc_attr( $instance['min_s'] ) : 'minute';
		$min_m  = isset( $instance['min_m'] ) ? esc_attr( $instance['min_m'] ) : 'minutes';
		
		$sec_s  = isset( $instance['sec_s'] ) ? esc_attr( $instance['sec_s'] ) : 'second';
		$sec_m  = isset( $instance['sec_m'] ) ? esc_attr( $instance['sec_m'] ) : 'seconds';
		?>
		
		<p>		
			<label><?php _e( 'Set Event Date:', 'losatom' ); ?></label><br />
			<select name="<?php echo $this->get_field_name( 'month' ); ?>">
				<?php 
				$months = array( 
					'Jan' => __( '01-Jan', 'losatom' ),
					'Feb' => __( '02-Feb', 'losatom' ),
					'Mar' => __( '03-Mar', 'losatom' ),
					'Apr' => __( '04-Apr', 'losatom' ),
					'May' => __( '05-May', 'losatom' ),
					'Jun' => __( '06-Jun', 'losatom' ),
					'Jul' => __( '07-Jul', 'losatom' ),
					'Aug' => __( '08-Aug', 'losatom' ),
					'Sep' => __( '09-Sep', 'losatom' ),
					'Oct' => __( '10-Oct', 'losatom' ),
					'Nov' => __( '11-Nov', 'losatom' ),
					'Dec' => __( '12-Dec', 'losatom' ),
				);
				foreach( $months as $key => $value )
					echo '<option value="'. $key .'" '. selected( $key, $month ) .'>'. $value .'</option>';
				?>
			</select>
			
			<input class="ct-date" type="text" maxlength="2" size="2" name="<?php echo $this->get_field_name( 'day' ); ?>" value="<?php echo $day; ?>" />

			<input class="ct-date" type="text" maxlength="4" size="4" value="<?php echo $year; ?>" name="<?php echo $this->get_field_name( 'year' ); ?>">

		<?php if ( is_customize_preview() ) : ?>
		</p>
		<p> 
	 		<label for="<?php echo $this->get_field_id( 'hours' ); ?>">
	 			<?php _e( 'Hours:', 'losatom' ); ?>	
			</label>
	 		<label for="<?php echo $this->get_field_id( 'minutes' ); ?>">
	 			&nbsp;&nbsp;  <?php _e( 'Minutes:', 'losatom' ); ?>	
			</label><br>
		
		<?php endif; ?>

			<input class="ct-date" id="<?php echo $this->get_field_id( 'hours' ); ?>" type="text" maxlength="2" value="<?php echo $hours; ?>" name="<?php echo $this->get_field_name( 'hours' ); ?>" size="2"> :
			<input class="ct-date" id="<?php echo $this->get_field_id( 'minutes' ); ?>" type="text" maxlength="2" value="<?php echo $minutes; ?>" name="<?php echo $this->get_field_name( 'minutes' ); ?>" size="2">
 		</p>
	
		<p>
	 		<label for="<?php echo $this->get_field_id( 'day_s' ); ?>">
	 			<?php _e( 'Day singular text:', 'losatom' ); ?>	
			</label>
	 		<input type="text" name="<?php echo $this->get_field_name( 'day_s' ); ?>" value="<?php echo $day_s; ?>" id="<?php echo $this->get_field_id( 'day_s' ); ?>" class="alignright ct-inp" />
		</p>

		<p>
	 		<label for="<?php echo $this->get_field_id( 'day_m' ); ?>">
	 			<?php _e( 'Day plural text:', 'losatom' ); ?>	
			</label>
	 		<input type="text" name="<?php echo $this->get_field_name( 'day_m' ); ?>" value="<?php echo $day_m; ?>" id="<?php echo $this->get_field_id( 'day_m' ); ?>" class="alignright ct-inp" />
		</p>

		<p>
	 		<label for="<?php echo $this->get_field_id( 'hour_s' ); ?>">
	 			<?php _e( 'Hour singular text:', 'losatom' ); ?>	
			</label>
	 		<input type="text" name="<?php echo $this->get_field_name( 'hour_s' ); ?>" value="<?php echo $hour_s; ?>" id="<?php echo $this->get_field_id( 'hour_s' ); ?>" class="alignright ct-inp" />
		</p>		

		<p>
	 		<label for="<?php echo $this->get_field_id( 'hour_m' ); ?>">
	 			<?php _e( 'Hour plural text:', 'losatom' ); ?>	
			</label>
	 		<input type="text" name="<?php echo $this->get_field_name( 'hour_m' ); ?>" value="<?php echo $hour_m; ?>" id="<?php echo $this->get_field_id( 'hour_m' ); ?>" class="alignright ct-inp" />
		</p>	

		<p>
	 		<label for="<?php echo $this->get_field_id( 'min_s' ); ?>">
	 			<?php _e( 'Minutes singular text:', 'losatom' ); ?>	
			</label>
	 		<input type="text" name="<?php echo $this->get_field_name( 'min_s' ); ?>" value="<?php echo $min_s; ?>" id="<?php echo $this->get_field_id( 'min_s' ); ?>" class="alignright ct-inp" />
		</p>	

		<p>
	 		<label for="<?php echo $this->get_field_id( 'min_m' ); ?>">
	 			<?php _e( 'Minutes plural text:', 'losatom' ); ?>	
			</label>
	 		<input type="text" name="<?php echo $this->get_field_name( 'min_m' ); ?>" value="<?php echo $min_m; ?>" id="<?php echo $this->get_field_id( 'min_m' ); ?>" class="alignright ct-inp" />
		</p>

		<p>
	 		<label for="<?php echo $this->get_field_id( 'sec_s' ); ?>">
	 			<?php _e( 'Seconds singular text:', 'losatom' ); ?>	
			</label>
	 		<input type="text" name="<?php echo $this->get_field_name( 'sec_s' ); ?>" value="<?php echo $sec_s; ?>" id="<?php echo $this->get_field_id( 'sec_s' ); ?>" class="alignright ct-inp" />
		</p>	

		<p>
	 		<label for="<?php echo $this->get_field_id( 'sec_m' ); ?>">
	 			<?php _e( 'Seconds plural text:', 'losatom' ); ?>	
			</label>
	 		<input type="text" name="<?php echo $this->get_field_name( 'sec_m' ); ?>" value="<?php echo $sec_m; ?>" id="<?php echo $this->get_field_id( 'sec_m' ); ?>" class="alignright ct-inp" />
		</p>	
		
		<?php if ( is_customize_preview() ) : ?>
			<style>
			.ct-date {
				max-width: 45px !important;
				width: 45px !important;
			}
			.ct-inp {
				max-width: 85px !important;
				width: 85px !important;
			}
			</style>
		<?php endif; ?>

		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
		
		$instance['month']   = esc_attr( $new_instance['month'] ); 		
		$day                 = (int)( $new_instance['day'] ); 
		$instance['day']     = ( $day == 0 ) ? 1 : $day;		
		$instance['year']    = (int)( $new_instance['year'] ); 
		$instance['hours']   = $this->losatom_leading_zero( $new_instance['hours'] ); 
		$instance['minutes'] = $this->losatom_leading_zero( $new_instance['minutes'] ); 
		$instance['day_s']   = esc_attr( $new_instance['day_s'] );
		$instance['day_m']   = esc_attr( $new_instance['day_m'] );
		$instance['hour_s']  = esc_attr( $new_instance['hour_s'] );
		$instance['hour_m']  = esc_attr( $new_instance['hour_m'] );
		$instance['min_s']   = esc_attr( $new_instance['min_s'] );
		$instance['min_m']   = esc_attr( $new_instance['min_m'] );
		$instance['sec_s']   = esc_attr( $new_instance['sec_s'] );
		$instance['sec_m']   = esc_attr( $new_instance['sec_m'] );
 
	    return $instance;
	}
	
	function losatom_leading_zero( $number ) {
		$number = absint( $number );
		return $number < 10 ? 0 . $number : $number;
	}

	function widget( $args, $instance ) {

		extract( $args );

		$year    = isset( $instance['year'] ) ? (int)( $instance['year'] ) : date('Y');				
		$month   = isset( $instance['month'] ) ? esc_attr( $instance['month'] ) : date('M');				
		$day     = isset( $instance['day'] ) ? (int)( $instance['day'] ) : date('d');				
		$hours   = isset( $instance['hours'] ) ? $this->losatom_leading_zero( $instance['hours'] ) : date('H');		
		$minutes = isset( $instance['minutes'] ) ? $this->losatom_leading_zero( $instance['minutes'] ) : date('i');			
		$date = $day . ' ' . $month . ' ' . $year . ' ' . $hours . ':' . $minutes;

		/* Time string localizations, singular and plural. */
		$day_s  = isset( $instance['day_s'] ) ? esc_attr( $instance['day_s'] ) : 'day';    
		$day_m  = isset( $instance['day_m'] ) ? esc_attr( $instance['day_m'] ) : 'days';   
		$hour_s = isset( $instance['hour_s'] ) ? esc_attr( $instance['hour_s'] ) : 'hour'; 
		$hour_m = isset( $instance['hour_m'] ) ? esc_attr( $instance['hour_m'] ) : 'hours';
		$min_s  = isset( $instance['min_s'] ) ? esc_attr( $instance['min_s'] ) : 'minute'; 
		$min_m  = isset( $instance['min_m'] ) ? esc_attr( $instance['min_m'] ) : 'minutes';
		$sec_s  = isset( $instance['sec_s'] ) ? esc_attr( $instance['sec_s'] ) : 'second'; 
		$sec_m  = isset( $instance['sec_m'] ) ? esc_attr( $instance['sec_m'] ) : 'seconds';

		wp_enqueue_script( 'losatom-countdown' );

		wp_localize_script( 
			'losatom-custom-js', 
			'cdVars', 
			array(
				'countDown' => true,
				'date'      => $date,
				'day_s'     => $day_s, 
				'day_m'     => $day_m, 
				'hour_s'    => $hour_s, 
				'hour_m'    => $hour_m, 
				'min_s'     => $min_s, 
				'min_m'     => $min_m, 
				'sec_s'     => $sec_s, 
				'sec_m'     => $sec_m, 
			)
		);

		echo $before_widget;
		
		?> 		
		<div class="wrap">
	 		<div class="row">
				<div class="ct-col col-1-4 text-center" data-sr="flip 90deg over 1s">
					<div class="ct-inside">
						<span class="ct-numbers days">00</span>
						<span class="ct-text timeRefDays"><?php echo $day_m; ?></span>
					</div>				
				</div>
				<div class="ct-col col-1-4 text-center" data-sr="wait .3s, flip 90deg over 1s">
					<div class="ct-inside">
						<span class="ct-numbers hours">00</span>
						<span class="ct-text timeRefHours"><?php echo $hour_m; ?></span>
					</div>				
				</div>
				<div class="ct-col col-1-4 text-center" data-sr="wait .6s, flip 90deg over 1s">
					<div class="ct-inside">
						<span class="ct-numbers minutes">00</span>
						<span class="ct-text timeRefMinutes"><?php echo $min_m; ?></span>
					</div>				
				</div>
				<div class="ct-col col-1-4 text-center" data-sr="wait .9s, flip 90deg over 1s">
					<div class="ct-inside">
						<span class="ct-numbers seconds">00</span>
						<span class="ct-text timeRefSeconds"><?php echo $sec_m; ?></span>
					</div>				
				</div>
			</div>
		</div><!-- .wrap -->
		<?php 
		echo $after_widget;	
 	}
		 
}

?>