<?php

class Losatom_Widget_Article extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_article', 
			'description' => __( 'Displays custom created article.', 'losatom' ) 
		);		

		parent::__construct( 
			'Losatom_Widget_Article', 
			THEME_NAME . ' - ' . __( 'Image Article', 'losatom' ), 
			$widget_options 
		);	
	}

	function form( $instance ) {

		$image    = isset( $instance['image'] ) ? esc_url( $instance['image'] ) : '';			
		$position = isset( $instance['position'] ) ? esc_attr( $instance['position'] ) : 'left';			
		$title    = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';				
		$content  = isset( $instance['content'] ) ? esc_textarea( $instance['content'] ) : '';				
		
		?>
 		
		<p>
			<label for="<?php echo $this->get_field_id( 'image' ); ?>">
				<?php _e( 'Image Link:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'image' ); ?>" name="<?php echo $this->get_field_name( 'image' ); ?>" value="<?php echo $image; ?>" />
			<a class="button losatom-upload"><?php _e( 'Upload Image', 'losatom' ); ?></a>
		</p>	

		<p>
			<input type="radio" name="<?php echo $this->get_field_name( 'position' ); ?>" id="<?php echo $this->get_field_id( 'pos_1' ); ?>" value="left" <?php checked( $position, 'left' ); ?> />
			<label for="<?php echo $this->get_field_id( 'pos_1' ); ?>"><?php _e( 'Left', 'losatom' ); ?></label>

			<input type="radio" name="<?php echo $this->get_field_name( 'position' ); ?>" id="<?php echo $this->get_field_id( 'pos_2' ); ?>" value="right" <?php checked( $position, 'right' ); ?> />
			<label for="<?php echo $this->get_field_id( 'pos_2' ); ?>"><?php _e( 'Right', 'losatom' ); ?></label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php _e( 'Title:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
		</p>			 

		<p>
			<label for="<?php echo $this->get_field_id( 'content' ); ?>">
				<?php _e( 'Text:', 'losatom' ); ?>
			</label>
			<textarea class="widefat" cols="8" rows="8" id="<?php echo $this->get_field_id('content'); ?>" name="<?php echo $this->get_field_name('content'); ?>"><?php echo $content; ?></textarea>			
		</p>		
		 	
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
		
		$instance['image']    = esc_url( $new_instance['image'] ); 
		$instance['position'] = esc_attr( $new_instance['position'] ); 
		$instance['title']    = esc_attr( $new_instance['title'] ); 
		$instance['content']  = esc_attr( $new_instance['content'] ); 
 
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$image    = isset( $instance['image'] ) ? esc_url( $instance['image'] ) : '';
		$position = isset( $instance['position'] ) ? esc_attr( $instance['position'] ) : 'left';
		$title    = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$content  = isset( $instance['content'] ) ? esc_attr( $instance['content'] ) : '';
		
		$is_landing_page = is_losatom_landing_page();
		echo ( $is_landing_page ) ? '<div class="wrap article-wrapper">' : '';

		echo $before_widget;
 		
		$html = '';

 		if ( ! empty( $image ) && $position == 'left' ) 
 			$html .= '<img src="'. $image .'" alt="'. $title .'" class="article-image" />';

 		$mode = ! empty( $image ) ? ' aligned-' . $position : false;

 		$html .= '<div class="article-content'. $mode .'">';
		$html .= '<h3 class="article-title">' . $title . '</h3>'; 
		$html .= '<p>' . $content . '</p>';		
 		$html .= '</div>';

 		if ( ! empty( $image ) && $position == 'right' ) 
 			$html .= '<img src="'. $image .'" alt="'. $title .'" class="article-image" />';

 		echo $html;

		echo $after_widget;	
		
		echo ( $is_landing_page ) ? '</div>' : '';		
 	}
		 
}

?>