jQuery( document ).ready( function($) {

	var width = $( window ).width();

	/* ===== PRELOADER ===== */
	if ( typeof preloader !== "undefined" ) {
		$('.losatom_widget_countdown span').attr('data-sr', 'wait 1.5s, roll 360deg over 1s' );
		$( '#theme-preloader' ).delay( 1000 ).fadeOut( 'slow', function() { 
			$( this ).remove();
		});
	}

	/* ===== ANIMATIONS ===== */
	if ( typeof animations !== "undefined" && width > 1000 ) { // Don't show animations on lower resolutions.
  		window.sr = new scrollReveal({
  			mobile: false,
  			vFactor:  0.80,
  		});
	}

	/* ===== FITVIDS ===== */
	$('#content').fitVids({ customSelector: "iframe[src*='wordpress.tv'], iframe[src*='www.dailymotion.com'], iframe[src*='blip.tv'], iframe[src*='www.viddler.com']"});	

	/* ===== TESTIMONIAL SLIDER ===== */
	if ( typeof testimonialVars !== "undefined" ) { // Check if testimonial section is loaded.

		var testimonialTwoImg = {
			slideWidth: 555,
			minSlides: 2,
			maxSlides: 2,
			slideMargin: 30,		
			auto: true,
			pause: 4000,
			autoHover: true,
			adaptiveHeight: true,
			controls: false,	
			pager: false,			
		};
		
		var testimonialOneImg = {
			minSlides: 1,
			maxSlides: 1,
			slideWidth: 755,		    
			auto: true,
			pause: 4000,
			autoHover: true,
			adaptiveHeight: true,
			controls: false,	
			pager: false,	
		};

		var slider;
			slider = $( '.testimonial' ).bxSlider( testimonialTwoImg );

		if ( width < 768 || 'false' == testimonialVars.is_landing_page )
			slider.reloadSlider( testimonialOneImg );

		 $( window ).resize( function() {
		 	var $width = $( this ).width();
		 	if ( $width >= 768 )
				slider.reloadSlider( testimonialTwoImg );		 		
		 	else
				slider.reloadSlider( testimonialOneImg );	

			/* If it's resized on single... don't let it! */
			if ( 'false' == testimonialVars.is_landing_page )		 
				slider.reloadSlider( testimonialOneImg );						 		
		 });	 		

	}

	/* ===== SLIDER WIDGET ===== */	
	if ( typeof widgetSlider !== "undefined" ) { // Check if widget slider is loaded.
		 $( '.slider' ).bxSlider({
			minSlides: 1,
			maxSlides: 1,
			auto: true,
			pause: widgetSlider.pause,
			autoHover: true,
			adaptiveHeight: false,
			controls: true,	
			nextText: '<span></span>',
			prevText: '<span></span>',
			pager: true,	
		});
	}

	/* ===== COUNTDOWN WIDGET ===== */	
	if ( typeof cdVars !== "undefined" ) { /* Check if countdown widget is active. */
		$( '.losatom_widget_countdown' ).countdown({
			date: cdVars.date,
		    day_s: cdVars.day_s,
		    day_m: cdVars.day_m,
		    hour_s: cdVars.hour_s,
		    hour_m: cdVars.hour_m,
		    min_s: cdVars.min_s,
		    min_m: cdVars.min_m,
		    sec_s: cdVars.sec_s,
		    sec_m: cdVars.sec_m			
		});		
	}
		
});