<?php
class Losatom_Widget_Latest_Posts extends WP_Widget {
		
	public function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_latest_posts', 
			'description' => __( 'Displays latest posts.', 'losatom' ) 
		);

		parent::__construct( 
			'Losatom_Widget_Latest_Posts', 
			THEME_NAME . ' - ' . __( 'Latest Posts', 'losatom' ), 
			$widget_options 
		);					

	}
 
	public function form( $instance ) {
		
		$widget_title    = isset( $instance['widget_title'] ) ? esc_attr( $instance['widget_title'] ) : '';
		$widget_subtitle = isset( $instance['widget_subtitle'] ) ? esc_attr( $instance['widget_subtitle'] ) : '';
		$number          = isset( $instance['number'] ) ? absint( $instance['number'] ) : 1;
		$categories      = isset( $instance['categories'] ) ? (array) $instance['categories'] : array();	
		$cols_number     = isset( $instance['cols_number'] ) ? absint( $instance['cols_number'] ) : 1;

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php _e( 'Title:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'widget_title' ); ?>" name="<?php echo $this->get_field_name( 'widget_title' ); ?>" value="<?php echo $widget_title; ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'widget_subtitle' ); ?>">
				<?php _e( 'Subtitle:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'widget_subtitle' ); ?>" name="<?php echo $this->get_field_name( 'widget_subtitle' ); ?>" value="<?php echo $widget_subtitle; ?>" />
		</p>		

		<p class="widget-select-container">
 			<label for="<?php echo $this->get_field_id( 'categories' ); ?>"><?php _e( 'Choose categories from which to display posts, select nothing to show latest posts.', 'losatom' ); ?></label>
			<select name="<?php echo $this->get_field_name( 'categories' ); ?>[]" id="<?php echo $this->get_field_id( 'categories' ); ?>"  style="height: 200px" class="widefat" multiple="multiple">
			<?php $cats = get_categories(array('hide_empty' => 0 )); ?>
			<?php foreach( $cats as $cat ) : ?>
				<option value="<?php echo absint( $cat->cat_ID ); ?>" <?php echo in_array( $cat->cat_ID, $categories ) ? 'selected="selected"' : ''; ?>><?php echo esc_attr( $cat->cat_name ); ?></option>
			<?php endforeach; ?>
			</select>		
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:', 'losatom' ); ?></label>
			<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" />
		</p>

		<p class="widget-select-container">
 			<label for="<?php echo $this->get_field_id( 'cols_number' ); ?>"><?php _e( 'In how many columns to display posts?', 'losatom' ); ?></label>
			<select name="<?php echo $this->get_field_name( 'cols_number' ); ?>" id="<?php echo $this->get_field_id( 'cols_number' ); ?>" class="widefat">
				<?php for( $i = 1; $i<5; $i++ ) : ?>
					<option value="<?php echo $i; ?>" <?php selected( $i, $cols_number ); ?>><?php echo $i; ?></option>
				<?php endfor; ?>
			</select>		
		</p>

		<?php
	}
	
	public function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance;
		
		$instance['widget_title']    = isset( $new_instance['widget_title'] ) ? esc_attr( $new_instance['widget_title'] ) : '';
		$instance['widget_subtitle'] = isset( $new_instance['widget_subtitle'] ) ? esc_attr( $new_instance['widget_subtitle'] ) : '';
		$instance['number']          = (int) $new_instance['number'];
		$instance['categories']      = isset( $new_instance['categories'] ) ? $new_instance['categories'] : array();
		$instance['cols_number']     = (int) $new_instance['cols_number'];

		return $instance;
	}

	public function widget( $args, $instance ) {
		extract( $args, EXTR_SKIP );
		
		$title         = isset( $instance['widget_title'] ) ? esc_attr( $instance['widget_title'] ) : '';
		$subtitle      = isset( $instance['widget_subtitle'] ) ? esc_attr( $instance['widget_subtitle'] ) : '';
		$number        = isset( $instance['number'] ) ? absint( $instance['number'] ) : 1;
		$cats          = isset( $instance['categories'] ) ? (array)$instance['categories'] : '';
		$cols_number   = isset( $instance['cols_number'] ) ? absint( $instance['cols_number'] ) : 1;

		$img_url = trailingslashit( get_template_directory_uri() ) . 'images/default-image.jpg';

		$is_langing_page = is_losatom_landing_page();

		echo $before_widget; ?>

		<div class="wrap">

		<?php if ( ! empty( $title ) && ! empty( $subtitle ) ) : ?>

			<div class="section-info text-center">
			
				<?php if ( ! empty( $title ) ) : ?>
					<h2 class="section-title text-center"><?php echo esc_attr( $title ); ?></h2>
				<?php endif; ?>

				<?php if ( ! empty( $subtitle ) ) : ?>
					<p class="section-description text-center"><?php echo esc_attr( $subtitle ); ?></p>
			 	<?php endif; ?>
			
			</div><!-- .section-info -->

		<?php endif; ?>

		<?php

		$query_args = array(
			'post_type'           => 'post',
			'posts_per_page'      => $number,
			'category__in'        => $cats,
			'ignore_sticky_posts' => true
		);

		$query = new WP_Query( $query_args ); 

		/* Pull different image for size each column number. */
		if ( 1 == $cols_number )
			$image_size = 'losatom-full';

		elseif ( 2 == $cols_number )
			$image_size = 'losatom-lp-2-widget-image';

		elseif ( 3 == $cols_number ) 
			$image_size = 'losatom-lp-3-widget-image';

		elseif ( 4 == $cols_number ) 
			$image_size = 'losatom-lp-4-widget-image';		

		if ( $query->have_posts() ) : ?>

			<div class="row">

			<?php while ( $query->have_posts() ) : $query->the_post(); ?>
				
				<div class="lp-img-wrap col-1-<?php echo $cols_number; ?>" data-sr="scale up 10%">
					
					<a class="losatom-thumbnail" href="<?php the_permalink(); ?>">

						<?php get_the_image( 
							array( 
								'size'    => $image_size, 
								'caption' => true, 
								'default' => $img_url,
								'order'   => array( 'featured', 'attachment', 'default' ),
								'link_to_post' => false
							) ); 
						?>

						<div class="lp-img-popup">
							<span class="lp-img-popup-inside">
								<i class="fa fa-eye"></i>
							</span>
						</div>

					</a>

				</div>

			<?php endwhile; ?>

			</div>

		</div><!-- .wrap -->

		<?php endif; ?>

		<?php echo $after_widget;
	}
 
	
}