<?php

class Losatom_Widget_Slider extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_slider', 
			'description' => __( 'Displays image slider.', 'losatom' ) 
		);
				
		parent::__construct( 
			'Losatom_Widget_Slider', 
			THEME_NAME . ' - ' . __( 'Slider', 'losatom' ), 
			$widget_options 
		);	
	}

	function form( $instance ) {
		
 		$pause = isset( $instance['pause'] ) ? absint( $instance['pause'] ) : 4000;
 		$height = isset( $instance['height'] ) ? absint( $instance['height'] ) : 585;
 		unset( $instance['pause'] );
 		unset( $instance['height'] );

 		$instance = array_chunk( $instance, 4, true );
 		$i = 1; 
 		?>		
		
		<p>
			<label for="<?php echo $this->get_field_id( 'pause' ); ?>">
				<?php _e( 'Pause between slides (in milliseconds)?', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'pause' ); ?>" name="<?php echo $this->get_field_name( 'pause' ); ?>" value="<?php echo $pause; ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'height' ); ?>">
				<?php _e( 'Slider height (without px):', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'height' ); ?>" name="<?php echo $this->get_field_name( 'height' ); ?>" value="<?php echo $height; ?>" />
		</p>		

		<?php foreach( $instance as $accordion ) : ?>

	 		<div class="accordion">
				
				<span class="dashicons dashicons-trash delete-accordion"></span>

	 			<h5 class="accordion-title"><?php _e( 'Slider', 'losatom' ); ?> <span><?php echo $i++; ?></span></h5>
				
				<div class="accordion-content">
					
					<?php foreach( $accordion as $key => $value ) : ?>

						<?php if ( strpos( $key, 'image' ) !== false ) : ?>
							
							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Image:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_url( $value ); ?>" />
								<a class="button losatom-upload"><?php _e( 'Upload Image', 'losatom' ); ?></a>
							</p>				
						
		 				<?php elseif ( strpos( $key, 'title' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Slide Title:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo strip_tags( $value, '<br><br />' ); ?>" />
							</p>	
		 						
		 				<?php elseif ( strpos( $key, 'button_text' ) !== false ) : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Button Text:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_attr( $value ); ?>" />
							</p>	

		 				<?php else : ?>

							<p>
								<label for="<?php echo $this->get_field_id( $key ); ?>">
									<?php _e( 'Button Link:', 'losatom' ); ?>
								</label>
								<input type="text" class="widefat" id="<?php echo $this->get_field_id( $key ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" value="<?php echo esc_attr( $value ); ?>" />
							</p>								
						
		 				<?php endif; ?>

					<?php endforeach; ?>								
					
				</div><!-- .accordion-content -->

			</div><!-- .accordion -->
		
		<?php endforeach; // End accordion foreach loop. ?>						 

		<a href="#" class="add-new-button button"><?php _e( 'Add New Slide', 'losatom' ); ?></a>
		
		<!-- ACCORDION FOR CLONING -->
		<div class="accordion for-cloning hidden">
			
			<span class="dashicons dashicons-trash delete-accordion"></span>

			<h5 class="accordion-title"><?php _e( 'Slider', 'losatom' ); ?> <span>__x__</span></h5>
			
			<div class="accordion-content">
				
				<p>
					<label for="widget-losatom_widget_slider-__x__-image___y__">
						<?php _e( 'Image:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_slider-__x__-image___y__" name="widget-losatom_widget_slider[__x__][image___y__]" value="" />
					<a class="button losatom-upload"><?php _e( 'Upload Image', 'losatom' ); ?></a>
				</p>	

				<p>
					<label for="widget-losatom_widget_slider-__x__-title___y__">
						<?php _e( 'Slide Title:', 'losatom' ); ?>
					</label>			
					<input type="text" class="widefat" id="widget-losatom_widget_slider-__x__-title___y__" name="widget-losatom_widget_slider[__x__][title___y__]" value="" />
				</p>		

				<p>
					<label for="widget-losatom_widget_slider-__x__-button_text___y__">
						<?php _e( 'Button Text:', 'losatom' ); ?>
					</label>	
					<input type="text" class="widefat" id="widget-losatom_widget_slider-__x__-button_text___y__" name="widget-losatom_widget_slider[__x__][button_text___y__]" value="" />
				</p>	

				<p>
					<label for="widget-losatom_widget_slider-__x__-button_link___y__">
						<?php _e( 'Button Link:', 'losatom' ); ?>
					</label>	
					<input type="text" class="widefat" id="widget-losatom_widget_slider-__x__-button_link___y__" name="widget-losatom_widget_slider[__x__][button_link___y__]" value="" />
				</p>						

			</div><!-- .accordion-content -->

		</div><!-- .accordion -->
		<!-- END ACCORDION FOR CLONING -->
		
		<?php 
	}
	
	function update( $new_instance, $old_instance ) {

		foreach( $new_instance as $key => $value ) {
			if ( strpos( $key, 'image' ) !== false || strpos( $key, 'button_link' ) !== false )
				$new_instance[$key] = esc_url_raw( $value );
			elseif ( strpos( $key, 'title' ) !== false )
				$new_instance[$key] = strip_tags( $value, '<br><br />' );
			elseif ( $key == 'pause' || $key == 'height' )
				$new_instance[$key] = absint( $value );			
			else
				$new_instance[$key] = esc_attr( $value );
		}

	    return $new_instance;

	}
	
	function widget( $args, $instance ) {
	
		extract( $args );

		$pause  = isset( $instance['pause'] ) ? absint( $instance['pause'] ) : 4000;
		$height = isset( $instance['height'] ) ? absint( $instance['height'] ) : 400;

		wp_enqueue_script( 'losatom-slider' );
		wp_localize_script( 'losatom-custom-js', 'widgetSlider', array(
			'widgetSlider' => true,
			'pause'        => $pause,
		) );			
		
		echo $before_widget; 

		echo '<style>#'. $widget_id .' .bx-wrapper .bx-viewport { min-height: '. $height .'px; }</style>';
		?>
		<ul class="slider">
		
		<?php
		unset( $instance['pause'] );
		unset( $instance['height'] );
		$instance = array_chunk( $instance, 4, true );

		foreach( $instance as $slide ) {
			
			$i = 1; 

			/* Create variables first. */
			foreach ( $slide as $key => $value ) {
				if ( $i == 1 ) // 1. image
					$image = esc_url( $value );
				elseif ( $i == 2 ) // 2. title
					$title = strip_tags( $value, '<br><br />' );
				elseif ( $i == 3 ) // 3. button_text
					$button_text = esc_attr( $value );
				else // 4. button_link
					$button_link = esc_url( $value );
				$i++;
			}
			$i = 0; ?>

			<li style="background-image: url('<?php echo $image; ?>');">
				
				<div class="slide-content">
	
					<div class="wrap">
					
					<?php if ( ! empty( $title ) ) : ?>
						<h2 class="slide-title"><?php echo $title; ?></h2>
					<?php endif; ?>
					
					<?php if ( ! empty( $button_text ) && ! empty( $button_link ) ) : ?>
						<a class="slide-button" href="<?php echo $button_link; ?>"><?php echo $button_text; ?></a>
					<?php endif; ?>

					</div><!-- .wrap -->
	
				</div><!-- .slide-content -->
				
			</li>

		<?php 
		} // End slider foreach loop. ?>
		
		</ul>
	
		<?php echo $after_widget;	
	}
		 
}

?>