<?php

class Losatom_Widget_Article_FW extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_article_fw', 
			'description' => __( 'Displays custom created article.', 'losatom' ) 
		);		

		parent::__construct( 
			'Losatom_Widget_Article_FW', 
			THEME_NAME . ' - ' . __( 'Article Full Width', 'losatom' ), 
			$widget_options 
		);	
	}

	function form( $instance ) {

		$position = isset( $instance['position'] ) ? esc_attr( $instance['position'] ) : 'left';			
		$title    = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';				
		$content  = isset( $instance['content'] ) ? esc_textarea( $instance['content'] ) : '';				
		$html     = isset( $instance['html'] ) ? esc_textarea( $instance['html'] ) : '';			
		
		?>
 		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php _e( 'Title:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
		</p>			 

		<p>
			<label for="<?php echo $this->get_field_id( 'content' ); ?>">
				<?php _e( 'Text:', 'losatom' ); ?>
			</label>
			<textarea class="widefat" cols="8" rows="8" id="<?php echo $this->get_field_id('content'); ?>" name="<?php echo $this->get_field_name('content'); ?>"><?php echo $content; ?></textarea>			
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'html' ); ?>">
				<?php _e( 'Custom HTML:', 'losatom' ); ?>
			</label>
			<textarea class="widefat" cols="8" rows="8" id="<?php echo $this->get_field_id( 'html' ); ?>" name="<?php echo $this->get_field_name( 'html' ); ?>"><?php echo $html; ?></textarea>		
		</p>	

		<p>
			<span><?php _e( 'Custom HTML Position:', 'losatom' ); ?></span><br>
			<input type="radio" name="<?php echo $this->get_field_name( 'position' ); ?>" id="<?php echo $this->get_field_id( 'pos_1' ); ?>" value="left" <?php checked( $position, 'left' ); ?> />
			<label for="<?php echo $this->get_field_id( 'pos_1' ); ?>"><?php _e( 'Left', 'losatom' ); ?></label>

			<input type="radio" name="<?php echo $this->get_field_name( 'position' ); ?>" id="<?php echo $this->get_field_id( 'pos_2' ); ?>" value="right" <?php checked( $position, 'right' ); ?> />
			<label for="<?php echo $this->get_field_id( 'pos_2' ); ?>"><?php _e( 'Right', 'losatom' ); ?></label>
		</p>			
		 	
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
		
		$instance['title']    = esc_attr( $new_instance['title'] ); 
		$instance['content']  = esc_attr( $new_instance['content'] ); 
		$instance['position'] = esc_attr( $new_instance['position'] ); 
		if ( current_user_can('unfiltered_html') )
			$instance['html'] =  $new_instance['html'];
		else
			$instance['html'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['html']) ) ); // wp_filter_post_kses() expects slashed
 
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$title    = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$content  = isset( $instance['content'] ) ? esc_attr( $instance['content'] ) : '';
		$chtml    = isset( $instance['html'] ) ? $instance['html'] : '';
		$position = isset( $instance['position'] ) ? esc_attr( $instance['position'] ) : 'left';
		

		echo $before_widget;
		
		$is_landing_page = is_losatom_landing_page();
		echo ( $is_landing_page ) ? '<div class="wrap article-wrapper">' : '';
 		
		$html = '<div class="row">';

 		if ( ! empty( $chtml ) && $position == 'left' ) 
 			$html .= '<div class="col-1-2" data-sr="enter left move 100px over 1s">'. $chtml .'</div>';

 		$html .= '<div class="col-1-2" data-sr="enter bottom hustle 100px over 1s">';
			$html .= '<h3 class="article-title">' . $title . '</h3>'; 
			$html .= '<p class="article-content">' . $content . '</p>';		
 		$html .= '</div>';

 		if ( ! empty( $chtml ) && $position == 'right' ) 
 			$html .= '<div class="col-1-2" data-sr="enter right move 100px over 1s">'. $chtml .'</div>';

 		$html .= '</div>';
 		
 		echo $html;

		echo ( $is_landing_page ) ? '</div>' : '';		
		
		echo $after_widget;	
		
 	}
		 
}

?>