<section id="white-sidebar" class="section">

	<?php if ( is_active_sidebar( 'front_page_white' ) ) : // If the sidebar has widgets. ?>

		<?php dynamic_sidebar( 'front_page_white' ); // Displays the front page white sidebar. ?>

	<?php else : // If the sidebar has no widgets. ?>

	 	<?php 
		
		$images = trailingslashit( get_template_directory_uri() ) . 'images/';	 	

		the_widget(
			'Losatom_Widget_Slider',
			array(
				'pause'            => 4000,
				'height'           => 585,
				'image_0'          => $images . 'slide1.jpg',
				'title_0'          => __( 'QUICKLY LAUNCH YOUR NEW <br> PRODUCT WEBSITE', 'losatom' ),
				'button_text_0'    => 'START THE TRIAL',
				'button_link_0'    => '#',
				
				'image_1'          => $images . 'slide2.jpg',
				'title_1'          => __( "LOREM IPSUM DOLOR <br> SIT AMET.", 'losatom' ),
				'button_text_1'    => 'SIGN UP NOW',
				'button_link_1'    => '#',
				
				'image_2'       => $images . 'slide3.jpg',
				'title_2'       => __( "CORPORIS ODIO MAGNI <br> ASPERNATUR ITAQUE", 'losatom' ),
				'button_text_2' => 'JOIN US',
				'button_link_2' => '#',	
				
				'image_3'       => $images . 'slide4.jpg',
				'title_3'       => __( "DISTINCTIO UT NESCIUNT, <br> INCIDUNT SIT", 'losatom' ),
				'button_text_3' => 'CONTACT US',
				'button_link_3' => '#',										

			),
			array(
				'before_widget' => '<div id="losatom-2" class="widget losatom_widget_slider">',
				'after_widget'  => '</div>',
				'widget_id'		=> 'losatom-2'
			)
		);	
		 				 	
	 	the_widget(
	 		'Losatom_Widget_Countdown',
	 		array(
				'month'  => 'Aug',        
				'day'    => '25',            
				'year'   => '2022',      
				'hours'  => '14',          
				'minutes'=> '00',          
				'day_s'  => 'day',        
				'day_m'  => 'days',      
				'hour_s' => 'hour',      
				'hour_m' => 'hours',    
				'min_s'  => 'minute',  
				'min_m'  => 'minutes',
				'sec_s'  => 'second',  
				'sec_m'  => 'seconds'  
	 		),
			array(
				'before_widget' => '<div class="widget losatom_widget_countdown">',
				'after_widget'  => '</div>'
			) 		
	 	); 
		
		the_widget(
		'Losatom_Widget_Features',
			array(
				'widget_title'    => __( 'Feature Points', 'losatom' ),
				'widget_subtitle' => __( 'Thinking big when you are small', 'losatom' ),
				'display_type'    => 'centered',
				'columns'         => 4,

				'title_0'         => __( 'Very Important Feature', 'losatom' ),
				'text_0'          => __( 'Lorem ipsum dolor sit amet, dolor an easy way to get more organic search.', 'losatom' ),
				'font_icon_0'     => 'fa fa-check-circle-o',
				'font_size_0'     => 75,

				'title_1'         => __( 'Very Important Feature', 'losatom' ),
				'text_1'          => __( 'Lorem ipsum dolor sit amet, dolor an easy way to get more organic search.', 'losatom' ),
				'font_icon_1'     => 'fa fa-bell-o',
				'font_size_1'     => 66,

				'title_2'         => __( 'Very Important Feature', 'losatom' ),
				'text_2'          => __( 'Lorem ipsum dolor sit amet, dolor an easy way to get more organic search.', 'losatom' ),
				'font_icon_2'     => 'fa fa-file-text-o',
				'font_size_2'     => 62,

				'title_3'         => __( 'Very Important Feature', 'losatom' ),
				'text_3'          => __( 'Lorem ipsum dolor sit amet, dolor an easy way to get more organic search.', 'losatom' ),
				'font_icon_3'     => 'fa fa-lightbulb-o',
				'font_size_3'     => 72,

			),
			array(
				'before_widget' => '<div class="widget losatom_widget_features">',
				'after_widget'  => '</div>',
			)
		);			
 
		the_widget(
			'Losatom_Widget_Article_FW',
			array(	
				'html'    => '<iframe src="https://player.vimeo.com/video/141098982" width="500" height="313" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>',
				'position' => 'right',
				'title'    => "LOREM IPSUM DOLOR SIT",
				'content'  => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered 
alteration in some form, by injected humour, or randomised words which don't look even slightly 
believable. If you are going to use a passage of.",
			),
			array(
				'before_widget' => '<div class="widget losatom_widget_article_fw">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);	

		the_widget(
			'Losatom_Widget_Article',
			array(	
				'image'    => $images .'demo-article-img.jpg',
				'position' => 'left',
				'title'    => "Works with your existing email software",
				'content'  => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered 
alteration in some form, by injected humour, or randomised words which don't look even slightly 
believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't 
anything embarrassing hidden in the middle of text.",
			),
			array(
				'before_widget' => '<div class="widget losatom_widget_article">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);	

		the_widget(
			'Losatom_Widget_Article',
			array(	
				'image'    => $images .'demo-article-img.jpg',
				'position' => 'right',
				'title'    => "Works with your existing email software",
				'content'  => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered 
alteration in some form, by injected humour, or randomised words which don't look even slightly 
believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't 
anything embarrassing hidden in the middle of text.",
			),
			array(
				'before_widget' => '<div class="widget losatom_widget_article">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);	

		the_widget(
			'Losatom_Widget_CTA',
			array(	
				'display_type' => 'left_aligned',
				'title'        => __( 'And much more features! Buy product now!', 'losatom' ),
				'content'      => __( "If you like this product don't forget to rate it!", 'losatom' ),
				'button_text'  => __( 'Sign up now!', 'losatom' ),
				'button_link'  => '#'
			),
			array(
				'before_widget' => '<div class="widget losatom_widget_cta left_aligned">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
				'widget_id'     => 'cta'
			)
		);				

		the_widget(
			'Losatom_Widget_Latest_Posts',
			array(
				'widget_title'    => __( 'Latest News', 'mosalon' ),
				'widget_subtitle' => __( 'Freshest news from our blog', 'mosalon' ),
				'number'          => 6,
				'categories'      => 1,
				'cols_number'     => 3,
			),
			array(
				'before_widget' => '<div class="widget losatom_widget_latest_posts">',
				'after_widget'  => '</div>',
			)
		);

		$newline = "\n\r";
			$table_content = sprintf( __( 'Single Domain %1$s Unlimited Disk Space %1$s Unlimited Bandwidth %1$s Share SSL Certificate', 'losatom' ), $newline );

			the_widget(
			'Losatom_Widget_Table',
			array(
				'widget_title'    => __( 'Pricing Tables', 'losatom' ),
				'widget_subtitle' => __( 'All plans include a free 30 days trial', 'losatom' ),

				'title_0'       => __( 'Bronze Package', 'losatom' ),
				'price_0'       => '$19',
				'duration_0'    => __( 'monthly', 'losatom' ),
				'content_0'     => $table_content,
				'button_text_0' => 'Get Started',
				'button_link_0' => '#',

				'title_1'       => __( 'Silver Package', 'losatom' ),
				'price_1'       => '$29',
				'duration_1'    => __( 'monthly', 'losatom' ),
				'content_1'     => $table_content,
				'button_text_1' => 'Get Started',
				'button_link_1' => '#',

				'title_2'       => __( 'Gold Package', 'losatom' ),
				'price_2'       => '$39',
				'duration_2'    => __( 'monthly', 'losatom' ),
				'content_2'     => $table_content,
				'button_text_2' => 'Get Started',
				'button_link_2' => '#',										

									
			),
			array(
				'before_widget' => '<div class="widget losatom_widget_table">',
				'after_widget'  => '</div>',
			)
		);
				

			the_widget(
			'Losatom_Widget_Testimonial',
			array(
				'title'    => __( 'Client Testimonials', 'losatom' ),
				'subtitle' => '',
				
				'image_0'   => $images . 'demo-testimonial-img-1.jpg',
				'name_0'    => __( 'John Doe - New York', 'losatom' ),
				'content_0' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Laborum, veniam?',
				'linkedin_0' => '#',
				'facebook_0' => '#',
				'twitter_0' => '#',

				'image_1'   => $images . 'demo-testimonial-img-2.jpg',
				'name_1'    => __( 'James Hox - Los Angeles', 'losatom' ),
				'content_1' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Laborum, veniam?',
				'linkedin_1' => '#',
				'facebook_1' => '#',
				'twitter_1' => '#',

				'image_2'   => $images . 'demo-testimonial-img-3.jpg',
				'name_2'    => __( 'Johnny Mills - Miami', 'losatom' ),
				'content_2' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Laborum, veniam?',
				'linkedin_2' => '#',
				'facebook_2' => '#',
				'twitter_2' => '#',

				'image_3'   => $images . 'demo-testimonial-img-4.jpg',
				'name_3'    => __( 'Aretha Crimson - Atlanta', 'losatom' ),
				'content_3' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Laborum, veniam?',
				'linkedin_3' => '#',
				'facebook_3' => '#',
				'twitter_3' => '#',

			),
			array(
				'before_widget' => '<div class="widget losatom_widget_testimonial">',
				'after_widget'  => '</div>',
			)
			);

	 	?>

	<?php endif; // End widgets check. ?>

</section><!-- #white-sidebar -->