<?php

class Losatom_Widget_Contact extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_contact', 
			'description' => __( 'Displays contact details: email, phone and location.', 'losatom' ) 
		);		

		parent::__construct( 
			'Losatom_Widget_Contact', 
			THEME_NAME . ' - ' . __( 'Contact', 'losatom' ), 
			$widget_options 
		);	
	}

	function form( $instance ) {

		$email    = isset( $instance['email'] ) ? esc_attr( $instance['email'] ) : '';
		$phone    = isset( $instance['phone'] ) ? esc_attr( $instance['phone'] ) : '';				
		$location = isset( $instance['location'] ) ? esc_textarea( $instance['location'] ) : '';			
		$bg       = isset( $instance['bg'] ) ? esc_url( $instance['bg'] ) : '';				
		
		?>
 				
		<p>
			<label for="<?php echo $this->get_field_id( 'pos_1' ); ?>"><?php _e( 'Email', 'losatom' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" value="<?php echo $email; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'phone' ); ?>">
				<?php _e( 'Phone:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'phone' ); ?>" name="<?php echo $this->get_field_name( 'phone' ); ?>" value="<?php echo $phone; ?>" />
		</p>			 

		<p>
			<label for="<?php echo $this->get_field_id( 'location' ); ?>">
				<?php _e( 'Location:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'location' ); ?>" name="<?php echo $this->get_field_name( 'location' ); ?>" value="<?php echo $location; ?>" />
		</p>		
		 	
		<p>
			<label for="<?php echo $this->get_field_id( 'bg' ); ?>">
				<?php _e( 'Background Image (optional):', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'bg' ); ?>" name="<?php echo $this->get_field_name( 'bg' ); ?>" value="<?php echo $bg; ?>" />
			<a class="button losatom-upload"><?php _e( 'Upload Image', 'losatom' ); ?></a>
		</p>	

		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
		
		$instance['email']    = esc_attr( $new_instance['email'] ); 
		$instance['phone']    = esc_attr( $new_instance['phone'] ); 
		$instance['location'] = esc_attr( $new_instance['location'] ); 
		$instance['bg']       = esc_url( $new_instance['bg'] ); 
 
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$email    = isset( $instance['email'] ) ? esc_attr( $instance['email'] ) : '';
		$phone    = isset( $instance['phone'] ) ? esc_attr( $instance['phone'] ) : '';
		$location = isset( $instance['location'] ) ? esc_attr( $instance['location'] ) : '';

		$def_img  = trailingslashit( get_template_directory_uri() ) . 'images/contactbg.jpg';
		$bg       = ! empty( $instance['bg'] ) ? esc_url( $instance['bg'] ) : $def_img;
		
		echo str_replace( '>', ' style="background-image: url('. $bg .');">', $before_widget ); 
		
		$animation_envelope = '';
		$animation_phone    = '';
		$animation_location = '';

		if ( is_losatom_landing_page() ) {
			$animation_envelope = 'data-sr="enter bottom move 90px over .5s"';
			$animation_phone    = 'data-sr="wait .3s, enter bottom move 90px over .5s"';
			$animation_location = 'data-sr="wait .6s, enter bottom move 90px over .5s"';
			
		}

		?>
		<div class="wrap"> 		

	 		<div class="col-1-3 text-center">
	 			<i <?php echo $animation_envelope; ?> class="fa fa-envelope-o"></i>
	 			<p><?php echo $email; ?></p>
	 		</div>
		
	 		<div class="col-1-3 text-center">
	 			<i <?php echo $animation_phone; ?> class="fa fa-phone"></i>
	 			<p><?php echo $phone; ?></p>
	 		</div>

	 		<div class="col-1-3 text-center">
	 			<i <?php echo $animation_location; ?> class="fa fa-map-marker"></i>
	 			<p><?php echo $location; ?></p>
	 		</div>

		</div>
		
		<?php 
		
		echo $after_widget;	
		
 	}
		 
}

?>