<?php
/**
 * Template Name: Blog
 *
 * A custom page template for displaying blog posts.
 *
 */

get_header(); // Loads the header.php template. ?>

	<main <?php hybrid_attr( 'content' ); ?>>

		<?php
		$wp_query = new WP_Query( 
			array(
				'post_type' => 'post', 
				'showposts' => get_option( 'posts_per_page' ), 
				'paged'     => get_query_var( 'paged', 1 )
			) 
		); 
		?>

		<?php get_template_part( 'loop' ); // Loads post loop. ?>

		<?php wp_reset_query(); // Reset variables. ?>
		
	</main><!-- #content -->

<?php get_footer(); // Loads the footer.php template. ?>