<?php

class Losatom_Widget_Social extends WP_Widget {

	public $sites = array( 'facebook', 'twitter', 'googleplus', 'youtube', 'linkedin', 'instagram', 'pinterest', 'github', 'flickr', 'wordpress', 'codepen', 'digg', 'dribbble', 'dropbox', 'skype', 'getpocket', 'reddit', 'stumbleupon', 'tumblr', 'vimeo', );

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_social', 
			'description' => __( 'Displays social profiles.', 'losatom' ) 
		);		

		parent::__construct( 
			'Losatom_Widget_Social', 
			THEME_NAME . ' ' . __( 'Social Profiles', 'losatom' ), 
			$widget_options 
		);			
	}
		
	function form( $instance ) {
		?>
		
		<?php foreach( $this->sites as $site ) : ?>
			
			<p>
				<label for="<?php echo $this->get_field_id( $site ); ?>">
					<?php echo ( $site != 'googleplus' ) ? ucfirst( $site ) : 'Google Plus'; ?>:
				</label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id( $site ); ?>" name="<?php echo $this->get_field_name( $site ); ?>" value="<?php echo esc_url( $instance[$site] ); ?>" />
			</p>

		<?php endforeach; ?>
 
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		foreach( $new_instance as $key => $value )
			$new_instance[$key] = esc_url_raw( $value );
			
	    return $new_instance;
	}
	
	function widget( $args, $instance ) {
		
		extract( $args );
		
		echo $before_widget;
		
		$is_landing_page = is_losatom_landing_page();
		echo ( $is_landing_page ) ? '<div class="wrap">' : '';
		?>
	  		<ul>

	  			<?php foreach( $instance as $key => $value ) : ?>
	  				
	  				<?php if ( ! empty( $value ) ) : ?>  				
			  			<li><a href="<?php echo esc_url( $value ); ?>"></a></li>
		  			<?php endif; ?>

	  			<?php endforeach ?>

	  		</ul>
		<?php 
		echo ( $is_landing_page ) ? '</div>' : '';		
		echo $after_widget;	
	}
		 
}

?>