<?php

class Losatom_Widget_CTA extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 
			'classname'   => 'losatom_widget_cta left_aligned', 
			'description' => __( 'Displays call to action.', 'losatom' ) 
		);		
		
		parent::__construct( 
			'Losatom_Widget_CTA', 
			THEME_NAME . ' - ' . __( 'Call To Action', 'losatom' ), 
			$widget_options 
		);			
	}
		
	function form( $instance ) {
 
		$type        = isset( $instance['display_type'] ) ? esc_attr( $instance['display_type'] ) : 'centered';	
		$title       = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';				
		$content     = isset( $instance['content'] ) ? esc_textarea( $instance['content'] ) : '';				
		$button_text = isset( $instance['button_text'] ) ? esc_attr( $instance['button_text'] ) : '';			
		$button_link = isset( $instance['button_link'] ) ? esc_url( $instance['button_link'] ) : '#';	
		?>

		<p>
			<?php _e( 'Display:', 'losatom' ); ?> &nbsp; 
			<input type="radio" name="<?php echo $this->get_field_name( 'display_type' ); ?>" id="<?php echo $this->get_field_id( 'radio_1' ); ?>" value="centered" <?php echo checked( $type, 'centered' ); ?>>
			<label for="<?php echo $this->get_field_id( 'radio_1' ); ?>"><?php _e( 'Centered', 'losatom' ); ?></label>  &nbsp;
			<input type="radio" name="<?php echo $this->get_field_name( 'display_type' ); ?>" id="<?php echo $this->get_field_id( 'radio_2' ); ?>" value="left_aligned" <?php echo checked( $type, 'left_aligned' ); ?>>
			<label for="<?php echo $this->get_field_id( 'radio_2' ); ?>"><?php _e( 'Full Width (works on front page only)', 'losatom' ); ?></label>
		</p>
 
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php _e( 'Title:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
		</p>	
		
		<p>
			<label for="<?php echo $this->get_field_id( 'content' ); ?>">
				<?php _e( 'Text:', 'losatom' ); ?>
			</label>
			<textarea class="widefat" rows="10" cols="10" id="<?php echo $this->get_field_id('content'); ?>" name="<?php echo $this->get_field_name('content'); ?>"><?php echo $content; ?></textarea>			
		</p>					
		
		<p>
			<label for="<?php echo $this->get_field_id( 'button_text' ); ?>">
				<?php _e( 'Button Text:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'button_text' ); ?>" name="<?php echo $this->get_field_name( 'button_text' ); ?>" value="<?php echo $button_text; ?>" />
		</p>				
 
		<p>
			<label for="<?php echo $this->get_field_id( 'button_link' ); ?>">
				<?php _e( 'Button Link:', 'losatom' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'button_link' ); ?>" name="<?php echo $this->get_field_name( 'button_link' ); ?>" value="<?php echo $button_link; ?>" />
		</p>	 
 	
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 

		$instance['display_type'] = esc_attr( $new_instance['display_type'] ); 
		$instance['title']        = esc_attr( $new_instance['title'] ); 
		$instance['content']      = esc_attr( $new_instance['content'] ); 
		$instance['button_text']  = esc_attr( $new_instance['button_text'] ); 
		$instance['button_link']  = esc_url( $new_instance['button_link'] ); 
 
	    return $instance;
	}
	
	function widget( $args, $instance ) {

		extract( $args );
		
		$display_type = isset( $instance['display_type'] ) ? esc_attr( $instance['display_type'] ) : 'centered';
		$title        = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$content      = isset( $instance['content'] ) ? esc_attr( $instance['content'] ) : '';
		$button_text  = isset( $instance['button_text'] ) ? esc_attr( $instance['button_text'] ) : '';
		$button_link  = isset( $instance['button_link'] ) ? esc_url( $instance['button_link'] ) : '#';

		/* 
		*  Full width widget will work only on front page. 
		*  If full width is selected in primary sidebar - make it centered. 
		*/
		global $sidebars_widgets;
		
		$forbidden_sidebars = array_merge( $sidebars_widgets['primary'], $sidebars_widgets['subsidiary'] );
		
		if ( in_array( $widget_id, $forbidden_sidebars ) || 'centered' == $display_type )
			$before_widget = str_replace( 'left_aligned', 'centered', $before_widget );	


		/* Check whether is losatom's landing page active. */
		$is_landing_page = is_losatom_landing_page();

		echo $before_widget;

		$animation_text   = '';
		$animation_button = '';

		if ( $is_landing_page ) {
			$animation_text   = 'data-sr="wait .3s, enter bottom hustle 150px over .7s"';
			
			if ( 'centered' == $display_type )
				$animation_button = 'data-sr="wait .9s, flip 360deg over .5s"';
			else
				$animation_button = 'data-sr="wait .9s, enter top hustle 100px over .5s"';

			echo '<div class="wrap">';
		}


		if ( ! empty( $title ) ) {
			$before_title = str_replace( '<h3', '<h3 data-sr="enter bottom hustle 150px over .7s"', $before_title );
			echo $before_title . apply_filters( 'widget_title', $title ) . $after_title;	
		}

		if ( ! empty( $content ) ) 
			echo "<p {$animation_text}>{$content}</p>";
 

		$button_link = ! empty( $button_link ) ? $button_link : '#';

		if ( ! empty( $button_text ) ) 
			echo '<a '. $animation_button .' class="button call-button" href="'. $button_link .'">'. $button_text .'</a>';

		if ( $is_landing_page )		
			echo '</div>';

		echo $after_widget;	
 	}
		 
}

?>