jQuery(document).ready(function() {

	/*==== RESPONSIVE PRIMARY MENU SETUP ====*/
	if ( jQuery( '#menu-primary-items' ).length ) {
		var nav = responsiveNav("#menu-primary-items", { 
			animate: true, 
			transition: 500, 
			insert: "before", 
			customToggle: "#toggle-primary-menu", 
			closeOnNavClick: false, 
			openPos: "relative", 
			navClass: "nav-collapse", 
			navActiveClass: "js-nav-active", 
			jsClass: "js" 
		}); 
	}
 
	/* ===== FITVIDS ===== */
	jQuery("#content").fitVids({ customSelector: "iframe[src*='wordpress.tv'], iframe[src*='www.dailymotion.com'], iframe[src*='blip.tv'], iframe[src*='www.viddler.com']"});	
 
	if ( typeof ParamsSlider !== "undefined" ) {
		/* ===== CONTENT SLIDER ===== */			
		jQuery('.bxslider').bxSlider({
			mode: ParamsSlider.mode,
			auto: ParamsSlider.auto,
			pause: ParamsSlider.pause,
			autoHover: true,
			slideWidth: 0,
			adaptiveHeight: false,
			pager: false,
			prevText: '<i class="fa fa-chevron-left"></i>',
			nextText: '<i class="fa fa-chevron-right"></i>'
		});						
	}

	/*==== TICKER SETUP ====*/			
	if ( typeof ParamsTicker !== "undefined" ) {		
		jQuery('.ticker').bxSlider({
 			ticker: true,
 			tickerHover: true,
			speed: 20000,
			slideWidth: 233,
			slideMargin: 15,
			minSlides: 3,
			maxSlides: 3,
			useCSS: false
		});		

		var ticker_title_width = jQuery( '.breaking-title' ).outerWidth();
		jQuery( '#header-top .bx-wrapper' ).css( 'left', ticker_title_width + 25 );			
	}
	
	/*=== SLY CATEGORIES ===*/
	if ( typeof ParamsFc !== "undefined" ) {	
		jQuery( '#category-slider' ).sly({
			horizontal: 1,
			itemNav: 'basic',
			smart: 1,
			activateOn: 'click',
			mouseDragging: 1,
			touchDragging: 1,
			releaseSwing: 1,
			startAt: 0,
			scrollBar: '.scrollbar',
			scrollBy: 1,
			pagesBar: '.pages',
			activatePageOn: 'click',
			speed: 300,
			elasticBounds: 1,
			dragHandle: 1,
			dynamicHandle: 1,
			clickBar: 1,

			// Cycling
			cycleBy: 'pages',
			cycleInterval: ParamsFc.fc_speed,
			pauseOnHover: 1,

			// Buttons
			prevPage: '#cat-nav .prev',
			nextPage: '#cat-nav .next'
		});	

		jQuery( window ).resize( function(){
			jQuery( '#category-slider' ).sly( 'reload' );
		});

	}	
		
	/*==== SEARCH IN TICKER ====*/
	if ( jQuery( '#header-top .search' ).length ) {
		jQuery( '#header-top .search .search-text' ).attr( 'id', 'top-search' );
		jQuery( '#header-top .search .search-button' ).attr( 'id', 'top-button' );
		jQuery( '.search-button' ).click( function(){
			jQuery(this).parent().addClass( 'expand' );
		});
		jQuery( 'html' ).click( function(e) {
			var id = e.target.id;
			if ( id !== 'top-search' && id !== 'top-button' )
				jQuery( '#header-top .search-wrap' ).removeClass( 'expand' );
		});
		
		jQuery( document ).keyup( function(e) {
			if ( e.keyCode == 27 )
				jQuery( '#header-top .search-wrap' ).removeClass( 'expand' );
		})
	}

	/*==== MASONRY SETUP ====*/	
	if ( typeof swtMasonry !== "undefined" ) {

		var $container = jQuery( '.post-wrapper' );	
		
		$container.imagesLoaded( function() {
			$container.masonry({
				itemSelector: '.entry',
				columnWidth: '.grid-sizer',
				gutter: '.gutter-sizer'
			});
		});

		var iurl = swtMasonry.img;
		iurl.replace('\\','');
 		$container.infinitescroll({
			navSelector : "#ajax_load_posts",
			nextSelector : "#ajax_load_posts a",
			itemSelector : ".entry",
			behavior: "twitter",			
			loading: {
				img: iurl,
				msg: null,
				msgText: '',
				finishedMsg: swtMasonry.msgfinish
 			}
		}, function( newElements ) {
			var $newElems = jQuery( newElements ).css({ opacity: 0 });
			$newElems.imagesLoaded(function(){
				$newElems.animate({ opacity: 1 });
				$container.masonry( 'appended', $newElems, true );
			});
		});
	}
});