<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

		<header class="entry-header">

			<?php the_title( '<h1 ' . hybrid_get_attr( 'entry-title' ) . '>', '</h1>' ); ?>			

			<div class="entry-byline">				
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'By', 'swt' ); ?> <?php the_author_posts_link(); ?></span>
				<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date('F d, Y'); ?></time>	
				<?php comments_popup_link( number_format_i18n( 0 ), number_format_i18n( 1 ), '%', 'comments-link', 'Off' ); ?>				
			</div>
						
		</header><!-- .entry-header -->
		
		<?php $size = theme_layouts_get_layout() === 'layout-1c' ? 'full' : 'swt-large'; ?>

		<?php get_the_image( array( 'link_to_post' => false, 'size' => $size, 'order' => array( 'featured', 'attachment' ) ) ); ?>				
				
		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<?php if ( !is_page() ) : ?>
		
			<footer class="entry-footer">
				<?php hybrid_post_terms( array( 'taxonomy' => 'category', 'text' => __( 'Posted in %s', 'swt' ) ) ); ?>			
				<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'sep' => '' ) ); ?>			
			</footer><!-- .entry-footer -->
		
		<?php endif; ?>			
		
	<?php else : // If not viewing a single post. ?>
 
		<?php get_the_image( 
			array( 
				'link_to_post' => false, 
				'size' 	=> 'swt-featured-image', 
				'order' => array( 'featured', 'attachment' ), 
				'before'=> '<figure class="img-wrap">', 
				'after' => '<span class="img-overlay">'
						  .'<a class="link-to-post" href="'. get_the_permalink() .'">'
						  .'<i class="fa fa-link"></i>'
						  .'</a></span></figure>' 
			) 
		); ?>		
	
		<header class="entry-header">
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>
			<?php comments_popup_link( number_format_i18n( 0 ), number_format_i18n( 1 ), '%', 'comments-link', 'Off' ); ?>		
			<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date('F d, Y'); ?></time>
		</header><!-- .entry-header -->
	
		<div <?php hybrid_attr( 'entry-summary' ); ?>>
			<?php the_excerpt(''); ?>
		</div><!-- .entry-summary -->
		
	<?php endif; // End single post check. ?>

</article><!-- .entry -->