<?php 
$cat_plugin_url = '<a target="_blank" href="'. admin_url( 'plugin-install.php?tab=search&s=categories-images' ) .'">'.__( 'Categories Images', 'swt' ) .'</a>';	
$cat_url = '<a target="_blank" href="'. admin_url( 'edit-tags.php?taxonomy=category' ) .'">'.__( 'categories', 'swt' ) .'</a>';	

$tab_general = array( 
 
	array( 
		'type' => 'section',
		'title' => __('Favicon', 'swt'),
		'description' => __( 'A favicon (short for Favorite icon), is also known as a shortcut icon, Web site icon, URL icon or bookmark icon, most commonly 16x16 pixels, associated with a particular Web site or Web page. Accepted formats: .ico, .png and .gif.', 'swt' ),
		'fields' => array( 
 
			array(
				'type' => 'upload',
				'name' => 'favicon',
				'label' => __('Upload Favicon', 'swt'),				
				'default' => '',
			),
			
		),
	),
	
	array( 
		'type' => 'section',
		'title' => __('Header Banner', 'swt'),
		'description' => __( '', 'swt' ),
		'fields' => array( 
 
			array(
				'type' => 'upload',
				'name' => 'header_banner',
				'label' => __('Upload Banner', 'swt'),				
				'default' => '',
			),
			
			array(
				'type' => 'textbox',
				'name' => 'header_banner_url',
				'label' => __('Banner URL', 'swt'),				
				'validation' => 'url'
			),			
			
		),
	),	
	
	array( 
		'type' => 'section',
		'title' => __('Social Profiles', 'swt'),
		'fields' => array( 
 
			array(
				'type' => 'toggle',
				'name' => 'swt_social_profiles',
				'label' => __( "Enable Social Profiles?", "swt" ),
				'default' => 0,
			),	 
 
			array(
				'type' => 'textbox',
				'name' => 'social_facebook',
				'label' => __('Facebook URL', 'swt'),				
				'validation' => 'url'
			),
			
			array(
				'type' => 'textbox',
				'name' => 'social_twitter',
				'label' => __('Twitter URL', 'swt'),				
				'validation' => 'url'
			),			
			
			array(
				'type' => 'textbox',
				'name' => 'social_google',
				'label' => __('Google URL', 'swt'),				
				'validation' => 'url'
			),			
			
			array(
				'type' => 'textbox',
				'name' => 'social_youtube',
				'label' => __('Youtube URL', 'swt'),				
				'validation' => 'url'
			),			
			
			array(
				'type' => 'textbox',
				'name' => 'social_rss',
				'label' => __('RSS URL', 'swt'),				
				'validation' => 'url'
			),			
			
		),
	),

	array( 
		'type' => 'section',
		'title' => __('Infinite Scroll', 'swt'),
		'fields' => array( 
			array(
				'type' => 'textbox',
				'name' => 'load_text',
				'default' => 'Load More',
				'label' => __('Button Text', 'swt'),
			),
			array(
				'type' => 'textbox',
				'name' => 'finishedMsg',
				'default' => 'All Posts Loaded!',
				'label' => __('Loaded Posts Message:', 'swt'),
			),						
		),
	),	
);


$tab_slider = array( 

	array( 
	'type'        => 'section',
	'title'       => __('Ticker', 'swt'),
	'description' => __( '', 'swt' ),
	'fields'      => array(
			
			array(
			'type'        => 'toggle',
			'name'        => 'ticker',
			'label'       => __( "Enable ticker?", "swt" ),
			'default'     => 0,
			),		
			
			array(
			'type'        => 'textbox',
			'name'        => 'ticker_text',
			'label'       => __('Ticker Text', 'swt'),			
			'default'     => 'Breaking:'	
			),		
			
			array(
			'type'        => 'multiselect',
			'name'        => 'ticker_cat',
			'label'       => __('Ticker Categories', 'swt'),
			'description' => __('Select categories from which you want to display news.', 'swt'),
			'items'       => vp_get_categories(),
			),	
			
			array(
			'type'        => 'textbox',
			'name'        => 'ticker_number',
			'label'       => __('Number of Ticker Items', 'swt'),
			'default'     => '5',
			'validation'  => 'numeric',
			),	
			
			array(
			'type'        => 'toggle',
			'name'        => 'top_search',
			'label'       => __( "Enable Top Search?", "swt" ),
			'default'     => 0,
			),		
		
		),
	),	
			
			array( 
			'type'        => 'section',
			'title'       => __('Content Slider', 'swt'),
			'description' => __( '', 'swt' ),
			'fields'      => array( 		
			
			array( 
				'name'          => 'slider_note',
				'label' 		=> __( 'How to add posts to content slider?', 'swt' ),
				'description' 	=> __( 'First thing - you need to enable content slider by checking "Enable content slider" below. Make a new post, and set a featured image for it. Save it, and click on "All posts". Find the  post you just made, and click on "Quick Edit". Now just click on "Make this post sticky" and click "Update". Make at least one more post this way, or slider will slide to the same post again and  again.', 'swt' ),
				'status' 		=> 'info',
				'type' 			=> 'notebox'
			),
			
			array(
				'type' 		=> 'toggle',
				'name' 		=> 'swt_slider',
				'label' 	=> __( 'Enable Content Slider?', 'swt' ),
				'default' 	=> 1,
			),			
			
			 array(
				'type' 			=> 'slider',
				'name' 			=> 'slider_speed',
				'label' 		=> __( 'Slider Speed', 'swt' ),
				'description' 	=> __( 'The amount of time (in ms) between each slide.', 'swt' ),
				'min' 			=> '100',
				'max' 			=> '20000',
				'step' 			=> '100',
				'default' 		=> '4000',
			),		
			
			array(
				'type' 	=> 'radiobutton',
				'name' 	=> 'slider_auto',
				'label' => __( 'Automatic Slides?', 'swt' ),
				'items' => array(
				
					array(
						'value' => 'true',
						'label' => __( 'Yes', 'swt' ),
					),
					
					array(
						'value' => 'false',
						'label' => __( 'No', 'swt' ),
					),
		 
				),
				'default' => array( 'true' ),
			),		
		
			array(
				'type' 	=> 'select',
				'name' 	=> 'slider_mode',
				'label' => __( 'Type of transition between slides?', 'swt' ),
				'items' => array(
				
					array(
						'value' => 'fade',
						'label' => __( 'Fade', 'swt' ),
					),
					
					array(
						'value' => 'horizontal',
						'label' => __( 'Horizontal', 'swt' ),
					),
					
					array(
						'value' => 'vertical',
						'label' => __( 'Vertical', 'swt' ),
					),
					
				),
				'default' => array( 'fade' ),
			),		
		),		
	),		

	array( 
		'type'        => 'section',
		'title'       => __('Category Slider', 'swt'),
		'description' => __( '', 'swt' ),
		'fields'      => array( 			

			array(
				'type'   => 'notebox',
				'label'  => sprintf( __( "In order to use this option, you need to install %s plugin, and upload images to %s.", "swt" ), $cat_plugin_url, $cat_url),
				'status' => 'info',				
			),

			array(
				'type'    => 'toggle',
				'name'    => 'fc_slider',
				'label'   => __( "Enable Category Slider?", "swt" ),
				'default' => 0,
			),		
		
			array(
				'type'    => 'textbox',
				'name'    => 'fc_text',
				'label'   => __('Category Text', 'swt'),			
				'default' => 'Categories'	
			),		
			
			array(
				'type'        => 'multiselect',
				'name'        => 'fc_cats',
				'label'       => __('Categories to Show', 'swt'),
				'description' => __('Select categories which you want to show.', 'swt'),
				'items'       => vp_get_categories(),
			),	

			array(
				'type'    => 'textbox',
				'name'    => 'fc_count_text',
				'label'   => __('Number of Posts Text:', 'swt'),
				'default' => 'Total Posts:',
			),	

			array(
				'type'        => 'slider',
				'name'        => 'fc_speed',
				'label'       => __('Slide Speed', 'swt'),
				'description' => __('In seconds (set to 0 if you don\'t want auto scrolling.).', 'swt'),
				'min'         => '0',
				'max'         => '60',
				'step'        => '0.1',
				'default'     => '4',
			),				
						
		),
	),			
);

$tab_layout = array( 
	
	array( 
		'type' => 'section',
		'title' => __('Site Layout', 'swt'),
		'fields' => array( 
		
			array(
				'type' => 'radioimage',
				'name' => 'site_layout',
				'label' => __('Default Site Layout For Singular Pages (post/page).', 'swt'),
				'items' => 
					array(
						array(
							'value' => 'layout-1c',
							'label' => __('Full Width', 'swt'),
							'img' => VP_URL.'/options/img/1cl.png',
						),
						array(
							'value' => 'layout-2c-l',
							'label' => __('Content / Sidebar', 'swt'),
							'img' => VP_URL.'/options/img/2cl.png',
						),
						array(
							'value' => 'layout-2c-r',
							'label' => __('Sidebar / Content', 'swt'),
							'img' => VP_URL.'/options/img/2cr.png',
						), 
					), 'default' => array( 'layout-2c-l' )
			),	
		),
	),
);

$tab_scripts = array( 
	
	array(
		'type' => 'codeeditor',
		'name' => 'header_scripts',
		'label' => __('Header Scripts', 'swt'),
		'description' => __('Add scripts before &lt;/head&gt; tag (ie tracking code or custom Javascript).', 'swt'),
		'theme' => 'github',
	),		

	array(
		'type' => 'codeeditor',
		'name' => 'footer_scripts',
		'label' => __('Footer Scripts', 'swt'),
		'description' => __('Add scripts before &lt;/body&gt; tag (ie tracking code or custom Javascript).', 'swt'),
		'theme' => 'github',
	),
	
	array(
		'type' => 'codeeditor',
		'name' => 'custom_css',
		'label' => __('Custom CSS', 'swt'),
		'description' => __('Write your custom CSS here.', 'swt'),
		'theme' => 'github',
		'mode' => 'css',
	),		

);
 

?>