<?php
class SWT_Popular_Posts_Widget extends WP_Widget {
		
	public function __construct() {
		
		$widget_options = array( 'classname' => 'swt_popular_posts swt_posts', 'description' => __( "Displays most popular Posts.", 'swt' ) );
		parent::WP_Widget( 'SWT_Popular_Posts_Widget', __( 'SWT - Popular Posts', 'swt' ), $widget_options );					
		$this->alt_option_name = 'widget_popular_entries';
		
		add_action( 'save_post', 	array( $this, 'flush_widget_cache' ) );
		add_action( 'deleted_post', array( $this, 'flush_widget_cache' ) );
		add_action( 'switch_theme', array( $this, 'flush_widget_cache' ) );
	}
 
	public function form( $instance ) {
		
		$title       = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number      = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		$categories  = isset( $instance['categories'] ) ? $instance['categories'] : array();	
		$show_desc   = isset( $instance['show_desc'] ) ? (bool) $instance['show_desc'] : false;				
		$desc_length = isset( $instance['desc_length'] ) ? (int) $instance['desc_length'] : 60;				
		$video_post  = isset( $instance['video_post'] ) ? (bool) $instance['video_post'] : false;				
		?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:' ); ?></label>
			<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" />
		</p>
				
		<p class="widget-select-container">
 			<label for="<?php echo $this->get_field_id( 'categories' ); ?>"><?php _e( 'Choose Categories:', 'swt' ); ?></label>		
			<select name="<?php echo $this->get_field_name( 'categories' ); ?>[]" id="<?php echo $this->get_field_id( 'categories' ); ?>"  style="width:300px" class="widefat chosen" multiple="multiple">
			<?php foreach( vp_get_categories() as $cat => $info ) : ?>
				<option value="<?php echo absint( $info['value'] ); ?>" <?php echo in_array( $info['value'], $categories ) ? 'selected="selected"' : ''; ?>><?php echo esc_attr( $info['label'] ); ?></option>
			<?php endforeach; ?>
			</select>		
		</p>
			
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $video_post ); ?> id="<?php echo $this->get_field_id( 'video_post' ); ?>" name="<?php echo $this->get_field_name( 'video_post' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'video_post' ); ?>"><?php _e( 'Show play button on images? Useful if you\'re displaying video category.' ); ?></label>
		</p>

		<p>
			<input class="checkbox" type="checkbox" <?php checked( $show_desc ); ?> id="<?php echo $this->get_field_id( 'show_desc' ); ?>" name="<?php echo $this->get_field_name( 'show_desc' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_desc' ); ?>"><?php _e( 'Show description?' ); ?></label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'desc_length' ); ?>"><?php _e( 'Number of charachters to show in description?' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'desc_length' ); ?>" name="<?php echo $this->get_field_name( 'desc_length' ); ?>" type="text" value="<?php echo $desc_length; ?>" />
		</p>		

 		
		<?php
	}
	
	public function update( $new_instance, $old_instance ) {
		
		$instance                = $old_instance;
		$instance['title']       = strip_tags($new_instance['title']);
		$instance['categories']  = $new_instance['categories'];
		$instance['number']      = (int) $new_instance['number'];		
		$instance['show_desc']   = isset( $new_instance['show_desc'] ) ? (bool) $new_instance['show_desc'] : false;		
		$instance['desc_length'] = isset( $new_instance['desc_length'] ) ? (int) $new_instance['desc_length'] : 60;
		$instance['video_post']  = isset( $new_instance['video_post'] ) ? (bool) $new_instance['video_post'] : false;	

 		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_popular_entries']) )
			delete_option( 'widget_popular_entries' );

		return $instance;
	}

	public function flush_widget_cache() {
		wp_cache_delete( 'widget_popular_entries', 'widget' );
	}
	
	public function widget( $args, $instance ) { 
	
		$cache = array();
		if ( ! $this->is_preview() ) {
			$cache = wp_cache_get( 'widget_popular_entries', 'widget' );
		}

		if ( ! is_array( $cache ) ) {
			$cache = array();
		}

		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts' );

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number )
			$number = 5;
		
		$selected_cats = array();
		
		if ( ! empty( $instance['categories'] ) ) {
			foreach( $instance['categories'] as $cat ) {
				$selected_cats[] = (int) $cat;
			}
		}  
		
		$video_post  = isset( $instance['video_post'] ) ? $instance['video_post'] : false;		
		$show_desc   = isset( $instance['show_desc'] ) ? $instance['show_desc'] : false;		
		$desc_length = ( ! empty( $instance['desc_length'] ) ) ? absint( $instance['desc_length'] ) : 60;

 
		/**
		 * Filter the arguments for the Recent Posts widget.
		 *
		 * @since 3.4.0
		 *
		 * @see WP_Query::get_posts()
		 *
		 * @param array $args An array of arguments used to retrieve the recent posts.
		 */
		$r = new WP_Query( apply_filters( 'widget_posts_args', array(
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => true,
			'category__in' 		  => $selected_cats,
			'order' 			  => 'DESC',			
			'orderby' 			  => 'comment_count',
		) ) );

		if ( $r->have_posts() ) :
?>
		<?php echo $args['before_widget']; ?>
		<?php if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
		<ul>
		<?php while ( $r->have_posts() ) : $r->the_post(); ?>
			<li class="clear">
				
				<?php 
				$play = ( $video_post !== false ) ? '<i class="fa fa-play"></i>' : '';
				get_the_image( 
					array( 
					'size'         => 'swt-widget-image', 
					'order'        => array( 'featured', 'attachment' ), 
					'before'       => '<a href="'. get_permalink() .'"><span class="widget-image-wrap">' . $play, 
					'after'        => '</span></a>',
					'link_to_post' => false,
					) 
					); 
				?>
				
				<div class="post-info">
					<h3 class="featured-title"><a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a></h3>
					<?php if ( $show_desc ) : ?>
						<p><?php truncate_post( $desc_length ); ?></p>
					<?php endif; ?>
				</div>
			</li>
		<?php endwhile; ?>
		</ul>
		<?php echo $args['after_widget']; ?>
		<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;

		if ( ! $this->is_preview() ) {
			$cache[ $args['widget_id'] ] = ob_get_flush();
			wp_cache_set( 'widget_popular_entries', $cache, 'widget' );
		} else {
			ob_end_flush();
		}
	}	
	
}