<?php if ( swt_get_option( 'fc_slider', false ) == true ) : ?>

	<div id="featured-cats">

		<div class="wrap">
			
			<?php $cat_text = swt_get_option( 'fc_text', 'Categories' ); ?>

			<?php if ( !empty( $cat_text ) ) : ?>
			
			<h3 id="section-title"><span><?php echo $cat_text; ?></span></h3>	
			
			<?php endif; ?>
									
			<div id="category-slider" class="cat-slide">
							
				<ul class="slidee">						

					<?php $cats = get_categories(); ?>
					
					<?php foreach( $cats as $cat ) : ?>
					
					<?php if ( in_array( $cat->cat_ID, swt_get_option( 'fc_cats' ) ) ) : ?>
					
						<li>
							<a href="<?php echo esc_url( get_category_link( $cat->cat_ID ) ); ?>">
							<?php if ( function_exists( 'z_taxonomy_image_url' ) && z_taxonomy_image_url($cat->term_id) !== false ) : ?>
								<img src="<?php echo esc_url( z_taxonomy_image_url( $cat->term_id, 'swt-cat-image' ) ); ?>" alt="<?php echo esc_attr( $cat->name ); ?>" />
							<?php else : ?>
								<img src="<?php echo get_template_directory_uri() .'/images/category-default.gif'; ?>" alt="<?php echo esc_attr( $cat->name ); ?>" />						
							<?php endif; ?>
							<span class="image-overlay transition"></span>
							<div class="cat-meta transition">
								<h4 class="cat-title"><?php echo esc_attr( $cat->name ); ?></h4>
								<span class="cat-count"><?php echo swt_get_option( 'fc_count_text', 'Total Posts:' ), esc_attr( $cat->category_count ); ?></span>
							</div><!--.entry-cat-->
							</a>
						</li>
						
					<?php endif; ?>
					
					<?php endforeach; ?>
									
				</ul>
				
			</div><!--#category-slider-->
			
			<div id="cat-nav" class="clear">
				<a class="prev"></a>
				<a class="next"></a>			
				<div class="scrollbar">
					<div class="handle"><i class="fa fa-bars"></i></div>
				</div>			
			</div>		
			
		</div><!--.wrap-->
		
	</div><!--#featured-cats--><!-- id="featured-cats--"></!-->

<?php endif; ?>