<?php
$nl = "</p><p>";
$ol = "<p>";
$cl = "</p>";

$img_dir = trailingslashit( get_template_directory_uri() ) . 'admin/options/img/';

 
return array(
 
	'Layout Elements' => array(
		'elements' => array(
			'section'  => array(
				'title' => 'Section',
				'code'  => $ol.'[section]'.$nl.__('Your content here', 'swt').$nl.'[/section]',
				'attributes' => array(
 				
					array(
						'name'  => 'center',
						'type'  => 'toggle',
						'label' => __('Center section content in the middle of the site', 'swt'),
						'default' => 0,
					),															
					array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('Title', 'swt'),
					),	
					'st_color_scheme' => array(
						'name'  => 'color_scheme',
						'type'  => 'select',
						'label' => __('Title Color Scheme', 'swt'),
						'items' => array(
							array(
								'value' => 'color_1',
								'label' => 'Black Title, Orange Divider'
							),
							array(
								'value' => 'color_2',
								'label' => 'White Title, Black Divider'
							),
							array(
								'value' => 'color_3',
								'label' => 'Black Title And Black Divider'
							),
						),
						'default' => array('{{first}}')
					),	
					array(
						'name'  => 'title_color',
						'type'  => 'color',
						'label' => __('Custom Title Color', 'swt'),
						'default' => '',
					),						
					array(
						'name'  => 'background_color',
						'type'  => 'color',
						'label' => __('Background color', 'swt'),
						'default' => '',
					),								
					array(
						'name'  => 'background_image_url',
						'type'  => 'upload',
						'label' => __('Background Image URL', 'swt'),
					),
					array(
						'name'  => 'background_image_repeat',
						'type'  => 'select',
						'label' => __('Background Image Repeat', 'swt'),
						'items' => array(
							array(
								'value' => 'no-repeat',
								'label' => 'no-repeat'
							),
							array(
								'value' => 'repeat-x',
								'label' => 'repeat-x'
							),
							array(
								'value' => 'repeat-y',
								'label' => 'repeat-y'
							),
							array(
								'value' => 'repeat',
								'label' => 'repeat'
							),							
						), 
					),
					array(
						'name'  => 'background_image_attachment',
						'type'  => 'select',
						'label' => __('Background Image Attachment', 'swt'),
						'items' => array(
							array(
								'value' => 'scroll',
								'label' => 'scroll'
							),
							array(
								'value' => 'fixed',
								'label' => 'fixed'
							),
							array(
								'value' => 'inherit',
								'label' => 'inherit'
							),
						),
					),
					array(
						'name'  => 'background_image_position',
						'type'  => 'select',
						'label' => __('Background Image Position', 'swt'),
						'items' => array(
							array(
								'value' => 'top left',
								'label' => 'top left'
							),
							array(
								'value' => 'top center',
								'label' => 'top center'
							),
							array(
								'value' => 'top right',
								'label' => 'top right'
							),
							array(
								'value' => 'center left',
								'label' => 'center left'
							),
							array(
								'value' => 'center center',
								'label' => 'center center'
							),
							array(
								'value' => 'center right',
								'label' => 'center right'
							),
							array(
								'value' => 'bottom left',
								'label' => 'bottom left'
							),
							array(
								'value' => 'bottom center',
								'label' => 'bottom center'
							),
							array(
								'value' => 'bottom right',
								'label' => 'bottom right'
							),
						),
					),
					
					array(
						'name'  => 'height',
						'type'  => 'select',
						'label' => __('Section Minimum Height', 'swt'),
						'items' => array(
							array(
								'value' => 'none',
								'label' => 'No minimum height, use content within section to define Section height'
							),
							array(
								'value' => '100',
								'label' => 'At least 100% of Browser Window height'
							),
							array(
								'value' => '75',
								'label' => 'At least 75% of Browser Window height'
							),
							array(
								'value' => '50',
								'label' => 'At least 50% of Browser Window height'
							),	
							array(
								'value' => '25',
								'label' => 'At least 25% of Browser Window height'
							),								
						),
					),
					
					array(
						'name'  => 'padding',
						'type'  => 'select',
						'label' => __('Section Padding', 'swt'),
						'items' => array(
							array(
								'value' => 'default',
								'label' => 'Default (70px)'
							),
							array(
								'value' => 'small',
								'label' => 'Small (40px)'
							),
							array(
								'value' => 'large',
								'label' => 'Large (120px)'
							),
							array(
								'value' => 'none',
								'label' => 'No padding'
							),							
						), 
					),										
				),
			),
			
			'column_full' => array(
				'title'   => '1/1 Column',
				'code'  =>  $ol.'[one_full]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_full]'.$cl,						
			),				
 
			'columns_2_halfs' => array(
				'title'   => '1/2 + 1/2 Columns',
				'code'  =>  $ol.'[one_half first]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_half]'.$cl .
							$ol.'[one_half]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_half]'.$cl,
			),			

			'columns_3_thirds' => array(
				'title'   => '1/3 + 1/3 + 1/3 Columns',
				'code'  =>  $ol.'[one_third first]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_third]'.$cl .
							$ol.'[one_third]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_third]'.$cl.
							$ol.'[one_third]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_third]'.$cl,
			),	
			
			'columns_2_thirds' => array(
				'title'   => '2/3 + 1/3 Columns',
				'code'  =>  $ol.'[two_thirds first]'.$nl.__('Add Content Here', 'swt').$nl.'[/two_thirds]'.$cl .
							$ol.'[one_third]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_third]'.$cl,
			),				
			
			'columns_4_quarters' => array(
				'title'   => '1/4 + 1/4 + 1/4 + 1/4 Columns',
				'code'  =>  $ol.'[one_fourth first]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fourth]'.$cl .
							$ol.'[one_fourth]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fourth]'.$cl.
							$ol.'[one_fourth]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fourth]'.$cl.
							$ol.'[one_fourth]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fourth]'.$cl,
			),

			'columns_3_quarters' => array(
				'title'   => '3/4 + 1/4 Columns',
				'code'  =>  $ol.'[three_fourths first]'.$nl.__('Add Content Here', 'swt').$nl.'[/three_fourths]'.$cl .
							$ol.'[one_fourth]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fourth]'.$cl,
			),					
			
			'columns_5_fifths' => array(
				'title'   => '1/5 + 1/5 + 1/5 + 1/5 + 1/5 Columns',
				'code'  =>  $ol.'[one_fifth first]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fifth]'.$cl .
							$ol.'[one_fifth]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fifth]'.$cl.
							$ol.'[one_fifth]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fifth]'.$cl.
							$ol.'[one_fifth]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fifth]'.$cl.
							$ol.'[one_fifth]'.$nl.__('Add Content Here', 'swt').$nl.'[/one_fifth]'.$cl,
			),

			'columns_2_fifths' => array(
				'title'   => '2/5 Column',
				'code'  =>  $ol.'[two_fifths first]'.$nl.__('Add Content Here', 'swt').$nl.'[/two_fifths]'.$cl,					
			),				
			
			'columns_3_fifths' => array(
				'title'   => '3/5 Column',
				'code'  =>  $ol.'[three_fifths first]'.$nl.__('Add Content Here', 'swt').$nl.'[/three_fifths]'.$cl,					
			),							
			
			'columns_4_fifths' => array(
				'title'   => '4/5 Column',
				'code'  =>  $ol.'[four_fifths first]'.$nl.__('Add Content Here', 'swt').$nl.'[/four_fifths]'.$cl,					
			),										
			'separator' => array(
				'title'      => __('Separator / Whitespace', 'swt'),
				'code'  =>  $ol.'[separator]'.$cl,					
				'attributes' => array(
					'spacer' => array(
						'name'    => 'size',
						'type'    => 'textbox',
						'label'   => __('Separator Size', 'swt'),
						'default' => '0px'
					),								
				),								
			),			
		)
	),

	'Content Elements' => array(
		'elements'=> array(
		
			'help_bar' => array(
				'title'      => __('Help Bar', 'swt'),
				'code'  =>  $ol.'[help_bar]'.$nl.__('Add Steps Here (up to 3)', 'swt').$nl.'[/help_bar]'.$cl,					
				'attributes' => array(
					'help_bar_title' => array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('Help Bar Title', 'swt'),
					),								
				),								
			),
			
			'help_bar_steps' => array(
				'title'      => __('Help Bar Step', 'swt'),
				'code'  	 =>  $ol.'[step]'.$cl,					
				'attributes' => array(
					'help_bar_step' => array(
						'name'    => 'number',
						'type'    => 'textbox',
						'label'   => __('Step Number', 'swt'),
						'default' => '01'
					),					
					'help_bar_title' => array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('Step Title', 'swt'),
					),	
					'help_bar_link' => array(
						'name'    => 'link',
						'type'    => 'textbox',
						'label'   => __('Step Link (Optional)', 'swt'),
					),						
				),
			),			
		
			'iconbox' => array(
				'title'      => __('Iconbox', 'swt'),
				'code'  =>  $ol.'[iconbox]'.$nl.__('Add Content Here', 'swt').$nl.'[/iconbox]'.$cl,					
				'attributes' => array(
					'iconbox_mode' => array(
						'name'  => 'mode',
						'type'  => 'select',
						'label' => __('Select', 'swt'),
						'items' => array(
							array(
								'value' => 'default',
								'label' => 'Default'
							),
							array(
								'value' => 'centered',
								'label' => 'Centered'
							),
							array(
								'value' => 'centered_circled',
								'label' => 'Centered Circled'
							),
						),
						'default' => array('{{first}}')
					),
					'iconbox_image' => array(
						'name'    => 'image',
						'type'    => 'upload',
						'label'   => __('Image', 'swt'),
					),
					'iconbox_icon' => array(
						'name'    => 'icon',
						'type'    => 'fontawesome',
						'label'   => __('Icon', 'swt'),
					),
					'iconbox_icon_color_custom' => array(
						'name'    => 'icon_color',
						'type'    => 'color',
						'label'   => __('Icon Color', 'swt'),
						'format'  => 'hex',
					),
					'iconbox_title' => array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('Title', 'swt'),
					),
				),
			),
			
			'icon_list' => array(
				'title'      => __('Icon List', 'swt'),
				'code'       => $ol.'[icon_list]'.$nl.'Put "icon_list_item" here'.$nl.'[/icon_list]'.$cl,
				'attributes' => array( 
					'size' => array(
						'name'    => 'size',
						'type'    => 'radiobutton',
						'label'   => __('List Size', 'swt'),
						'items' => array(
							array(
								'value' => 'bigger',
								'label' => __( 'Bigger', 'swt' ),
							),
							array(
								'value' => 'smaller',
								'label' => __( 'Smaller', 'swt' ),
							),
						), 'default' => array('{{first}}'),
					),					
					'name' => array(
						'name'    => 'position',
						'type'    => 'radiobutton',
						'label'   => __('Icon Position', 'swt'),
						'items' => array(
							array(
								'value' => 'left',
								'label' => __( 'Left', 'swt' ),
							),
							array(
								'value' => 'right',
								'label' => __( 'Right', 'swt' ),
							),
						), 'default' => array('{{first}}'),
					),					
				),
			),			
			'icon_list_item' => array(
				'title'      => __('Icon List Item', 'swt'),
				'code'       => $ol.'[icon_list_item]'.$nl .'Your content here'. $nl.'[/icon_list_item]'.$cl,
				'attributes' => array(				
					'name' => array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('List Title', 'swt'),
						'default' => '',
					),
					'iconlist_title_color' => array(
						'name'  => 'title_color',
						'type'  => 'color',
						'label' => __('Title Color', 'swt'),
					),	
					'iconlist_text_color' => array(
						'name'  => 'text_color',
						'type'  => 'color',
						'label' => __('Text Color', 'swt'),
					),						
					'iconlist_icon' => array(
						'name'    => 'icon',
						'type'    => 'fontawesome',
						'label'   => __('Icon', 'swt'),
					),	
					'iconlist_size' => array(
						'name'    => 'size',
						'type'    => 'textbox',
						'default'    => '45px',
						'label'   => __('Icon Size', 'swt'),
					),						
					'iconlist_color' => array(
						'name'  => 'color',
						'type'  => 'color',
						'label' => __('Icon Color', 'swt'),
					),						
					'iconlist_style' => array(
						'name'  => 'circled',
						'type'  => 'toggle',
						'label' => __('Circled?', 'swt'),
						'default' => 1,
					),	
					'iconlist_background' => array(
						'name'  => 'circle_bg',
						'type'  => 'color',
						'label' => __('Circle Background', 'swt')
					),					
				),
				
			),
		
			'pricing_table' => array(
				'title'      => __('Pricing Table', 'swt'),
				'code'       => $ol.'[pricing_table]'.$nl.'Add pricing columns here.'.$nl.'[/pricing_table]'.$cl
			),

			'pricing_column' => array(
				'title'      => __('Pricing Column', 'swt'),
				'code'       => $ol.'[pricing_column]'.$nl.'<ul><li>Item 1</li><li>Item 2</li></ul>'.$nl.'[/pricing_column]',
				'attributes' => array(
				
					'name' => array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('Title', 'swt'),
						'default' => 'Package Name',
					),
					'currency' => array(
						'name'    => 'currency',
						'type'    => 'textbox',
						'label'   => __('Currency', 'swt'),
						'default' => '$',
					),
					'nominal' => array(
						'name'    => 'nominal',
						'type'    => 'textbox',
						'label'   => __('Nominal', 'swt'),
						'default' => 19,
					),
					'period' => array(
						'name'    => 'period',
						'type'    => 'textbox',
						'label'   => __('Period', 'swt'),
						'default' => 'per month',
					),
					'color_scheme' => array(
						'name'  => 'color_scheme',
						'type'  => 'select',
						'label' => __('Color Scheme', 'swt'),
						'items' => array(
							array(
								'value' => 'color_1',
								'label' => 'Color 1'
							),
							array(
								'value' => 'color_2',
								'label' => 'Color 2'
							),
							array(
								'value' => 'color_3',
								'label' => 'Color 3'
							),
						),
						'default' => array('{{first}}')
					),									
					'table_background' => array(
						'name'    => 'table_bg',
						'type'    => 'color',
						'label'   => __('Table Background', 'swt'),
						'format'  => 'rgba',
					),					
					'table_color' => array(
						'name'    => 'table_color',
						'type'    => 'color',
						'label'   => __('Text Color', 'swt'),
						'format'  => 'rgba',
					),										
					'action_button' => array(
						'name'    => 'action_button',
						'type'    => 'toggle',
						'label'   => __('Action Button', 'swt'),
						'default' => 1,
					),
					'action_url' => array(
						'name'    => 'button_url',
						'type'    => 'textbox',
						'label'   => __('Action URL', 'swt'),
						'default' => '#',
					),
					'action_text' => array(
						'name'    => 'button_text',
						'type'    => 'textbox',
						'label'   => __('Action Text', 'swt'),
						'default' => 'Buy Now',
					),
					'action_button_background' => array(
						'name'    => 'background',
						'type'    => 'color',
						'label'   => __('Button Background', 'swt'),
						'format'  => 'hex',
					),
					'action_button_color' => array(
						'name'    => 'color',
						'type'    => 'color',
						'label'   => __('Text Color', 'swt'),
						'format'  => 'hex',
					),
					'featured' => array(
						'name'    => 'featured',
						'type'    => 'toggle',
						'label'   => __('Featured?', 'swt'),
						'default' => 0,
					),
					'featured_text' => array(
						'name'    => 'featured_text',
						'type'    => 'textbox',
						'label'   => __('Featured Text', 'swt'),
					),
				),
			),

			'team_members' => array(
				'title'      => __('Team Members', 'swt'),
				'code'       => $ol.'[team]'.$nl.'Add team members here'.$nl.'[/team]'. $cl,
				'attributes' => array(
					'team_columns' => array(
						'name'  => 'cols',
						'type'  => 'select',
						'label' => __('How many team members to display per row?', 'swt'),
						'items' => array(
							array(
								'value' => 1,
								'label' => __( '1 Column', 'swt' )
							),
							array(
								'value' => 2,
								'label' => __( '2 Columns', 'swt' )
							),
							array(
								'value' => 3,
								'label' => __( '3 Columns', 'swt' )
							),
							array(
								'value' => 4,
								'label' => __( '4 Columns', 'swt' )
							),
							array(
								'value' => 5,
								'label' => __( '5 Columns', 'swt' )
							),
							array(
								'value' => 6,
								'label' => __( '6 Columns', 'swt' )
							),
						), 'default' => array('3'),
					),				
				),
			),			
			
			'team_member' => array(
				'title'      => __('Team Member', 'swt'),
				'code'       => $ol.'[member]'. $cl,
				'attributes' => array(
						 
					'name' => array(
						'name'    => 'name',
						'type'    => 'textbox',
						'label'   => __('Team Member', 'swt'),
						'default' => 'John Doe'
					),	
					'position' => array(
						'name'    => 'position',
						'type'    => 'textbox',
						'label'   => __('Job Position', 'swt'),
						'default' => ''
					),						
					'image' => array(
						'name'    => 'image',
						'type'    => 'upload',
						'label'   => __('Image', 'swt'),
						'default' => ''
					),			
					'twitter' => array(
						'name'    => 'twitter',
						'type'    => 'textbox',
						'label'   => __('Twitter URL', 'swt'),
					),						
					'facebook' => array(
						'name'    => 'facebook',
						'type'    => 'textbox',
						'label'   => __('Facebook URL', 'swt'),
					),						
					'linkedin' => array(
						'name'    => 'linkedin',
						'type'    => 'textbox',
						'label'   => __('Linkedin URL', 'swt'),
					),						
					
				),				
			),				
			
			'blog' => array(
				'title'      => __('Blog', 'swt'),
				'code'       => $ol.'[blog]'.$cl,
				'attributes' => array(
				
					'blog_number' => array(
						'name'    => 'number',
						'type'    => 'textbox',
						'label'   => __('Number Of Posts', 'swt'),
						'default' => 4,
					),	
					
					'blog_sticky' => array(
						'name'    => 'ignore_sticky',
						'type'    => 'toggle',
						'label'   => __('Ignore Sticky?', 'swt'),
						'default' => 0,
					),		
	
				),
			),
			
			'back_to_top' => array(
				'title'      => __('Back To Top Button', 'swt'),
				'code'       => $ol.'[back_to_top]'.$cl
			),			

			'progress_bar' => array(
				'title'      => __('Progress Bar', 'swt'),
				'code'       => $ol.'[progress_bar]'.$cl,
				'attributes' => array(
				
					'progress_bar_title' => array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('Progress Bar Title', 'swt'),
						'default' => __( 'Skill or Task', 'swt' )
					),	
					'progress_bar_percent' => array(
						'name'    => 'percent',
						'type'    => 'textbox',
						'label'   => __('Progress in %', 'swt'),
						'default' => '100%'
					),						
						
				),
			), 

			'call_to_action' => array(
				'title'      => __('Call to Action', 'swt'),
				'code'       => $ol.'[call_to_action]'.$cl,
				'attributes' => array(
				
					'call_to_title' => array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('Call to Action Title', 'swt'),
					),	
					'title_color' => array(
						'name'    => 'title_color',
						'type'    => 'color',
						'format'  => 'hex',
						'label'   => __('Title Color', 'swt'),
					),					
					'call_to_text' => array(
						'name'    => 'text',
						'type'    => 'textbox',
						'label'   => __('Call to Action Text', 'swt'),
					),						
					'text_color' => array(
						'name'    => 'text_color',
						'type'    => 'color',
						'format'  => 'hex',
						'label'   => __('Text', 'swt'),
					),					
				),
			), 	

			'cf_list' => array(
				'title'      => __('Contact Form 7', 'swt'),
				'code'       => $ol.'[cf7]'.$cl,
				'attributes' => swt_cf_array()
			), 				
			
		),
	), 

	'Media Elements' => array(
		'elements'=> array(
			'slider' => array(
				'title'      => __('Slider', 'swt'),
				'code'       => $ol.'[slider]'.$nl.'Add slides here'.$nl.'[/slider]'. $cl,
				'attributes' => array(
						 
					'slider_auto' => array(
						'name'    => 'auto',
						'type'    => 'toggle',
						'label'   => __('Auto slide', 'swt'),
						'default' => 1
					),	
					'slider_pause' => array(
						'name'    => 'pause',
						'type'    => 'textbox',
						'label'   => __('Time between slides in milliseconds', 'swt'),
						'default' => 4000,
					),	
					'slider_arrows' => array(
						'name'    => 'arrows',
						'type'    => 'toggle',
						'label'   => __('Show Arrows?', 'swt'),
						'default' => 1,
					),	
					'slider_bullets' => array(
						'name'    => 'bullets',
						'type'    => 'toggle',
						'label'   => __('Show Bulleted Pagination?', 'swt'),
						'default' => 1,
					),						
				),				
			),			
			
			'slides' => array(
				'title'      => __('Slide', 'swt'),
				'code'       => $ol.'[slide]'.$cl,
				'attributes' => array(
				
					'slider_note' => array(
						'name'    => 'auto',
						'type'    => 'notebox',
						'status'  => 'info',
						'label'   => __('You need to add slides inside [slider][/slider] shortcode.', 'swt'),
						'default' => 1
					),					
				
					'slide_img' => array(
						'name'    => 'src',
						'type'    => 'upload',
						'label'   => __('Upload Image', 'swt'),
					),	
					'slide_url' => array(
						'name'    => 'link',
						'type'    => 'textbox',
						'label'   => __('Image Link', 'swt'),
					),	
					'slider_note2' => array(
						'name'    => 'auto',
						'type'    => 'notebox',
						'status'  => 'info',
						'label'   => __('Extra field will appear above slide title (can be use to emphasize something like promotion etc).', 'swt'),
						'default' => 1
					),							
					'slide_ft_text' => array(
						'name'    => 'field',
						'type'    => 'textbox',
						'label'   => __('Extra Field', 'swt'),
					),											
					'slide_ft_link' => array(
						'name'    => 'field_link',
						'type'    => 'textbox',
						'label'   => __('Field Link', 'swt'),
					),										
					'slide_title' => array(
						'name'    => 'title',
						'type'    => 'textbox',
						'label'   => __('Slide Title', 'swt'),
					),						
					'slide_text' => array(
						'name'    => 'text',
						'type'    => 'textarea',
						'label'   => __('Slide Text', 'swt'),
					),	
					'slide_opt_text' => array(
						'name'    => 'more',
						'type'    => 'textbox',
						'label'   => __('Read More Text', 'swt'),
					),											
					'slide_opt_link' => array(
						'name'    => 'more_link',
						'type'    => 'textbox',
						'label'   => __('Read More Link', 'swt'),
					),						
				),
			), 

			'portfolio' => array(
				'title'      => __('Portfolio', 'swt'),
				'code'       => $ol.'[portfolio]'. $cl,
				'attributes' => swt_shortcode_portfolio()
			),	
			
			'clients' => array(
				'title'      => __('Clients', 'swt'),
				'code'       => $ol.'[clients]'.$nl.'Add client logos / images here (up to 6)'.$nl.'[/clients]'. $cl,
				'attributes' => array(
				
					'clients_mode' => array(
						'name'  => 'mode',
						'type'  => 'radiobutton',
						'label' => __('Mode', 'swt'),
						'items' => array(
							array(
								'value' => 'slider',
								'label' => 'Slider'
							),
							array(
								'value' => 'grid',
								'label' => 'Grid'
							),
						),
						'default' => array('{{first}}')						
					),				
				
					'clients_columns' => array(
						'name'  => 'client_columns',
						'type'  => 'select',
						'label' => __('How many columns should be displayed in slider or grid?', 'swt'),
						'items' => array(
							array(
								'value' => 1,
								'label' => '1 Column'
							),
							array(
								'value' => 2,
								'label' => '2 Columns'
							),
							array(
								'value' => 3,
								'label' => '3 Columns'
							),
							array(
								'value' => 4,
								'label' => '4 Columns'
							),
							array(
								'value' => 5,
								'label' => '5 Columns'
							),
							array(
								'value' => 6,
								'label' => '6 Columns'
							),
						), 'default' => array('3'),
					),				
				
					'client_slide_auto' => array(
						'name'    => 'auto',
						'type'    => 'toggle',
						'label'   => __('Auto slide', 'swt'),
						'default' => 1
					),	
					'client_slide_pause' => array(
						'name'    => 'pause',
						'type'    => 'textbox',
						'label'   => __('Time between slides in milliseconds', 'swt'),
						'default' => 4000,
					),						
					'client_slide_move' => array(
						'name'    => 'move',
						'type'    => 'textbox',
						'label'   => __('Number of slides at once', 'swt'),
						'default' => 1
					),	
					
				),				
			),			
			
			'client_logos' => array(
				'title'      => __('Client Logo / Image', 'swt'),
				'code'       => $ol.'[client]'.$cl,
				'attributes' => array(
				
					'client_logo' => array(
						'name'    => 'src',
						'type'    => 'upload',
						'label'   => __('Image Upload', 'swt'),
					),	
					'client_url' => array(
						'name'    => 'link',
						'type'    => 'textbox',
						'label'   => __('Client URL', 'swt'),
					),						
						
				),
			), 
						
			
			'animation' => array(
				'title'      => __('Animation', 'swt'),
				'code'  =>  $ol.'[animation]'.$nl.__('Add Content Here', 'swt').$nl.'[/animation]'.$cl,					
				'attributes' => array(	

				'animations' => array( 
						'name'  => 'name',
						'type'  => 'select',
						'label' => __('Select Animation', 'swt'),
						'items' => swt_animation_list(),
						'default' => array('{{first}}')
					),	

					'animation_duration' => array(
						'name'    => 'duration',
						'type'    => 'textbox',
						'label'   => __('Animation Duration in Milliseconds', 'swt'),
						'default' => 700
					),

					'animation_delay' => array(
						'name'    => 'delay',
						'type'    => 'textbox',
						'label'   => __('Delay in seconds before animation starts', 'swt'),
						'default' => 1
					),				
					
				),								
			),			
						
		),
	),
);

/**
 * EOF
 */