<?php 

/* Add shortcodes */
add_action( 'init', 'swt_register_shortcodes', 5 );

/**
* Registers shortcodes
* @since 1.0
*/
function swt_register_shortcodes() {

	add_shortcode( 'section', 'swt_section_shortcode' );	
	add_shortcode( 'separator', 'swt_separator' );	
	add_shortcode( 'pricing_table', 'swt_table_shortcode' );	
	add_shortcode( 'pricing_column', 'swt_table_column_shortcode' );	
	add_shortcode( 'iconbox', 'swt_iconbox' );	
	add_shortcode( 'icon_list', 'swt_icon_list' );	
	add_shortcode( 'icon_list_item', 'swt_icon_list_item' );	
	add_shortcode( 'blog', 'swt_blog_posts' );	
	add_shortcode( 'help_bar', 'swt_help_bar' );	
	add_shortcode( 'step', 'swt_help_bar_step' );	
	add_shortcode( 'clients', 'swt_clients' );	
	add_shortcode( 'client', 'swt_client_logo' );	
	add_shortcode( 'back_to_top', 'swt_back_to_top' );	
	add_shortcode( 'progress_bar', 'swt_progress_bar' );	
	add_shortcode( 'call_to_action', 'swt_call_to_action' );	
	add_shortcode( 'cf7', 'swt_cf7' );	
	add_shortcode( 'slider', 'swt_slider' );	
	add_shortcode( 'slide', 'swt_slide' );	
	add_shortcode( 'team', 'swt_team' );	
	add_shortcode( 'member', 'swt_team_member' );	
	add_shortcode( 'portfolio', 'swt_portfolio' );	
	add_shortcode( 'animation', 'swt_animation' );	
	
	$columns = array(
		'one_full',
		'one_half',
		'one_third',
		'one_fourth',
		'one_fifth',
		'two_thirds',
		'three_fourths',
		'two_fifths',
		'three_fifths',
		'four_fifths',
	);
	
	foreach( $columns as $column ) {
		add_shortcode( $column, 'swt_column_shortcode' );
	}	
}

/* Fix empty paragraphs in shortcodes */
add_filter( 'the_content', 'shortcode_empty_paragraph_fix' );

/* 
* Removes empty <p></p> tags
*
* @since 1.0
*/
function shortcode_empty_paragraph_fix( $content ) {
	$array = array (
	'<p>[' => '[',
	']</p>' => ']',
	']<br />' => ']'
	);
	 
	$content = strtr($content, $array);
 
	return $content;
}

/* Creates section */
function swt_section_shortcode( $atts, $content = null ) {

    extract( shortcode_atts( 
		array(
			'title'   						=> '',
			'title_color'   				=> '',
			'background_color'   			=> '',
			'background_image_url'  		=> '',
			'background_image_repeat'  		=> 'no-repeat',
			'background_image_attachment' 	=> 'scroll',
			'background_image_position' 	=> 'top left',
			'height' 	 					=> 'none', // none (content height), 25, 50, 75, 100%
			'padding' 	 					=> 'default', // large (120px), default(70px), small(40px), no padding			
			'center' 						=> 'false',
			'color_scheme' 					=> 'color_1'
		),
		$atts ) );
	
	$title_style = swt_inline_styles( array( 'color' => $title_color ) );
	
	if ( !empty( $title ) )
		$title = "<h3 class=\"loop-title {$color_scheme}\"{$title_style}>{$title}</h3>";
	
	$classes = "class=\"swt-section full-width-{$center} height-{$height} padding-{$padding}\"";
	
	$inline_style = '';
    
	if ( ! empty( $background_color ) )
		$inline_style .= "background-color: {$background_color};";
	
	if ( ! empty( $background_image_url ) ) {
		$inline_style .= " background-image: url('{$background_image_url}');";
		$inline_style .= " background-repeat: {$background_image_repeat};";
		$inline_style .= " background-attachment: {$background_image_attachment};";
		$inline_style .= " background-positon: {$background_image_position};";
	}
	
	if ( $inline_style ) 
		$inline_style = "style=\"{$inline_style}\"";
	
	if ( $center == 'true' )	
		$html  = "<div {$classes} {$inline_style}><div class=\"wrap\">{$title}". do_shortcode( $content )."</div></div>";		
	else 
		$html  = "<div {$classes} {$inline_style}>{$title}". do_shortcode( $content ) ."</div>";
			
	return $html;
}

function swt_separator( $atts ) {
	$height = !empty( $atts['size'] ) ? intval( $atts['size'] ) : 0;
	return '<div style="height: '. $height .'px"></div>';
}

/* Creates columns */
function swt_column_shortcode( $atts, $content = null, $tag ) {
	
	$class = '';
	
	$type = gettype( $atts );
	
	if ( $type == 'array' ) {		
		$class = ' first';
	}
	
    $output = '<div class="swt-columns ' . $tag . $class . '">' . do_shortcode( $content ) . '</div>';
    return $output;
}

function swt_table_shortcode( $atts, $content=null ) {
	$col_number = substr_count( $content, '[pricing_column' );	
	return '<div class="wrap pricing-cols-'.$col_number.'">'. do_shortcode( $content ) .'</div>';
}

function swt_table_column_shortcode( $atts, $content=null ) {
 
	extract( shortcode_atts( 
		array(
			'title' 		=> 'Package Name',
			'currency' 		=> '$',
			'nominal' 		=> 19,
			'period' 		=> 'per month',
			'color_scheme' 	=> 'color_1',
			'table_bg' 		=> '',
			'table_color' 	=> '',
			'action_button' => 'true',
			'button_url' 	=> '#',
			'button_text' 	=> 'Buy Now',
			'background' 	=> '',
			'color'			=> '',
			'featured' 		=> 'false',
			'featured_text' => ''
	), $atts ) );
		
	
  	$color_scheme = " {$color_scheme}"; 			
	
	$table_styles = array( 'background' => $table_bg, 'color' => $table_color );
	$inline_style = swt_inline_styles( $table_styles );
	
	if ( $inline_style ) {
		$color_scheme = '';
	}
	
	$button_colors = array( 'background' => $background, 'color' => $color );
	$button_inline_style = swt_inline_styles( $button_colors );
	
	$html  = '';
	$html .= '<div class="pricing-column'.$color_scheme.'"'.$inline_style.'>';
	if ( $featured == 'true' && ! empty( $featured_text ) )
		$html .= '<div class="pricing-column-featured"><span class="pricing-column-featured-text"'.$button_inline_style.'>'. $featured_text .'</span></div>';
	$html .= '<div class="pricing-column-title">'. $title .'</div>';
	$html .= '<div class="pricing-column-price">';
	$html .= '<span class="pricing-column-price-currency">'. $currency .'</span>';
	$html .= '<span class="pricing-column-price-nominal">'. $nominal .'</span>';
	$html .= '<span class="pricing-column-price-period">'. $period .'</span>';
	$html .= '</div>';	
	$html .= do_shortcode( $content );
	if ( $action_button == 'true' )
		$html .= '<div class="pricing-column-action"><a '.$button_inline_style.' class="table-button" href="'. $button_url .'">'. $button_text .'</a></div>';
	$html .= '</div>';
	
	return $html;
}

function swt_iconbox( $atts, $content = null ) {
	
	extract( shortcode_atts( 
		array(
			'mode' 			=> 'default',
			'image' 		=> '',
			'icon' 			=> '',
			'icon_color' 	=> '',
			'title' 		=> ''
			), 
		$atts ) 
	);
		
	$iconbox_icon = !empty( $image ) ? '<img src="'. $image .'" alt="'.$title.'" />' : '';	

	$html  = '<div class="iconbox iconbox-'.$mode.'">';		
	
	if ( !$iconbox_icon ) 
		$iconbox_icon = !empty( $icon ) ? '<i class="fa '.$icon.'" '. swt_inline_styles( array( 'color' => $icon_color ) ).'></i>' : '';	
		
	$html .= '<div class="iconbox-icon">'.$iconbox_icon.'</div>';

	if ( $title ) 
		$html .= '<div class="iconbox-title"><h4>'.$title.'</h4></div>';
	
	$html .= '<div class="iconbox-content">'.do_shortcode( $content ).'</div>';
	$html .= '</div>';	
	
	return $html;
	
}

function swt_icon_list( $atts, $content = null ) {
	
	extract( shortcode_atts( 
		array( 
			'position' 	=> 'left',
			'size' 		=> 'bigger',
		), $atts )
	);
		
	return '<ul class="icon-list icons-'. $position .' '. $size .'-list">'. do_shortcode( $content ) .'</ul>';
	
}

function swt_icon_list_item( $atts, $content = null ) {
	
	extract( shortcode_atts( 
		array( 
			'title' 		=> '',
			'title_color' 	=> '',
			'text_color' 	=> '',
			'icon'  		=> '',
			'size'  		=> '',
			'color' 		=> '',
			'circled' 		=> 'true',
			'circle_bg' 	=> ''			
		), $atts )
	);
	
	
	$inline_style = '';
	$icon_class = '';
	
	if ( !empty( $title ) ) {
		$title_color = swt_inline_styles( array( 'color' => $title_color ) );				
		$title = '<h4 class="icon-list-item-title"'.$title_color.'>'. $title .'</h4>';
	}

	$text_color = swt_inline_styles( array( 'color' => $text_color ) );		
	
	if ( !empty( $size ) )
		$inline_style .= "font-size: {$size}; ";
		
	if ( !empty( $color ) )
		$inline_style .= "color: {$color};";
		
	if ( $circled == 'true' && !empty( $circle_bg ) ) 
		$inline_style .= "background: {$circle_bg};";
		
	if ( $inline_style )
		$inline_style = 'style="'. $inline_style .'"';
	
	if ( $circled == 'false' )
		$icon_class = ' no-bg';
		
	
	if ( !empty( $icon ) )
		$icon = '<i '.$inline_style.' class="fa '.$icon. $icon_class .'"></i>';
		
	return "<li>{$icon}{$title}<div class=\"icon-list-item-text\"{$text_color}>{$content}</div></li>";
		 	
}

/* Displays posts */
function swt_blog_posts( $atts ) {
	
	extract( shortcode_atts( 
		array( 
			'number' 		=> 4,
			'ignore_sticky' => 'false'
			), 
		$atts ) 
	);
	
	$sticky = $ignore_sticky == 'true' ? true : false;
	
	// WP_Query arguments
	$args = array (
		'posts_per_page'         => $number,
		'ignore_sticky_posts'    => $sticky,
	);
		
	$args = new WP_Query( $args );
	
	$html = '';
	
	if ( $args->have_posts() ) {
		while ( $args->have_posts() ) : $args->the_post();
		
		static $count = 0;
		$count++;
		
		if ( $count % 2 != 0 )
			$position = 'left one_half first';
		else
			$position = 'right one_half';
		
		$classes = get_post_class();
		$classes[] = 'in-shortcode '. $position;
		$classes = implode( " ", $classes );
		
		$html .= '<article itemprop="blogPost" itemtype="http://schema.org/BlogPosting" itemscope="itemscope" class="'. $classes .'" id="post-'.get_the_ID().'">';
		
		if ( has_post_thumbnail() ) :
		
			$img = get_the_image( array( 'echo'=> false, 'format' => 'array', 'size' => 'swt-shortcode-blog', 'order' => array( 'featured', 'attachment' ) ) );		
						
			$html .= '<div class="date-and-type">';
			$html .= '<time '. hybrid_get_attr( 'entry-published' ) .'>'. sprintf( '<span>%s</span> %s', get_the_date( 'd' ), get_the_date( 'M' ) ) .'</time>';
			$html .= '</div>';
			
			$html .= '<figure class="img-wrap">';
			$html .= '<a class="img-hyperlink" href="'. get_permalink() .'" title="'. get_the_title() .'">';
			$html .= '<img src="'. esc_url( $img['src'] ) .'" alt="'. esc_attr( $img['alt'] ) .'" />';
			$html .= '<span class="img-overlay"><i class="fa fa-share"></i></span>';
			$html .= '</a>';
			$html .= '</figure>';
			
		endif;
		
		$html .= '<header class="entry-header in-shortcode">';
		$html .= '<h2 '. hybrid_get_attr( 'entry-title' ) .'><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">'. get_the_title() .'</a></h2>';
		$html .= '</header>';
		$html .= '<div '. hybrid_get_attr( "entry-summary" ) .'>';
		$html .= substr( get_the_excerpt(), 0, 180 );
		$html .= '</div>';
		$html .= '<footer class="entry-footer">';
		$html .= '<a class="more-link" href="'. get_permalink() .'">'. __( 'Read More &rarr;', 'swt' ) .'</a>';
		$html .= '</footer>';
		$html .= '</article>';
			
						
 		endwhile;
	} else {
		$html .= __( 'No posts yet', 'swt' );
	}

	// Restore original Post Data
	wp_reset_postdata();
	
	return $html;
}

/* Creates help bar  */
function swt_help_bar( $atts, $content = null ) {
	
	$title = $atts['title'];	
	
	$step_count = substr_count( $content, '[step' ) + 1;
			
	$html  = '<div class="swt-section help-bar clear">';
	$html .= '<div class="wrap swt-cols-'. $step_count .'">';
	
	global $help_bar_class;
	
	if ( ! empty( $title ) ) {
		
		if ( $step_count == 1 )
			$help_bar_class = 'one_full';
		elseif( $step_count == 2 )
			$help_bar_class = 'one_half';
		elseif( $step_count == 3 )
			$help_bar_class = 'one_third';
		elseif( $step_count == 4 )
			$help_bar_class = 'one_fourth';
		else 
			$help_bar_class = 'one_fifth';
					
		$html .= '<div class="help-bar-title swt-columns first '. $help_bar_class .'"><h1 class="help-title">'. $title .'</h1></div>';		
	}
		
	$html .= do_shortcode( $content );
	
	$html .= '</div>';
	$html .= '</div>';
	
	return $html;
}

/* Creates help bar steps */
function swt_help_bar_step( $atts ) {

	$number = $atts['number'];
	$title  = $atts['title'];
	$link 	= isset( $atts['link'] ) ? $atts['link'] : '';	
	
	global $help_bar_class;	
	
	$html  = '<div class="step swt-columns '. $help_bar_class .'">';
		
	$step  = '<span class="step-number">'. $number .'</span>';
	$step .= '<span class="step-title">'. $title .'</span>';

	if ( !empty( $link ) )
		$html .= '<a class="step-link" href="'. $link .'">'. $step .'</a>';		
	else 
		$html .= $step;
	
	$html .= '</div>';

	return $html;
}

function swt_clients( $atts, $content = null ) {
	
	global $client_columns;
	global $mode; 

	extract( $atts = shortcode_atts( 
		array( 
			'mode' 	=> 'slider',
			'auto'	=> 'true',
			'pause'	=> 4000,
			'move'  => 1,
			'client_columns' => 3
		), $atts )
	);
		
	if ( $mode == 'slider' ) {
	
		wp_enqueue_script( 'swt-slider' );
		
		$width = 1200 / $client_columns; 
		$auto = ( $auto == 'true' ) ? true : false;
		
		$client_params = array(
			'maxSlides' => $client_columns,
			'width' 	=> $width,
			'auto' 		=> $auto, 
			'pause' 	=> $pause,
			'move' 		=> $move
		);
		
		wp_localize_script( 'swt-custom-js', 'client', $client_params );
	
	} else {
		
	}
	
	$html = '<div class="swt-clients '. $mode .'">'. do_shortcode( $content ) .'</div>';
	
	return $html;	
}

function swt_client_logo( $atts ) {
	
	$atts = shortcode_atts( 
		array(
			'src' 	=> '',
			'link' 	=> '',
		), $atts
	);
	
	global $client_columns;
	global $mode;
 
	if ( $client_columns == 1 )
		$class = 'one_full';
	elseif( $client_columns == 2 )
		$class = 'one_half';
	elseif( $client_columns == 3 )
		$class = 'one_third';
	elseif( $client_columns == 4 )
		$class = 'one_fourth';
	elseif( $client_columns == 5 )
		$class = 'one_fifth';		
	else 
		$class = 'one_sixth';	
	
	if ( $mode == 'slider' ) 
		$class = '';
	
	$html  = '<div class="'.$class.' swt-columns no-margin">';
	
	$img = !empty( $atts['src'] ) ? '<img src="'. $atts['src'] .'" alt="" />' : '';
	
	$html .= !empty( $atts['link'] ) ? '<a href="'. $atts['link'] .'">'. $img .'</a>' : $img;
	
	$html .= '</div>';
	
	return $html;
	
}

/* Back to top button */
function swt_back_to_top( $atts ) {
	return '<a class="fa fa-caret-up" id="scroll-to-top"></a>';
}

/* Creates progress bars */
function swt_progress_bar( $atts ) {
	wp_enqueue_script( 'swt-wow-js' );	
	extract( shortcode_atts( 
		array(
		'title' 	=> '',
		'percent' 	=> ''
		), $atts )
	);
		
	
	$html  = '<div class="progress-bar">';
	
	if ( !empty( $title ) )
		$html .= '<span class="progress-bar-title">'. $title .'</span>';
			
	$html .= '<div class="progress-bar-wrap">';
	$html .= '<span class="progress-bar-popup">'. $percent .'</span>';
	$html .= '<div class="progress-bar-progress wow progressWidth" style="width: '. intval( $percent ) .'%;" data-wow-duration="1.5s" data-wow-delay="0" data-wow-offset="70"></div>';
	$html .= '</div>';
	$html .= '</div>';
	
	return $html;
}

function swt_call_to_action( $atts ) {
	
	extract( shortcode_atts( 
		array( 
			'title' => '',
			'text'  => '',
			'title_color' => '',
			'text_color' => ''
		), $atts )
	);
	
	$html = '';
	
	if ( !empty( $title ) )
		$html .= '<span class="callout-title"'. swt_inline_styles( array( 'color' => $title_color ) ) .'>'. $title .'</span>';
	
	if ( !empty( $text ) )
		$html .= '<span class="callout-text"'. swt_inline_styles( array( 'color' => $text_color ) ) .'>'. $text .'</span>';
	
	return $html;
}

/* Builds inline CSS style */
function swt_inline_styles( $atts ) {
		
	$inline_style = '';
	
	foreach( $atts as $key => $value ) {
		if ( strpos( $key, 'color' ) !== false && ! empty( $value ) ) {
			if ( ! empty( $key ) ) 
				$inline_style .= "color: {$value};"; 
		} 
		elseif ( strpos( $key, 'background' ) !== false && ! empty( $value ) ) {		
			if ( ! empty( $key ) )
				$inline_style .= "background: {$value};";
		}
	}
	
	return !empty( $inline_style ) ? ' style="'.$inline_style.'"' : '';
}


// Contact Form 7 custom default template
add_filter( 'wpcf7_default_template', 'base_wpcf7_get_default_template', 10, 2 );
 
function base_wpcf7_get_default_template( $template, $prop = 'form' ) {

	if ( 'form' == $prop ) {
	
		$template =
			'<p class="swt-columns one_half first">' . "\n" 
			.'<span class="wpcf7-span">'
			. __( 'Name:', 'swt' ) 
			.'</span>' 
			. ' [text* your-name]'. "\n" . '</p>' . "\n\n"
			
			.'<p class="swt-columns one_half">' . "\n" 
			.'<span class="wpcf7-span">'
			. __( 'Email:', 'swt' ) 
			.'</span>' 
			. ' [email* your-email]'. "\n" . '</p>' . "\n\n"

			.'<p class="swt-columns one_full">' . "\n" 
			.'<span class="wpcf7-span">'
			. __( 'Message:', 'swt' ) 
			.'</span>' 
			. ' [textarea your-message]'. "\n" . '</p>' . "\n\n"

			. '<p class="swt-columns one_full no-border">[submit "' . __( 'Send', 'swt' ) . '"]</p>';
								
	}
	
	return $template;
}

/* Displays Contact Form 7 */
function swt_cf7( $atts ) {
	extract( shortcode_atts( 
			array(
				'id' 	=> '',
				'color' => ''
			), $atts
		)
	);
	
	global $swt_cf7_color;
	$swt_cf7_color = $color;
	
	$out = '';
	if ( !empty( $id ) ) {
		add_filter( 'wpcf7_form_class_attr', 'swt_wpcf7_color_scheme' );
		$out = do_shortcode( '[contact-form-7 id="'.$id.'"]' );
	}
	
	return $out;
}

/* Sets color scheme for CF7 */ 
function swt_wpcf7_color_scheme( $class ){
	global $swt_cf7_color;
	return $class . ' '. $swt_cf7_color;
}

/* Sets up slider js and html wrapper */
function swt_slider( $atts, $content = null ) {
	
	extract( 
		shortcode_atts( array(
			'auto' 	=> 'true',
			'pause' => 4000,
			'arrows' => true,
			'bullets' => true
		), $atts )
	);
	
	$auto = ( $auto == 'true' ) ? true : false;
	$arrows = ( $arrows == 'true' ) ? true : false;
	$bullets = ( $bullets == 'true' ) ? true : false;
	
	$slider_params = array(
		'auto' 		=> $auto, 
		'pause' 	=> $pause,		
		'arrows' 	=> $arrows,		
		'bullets' 	=> $bullets,		
	);
	
	wp_localize_script( 'swt-custom-js', 'slider', $slider_params );		
	wp_enqueue_script( 'swt-slider' );
	
	$html = '<ul class="shortcode-slider">'. do_shortcode( $content ) .'</ul>';	
	return $html;
}

function swt_slide( $atts ) {

	extract( 
		shortcode_atts( array(
			'src' 			=> '',
			'link' 			=> '',
			'title' 		=> '',
			'text' 			=> '',
			'field' 		=> '',
			'field_link' 	=> '',
			'more' 			=> '',
			'more_link' 	=> ''
		), $atts )
	);
	
	$html  = '<li>';
	
	if ( !empty( $field ) ) {
		$field = '<span class="slide-field">'. $field .'</span>';		
		$field = !empty( $field_link ) ? '<a href="'. $field_link .'">'. $field .'</a>' : $field;
	}	
	
	$caption = '';
	$caption_html = '';
 		
	$title = !empty( $title ) ? $caption .= '<h4 class="slide-title">'. $title .'</h4>' : false;
	$text = !empty( $text ) ? $caption .= '<p class="slide-text">'. $text .'</p>' : false;	
	
	if ( !empty( $more ) ) {
		$more = '<span class="slide-more">'. $more .'</span>';		
		$more = !empty( $more_link ) ? '<a href="'. $more_link .'">'. $more .'</a>' : false;
		$caption .= $more;
	}
	
	
	if ( !empty( $caption ) ) {
		$caption_html  = '<div class="bx-caption">';
		$caption_html .= '<div class="wrap">';		
		$caption_html .= $field;
		$caption_html .= '<div class="slide-caption">';
		$caption_html .= $caption; 
		$caption_html .= '</div></div></div>';
	}
			
	$img = '<img src="'. $src .'" />';	
	if ( !empty( $link ) ) 
		$html .= '<a href="'.$link.'">'. $img .'</a>';
	else
		$html .= $img;	
	$html .= $caption_html;	
	$html .= '</li>';
	
	return $html;
	
}

function swt_team( $atts, $content = null ) {
	global $members_per_row, $total_members;
	$members_per_row = !empty( $atts['cols'] ) ? $atts['cols'] : 3;	
	return do_shortcode( $content );
}

function swt_team_member( $atts ) {
	global $members_per_row;
	extract( 
		shortcode_atts( array(
			'name' 			=> '',
			'position' 		=> '',
			'image' 		=> '',
			'description' 	=> '',
			'twitter' 		=> '',
			'facebook' 		=> '',
			'linkedin' 		=> ''
		), $atts )
	);	
	
	if ( $members_per_row == 1 )
		$class = 'one_full';
	elseif( $members_per_row == 2 )
		$class = 'one_half';
	elseif( $members_per_row == 3 )
		$class = 'one_third';
	elseif( $members_per_row == 4 )
		$class = 'one_fourth';
	elseif( $members_per_row == 5 )
		$class = 'one_fifth';		
	else 
		$class = 'one_sixth';	
	
	static $current; 
	$current++;
	
	if ( $current == 1 ) 
		$class .= ' first';
	
	if ( $current == $members_per_row )
		$current = 0;
	
	
	$twitter = !empty( $twitter ) ? '<a class="fa fa-twitter" href="'. $twitter. '"></a>' : '';
	$facebook = !empty( $facebook ) ? '<a class="fa fa-facebook" href="'. $facebook. '"></a>' : '';
	$linkedin = !empty( $linkedin ) ? '<a class="fa fa-linkedin" href="'. $linkedin. '"></a>' : '';	
	$profiles = $twitter . $facebook . $linkedin;
	$soc_count = substr_count( $profiles, 'href' );
	
	$html  = '<div class="team-member swt-columns '. $class .'">';		
	
	if ( !empty( $image ) )
		$html .= '<img src="'. $image .'" alt="'. $name .'" />';
	
	$html .= '<div class="team-member-content">';
	
	if ( !empty( $name ) )
		$html .= '<h4 class="team-member-name">'. $name .'</h4>';
		
	if ( !empty( $position ) )
		$html .= '<span class="team-member-position">'. $position .'</span>';
   	
	$html .= '</div>';
	
	if ( !empty( $profiles ) )
		$html .= '<div class="social-profiles profiles-'. $soc_count .'">'. $profiles .'</div>';
	
	$html .= '</div>';
	
		
	return $html;	
}

/* Add categories to transient. */
function swt_portfolio_cats() {

	$result         = array();
	$result[]       = array( 'value' => 'swt_all', 'label' => __( 'All Portfolio Items', 'swt' ) );	
	$portfolio_cats = get_terms( 'portfolio_category' );

	foreach( $portfolio_cats as $cat ) 
		$result[] = array( 'value' => $cat->term_id, 'label' => $cat->name );

	set_transient( 'swt_portfolio_cats', $result, 60 * 60 * 24 );

}

add_action( 'init', 'swt_portfolio_cats' );


function swt_portfolio( $atts ) {
	
	$number = absint( $atts['number'] );
	$cols   = absint( $atts['cols'] );
	$cats   = esc_attr( $atts['cats'] );

	$term_array = array();

	if ( $cats == 'swt_all' ) {
		$terms = get_terms( 'portfolio_category' );
		foreach( $terms as $term => $object ) 
			$term_array[] = $object->term_id;		
	} else {
		$term_array = explode( ',', $cats );
	}

	
	$number = !empty( $number ) ? $number : 1;
	$cols 	= !empty( $cols ) ? $cols : 1;
	$loop = new WP_Query(
		array(
			'post_type' => 'portfolio_project',
			'posts_per_page' => $number,
		    'tax_query' => array(
			 	'relation' => 'AND',		    	
		        array(
		            'taxonomy' => 'portfolio_category',
		            'field'    => 'term_id',
		            'terms'    => $term_array,
		        ),
		    ),			
		)
	); 
 	
		
	if ( $cols == 1 )
		$class = 'one_full';
	elseif( $cols == 2 )
		$class = 'one_half';
	elseif( $cols == 3 )
		$class = 'one_third';
	elseif( $cols == 4 )
		$class = 'one_fourth';
	elseif( $cols == 5 )
		$class = 'one_fifth';		
	else
		$class = 'one_sixth';						
	
	$html = '';	
	$counter = 0;
	
	if ( $loop->have_posts() ) : 

		while( $loop->have_posts() ) : $loop->the_post(); $counter++;
			
			$html .= '<div class="swt-portfolio-item swt-columns no-margin '. $class .'">';
			$html .= '<a class="img-hyperlink" href="'. get_permalink() .'">';
			$html .= get_the_image( array( 'echo' => false, 'size' => 'swt-shortcode-portfolio', 'order' => array( 'featured', 'attachment' ), 'link_to_post' => false ) );
			$html .= '<div class="swt-portfolio-item-info">';
			$html .= '<h4 class="swt-portfolio-item-title">'. get_the_title() .'</h4>';			
			$html .= '</div>';
			$html .= '</a>';			
			$html .= '</div>';
			
			if ( $counter % $cols == 0 )
				$html .= '<div class="clear"></div>';
			
		endwhile; 
		
	endif; 

	return $html;
}

function swt_animation( $atts, $content = null ) {
	
	extract( 
		shortcode_atts( array(
			'name'		=> 'no-animation',
			'duration'		=> 700,
			'delay' 		=> 0
		), $atts )
	);		
		
	if ( $name !== 'no-animation' ) {		
		
		wp_enqueue_script( 'swt-wow-js' );	
		wp_enqueue_style( 'swt-animate-css' );
		
		$html  = '<div class="wow '. $name .'" data-wow-duration="'.$duration.'ms" data-wow-delay="'.$delay.'s" data-wow-offset="100">';
		$html .= do_shortcode( $content );
		$html .= '</div>';
		
		return $html;
	} else {
		return $content;
	}


} 

?>