jQuery(document).ready(function() {

	/*==== RESPONSIVE PRIMARY MENU SETUP ====*/
	if ( jQuery( '#menu-primary-items' ).length ) {
		var nav = responsiveNav("#menu-primary-items", { 
			animate: true, 
			transition: 300, 
			insert: "before", 
			customToggle: "#toggle-primary-menu", 
			closeOnNavClick: false, 
			openPos: "relative", 
			navClass: "nav-collapse", 
			navActiveClass: "js-nav-active", 
			jsClass: "js" 
		}); 
	}
 
 	/* ===== FITVIDS ===== */
	jQuery( "#content" ).fitVids({ customSelector: "iframe[src*='wordpress.tv'], iframe[src*='www.dailymotion.com'], iframe[src*='blip.tv'], iframe[src*='www.viddler.com']"});	
	
	jQuery( '.wp-video' ).removeAttr('style');
	
	/*==== SEARCH IN MENU ====*/
	jQuery('#menu-primary .fa-search').toggle( function() {
		jQuery( this ).parent().addClass( 'expand' );
	}, function(){				
		jQuery( this ).parent().removeClass( 'expand' );
	}); 

    jQuery('#menu-primary .search-text').keydown(function(e){
        if (e.keyCode == 13) {
            jQuery(':submit').click();
			jQuery( this ).parent().addClass( 'expand' );			
            return false;
        }
    });	
		
	/* ==== MAILCHIMP ==== */
	jQuery('#signup').submit(function() {
		jQuery('#response').html('Adding email address...');
                var file_path = jQuery('.hidden_path').val();
		jQuery.ajax({
			url: file_path,
			data: 'ajax=true&email=' + escape(jQuery('#email').val()) + '&_mailchimp_key=' + escape(jQuery('#_mailchimp_key').val()) + '&_mailchimp_list=' + escape(jQuery('#_mailchimp_list').val()),
			success: function(msg) {
				jQuery('#response').html(msg);
			}
		});
		return false;
	});	
	
	/* ==== SCROLL TO TOP ==== */	
	jQuery( '#scroll-to-top' ).click( function() {
		jQuery( 'html, body' ).animate({ scrollTop: 0 }, 750 );
		return false;
	});
 
 	/* ==== GALLERY SLIDER ==== */	
	if ( jQuery('.gallery-slider').length ) { 
		jQuery('.gallery-slider').bxSlider({
				auto: true,
				pause: 4000,
				autoHover: true,
				mode: 'fade',
				slideWidth: 0,
				adaptiveHeight: false,
				prevText: '<i class="fa fa-angle-left"></i>',
				nextText: '<i class="fa fa-angle-right"></i>',			
				pager: false
		});	
	}
	
 	/* ==== SECTION HEIGHTS ==== */	
    vph = jQuery(window).height();
	vph_75 = vph * 0.75;
	vph_50 = vph * 0.5;
	vph_25 = vph * 0.25;
	
    jQuery('.height-100').height(vph);	
    jQuery('.height-100').height(vph_75);	
    jQuery('.height-100').height(vph_50);	
    jQuery('.height-100').height(vph_25);	
	
	/* ==== SWT CLIENTS ==== */	
	if ( typeof client !== "undefined" ) {	
		jQuery('.swt-clients.slider').bxSlider({
			mode: 'horizontal',
			autoHover: true,
			pager: false,	
			useCSS: false,			
			controls: false,
			minSlides: 2,
			maxSlides: client.maxSlides,
			slideWidth: client.width,
			slideMargin: 0,
			auto: client.auto,
			pause: client.pause,
			moveSlides: client.move
		});		
	}


	/* ==== CONTACT FORM 7 STUFF ==== */		
	if ( jQuery('.wpcf7-textarea').length ) {
		jQuery('.swt-columns .wpcf7-textarea').autosize(); // autosize contact form textarea
		jQuery( '.swt-columns .wpcf7-textarea' ).removeAttr( 'rows' ); // remove textarea heigth
		function swt_modify_parent(){
			jQuery('.wpcf7-not-valid-tip').parent().parent().addClass( 'wpcf-invalid' ); // add class to container to style easier child elements
		}
		jQuery( '.wpcf7-form-control' ).bind( "DOMSubtreeModified", swt_modify_parent ); // wait until CF7 adds invalid message,then run swt_modify_parent
	}
 	/* ==== SHORTCODE SLIDER ==== */	
	if ( jQuery('.shortcode-slider').length > 0 ) { 
 		jQuery('.shortcode-slider').bxSlider({
			auto: slider.auto,
			pause: slider.pause,		
			mode: 'horizontal',
			useCSS: false,
			autoHover: true,
			controls: slider.arrows,
			prevText: '<i class="fa fa-angle-left"></i>',
			nextText: '<i class="fa fa-angle-right"></i>',			
			pager: slider.bullets
		});	
	}	

	/* WOW Animations */
	if ( typeof WOW != 'undefined' ) {
		wow = new WOW(
		{
		  boxClass:     'wow',      // default
		  animateClass: 'animated', // default
		  offset:       0          // default
		}
		)
		wow.init();	
	}
 	
});
 