<?php 

/**
 * Adds a meta box to the post editing screen
 */
function footer_sidebar_meta_box() {
	
	$post_types = get_post_types();
 
	foreach( $post_types as $page ) {
		add_meta_box( 'footer-sidebar', __( 'Footer Sidebar', 'swt' ), 'footer_sidebar_toggle', $page, 'side', 'low' );	
 	}
 
}

add_action( 'add_meta_boxes', 'footer_sidebar_meta_box' );

/**
 * Outputs the content of the meta box
 */
function footer_sidebar_toggle( $post ) {

    wp_nonce_field( basename( __FILE__ ), 'footer_sidebar_nonce' );
    $stored_meta = get_post_meta( $post->ID );
    ?>
 
	<p>
		<label for="footer-sidebar-checkbox">
			<input type="checkbox" name="footer-sidebar-checkbox" id="footer-sidebar-checkbox" value="off" <?php if ( isset ( $stored_meta['footer-sidebar-checkbox'] ) ) checked( $stored_meta['footer-sidebar-checkbox'][0], 'off' ); ?> />
			<?php _e( 'Turn off footer sidebar?', 'swt' )?>
		</label>
 	</p>
 
    <?php
}

/**
 * Saves the custom meta input
 */
function footer_sidebar_save_settings( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'footer_sidebar_nonce' ] ) && wp_verify_nonce( $_POST[ 'footer_sidebar_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
 	// Checks for input and saves
	if( isset( $_POST[ 'footer-sidebar-checkbox' ] ) ) {
		update_post_meta( $post_id, 'footer-sidebar-checkbox', 'off' );
	} else {
		update_post_meta( $post_id, 'footer-sidebar-checkbox', '' );
	}
 
}
add_action( 'save_post', 'footer_sidebar_save_settings' );



?>