<article <?php hybrid_attr( 'post' ); ?>>
				
	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>
							
		<header class="entry-header">		
			
			<h1 <?php hybrid_attr( 'entry-title' ); ?>><?php single_post_title(); ?></h1>		

			<div class="entry-byline">				
				<?php hybrid_post_format_link(); ?> 				
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>				
				<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link', __( 'Off', 'swt' ) ); ?>			
				<?php edit_post_link(); ?>				
			</div>	
			
		</header>
		
		<div <?php hybrid_attr( 'entry-content' ); ?>>		
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->
		
		<footer class="entry-footer">
			<?php hybrid_post_terms( array( 'taxonomy' => 'category', 'text' => __( 'Posted in %s', 'swt' ) ) ); ?>			
			<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'text' => __( 'Tagged With: %s', 'swt' ), 'before' => '<br>' ) ); ?>			
		</footer><!-- .entry-footer -->		
	 	
	<?php else : ?>
	 		
		<?php if ( has_post_thumbnail() ) : ?>
		
			<?php $img = get_the_image( array( 'echo'=> false, 'format' => 'array', 'size' => 'swt-big', 'order' => array( 'featured', 'attachment' ) ) ); ?>
			
			<div class="date-and-type">
				<time <?php hybrid_attr( 'entry-published' ); ?>><?php printf( '<span>%s</span> %s', get_the_date( 'd' ), get_the_date( 'M' ) ); ?></time>	
				<span class="fa fa-music"></span>
			</div>
			
			<figure class="img-wrap">	
				<a class="img-hyperlink" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
					<img width="690" height="310" src="<?php echo esc_url( $img['src'] ); ?>" alt="<?php echo esc_attr( $img['alt'] ) ?>" />
					<span class="img-overlay"><i class="fa fa-share"></i></span>
				</a>
			</figure>
			
		<?php endif; ?>					
			
		<?php echo ( $audio = hybrid_media_grabber( array( 'type' => 'audio', 'split_media' => true ) ) ); ?>
		
		<header class="entry-header">	
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>		
		</header><!-- .entry-header -->
		
		<div class="entry-byline">				
			<?php hybrid_post_format_link(); ?> 				
			<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>				
			<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link', __( 'Off', 'swt' ) ); ?>			
			<?php edit_post_link(); ?>				
		</div>			
		
		<div <?php hybrid_attr( 'entry-summary' ); ?>>		
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
								
	<?php endif; // End single post check. ?>
	 	
</article><!-- .entry -->