<?php

/**
 * Here is the place to put your own defined function that serve as
 * datasource to field with multiple options.
 */

function vp_get_categories()
{
	$wp_cat = get_categories(array('hide_empty' => 0 ));

	$result = array();
	foreach ($wp_cat as $cat)
	{
		$result[] = array('value' => $cat->cat_ID, 'label' => $cat->name);
	}
	return $result;
}

function vp_get_users()
{
	$wp_users = VP_WP_User::get_users();

	$result = array();
	foreach ($wp_users as $user)
	{
		$result[] = array('value' => $user['id'], 'label' => $user['display_name']);
	}
	return $result;
}

function vp_get_posts()
{
	$wp_posts = get_posts(array(
		'posts_per_page' => -1,
	));

	$result = array();
	foreach ($wp_posts as $post)
	{
		$result[] = array('value' => $post->ID, 'label' => $post->post_title);
	}
	return $result;
}

function vp_get_pages()
{
	$wp_pages = get_pages();

	$result = array();
	foreach ($wp_pages as $page)
	{
		$result[] = array('value' => $page->ID, 'label' => $page->post_title);
	}
	return $result;
}

function vp_get_tags()
{
	$wp_tags = get_tags(array('hide_empty' => 0));
	$result = array();
	foreach ($wp_tags as $tag)
	{
		$result[] = array('value' => $tag->term_id, 'label' => $tag->name);
	}
	return $result;
}

function vp_get_roles()
{
	$result         = array();
	$editable_roles = VP_WP_User::get_editable_roles();

	foreach ($editable_roles as $key => $role)
	{
		$result[] = array('value' => $key, 'label' => $role['name']);
	}

	return $result;
}

function vp_get_gwf_family()
{
	$fonts = file_get_contents(dirname(__FILE__) . '/gwf.json');
	$fonts = json_decode($fonts);

	$fonts = array_keys(get_object_vars($fonts));

	foreach ($fonts as $font)
	{
		$result[] = array('value' => $font, 'label' => $font);
	}

	return $result;
}

VP_Security::instance()->whitelist_function('vp_get_gwf_weight');

function vp_get_gwf_weight($face)
{
	if(empty($face))
		return array();
	
	$fonts   = file_get_contents(dirname(__FILE__) . '/gwf.json');
	$fonts   = json_decode($fonts);
	if( !property_exists($fonts, $face) )
		return null;
	$weights = $fonts->{$face}->weights;

	foreach ($weights as $weight)
	{
		$result[] = array('value' => $weight, 'label' => $weight);
	}

	return $result;
}

VP_Security::instance()->whitelist_function('vp_get_gwf_style');

function vp_get_gwf_style($face)
{
	if(empty($face))
		return array();
	
	$fonts   = file_get_contents(dirname(__FILE__) . '/gwf.json');
	$fonts   = json_decode($fonts);
	if( !property_exists($fonts, $face) )
		return null;
	$styles = $fonts->{$face}->styles;

	foreach ($styles as $style)
	{
		$result[] = array('value' => $style, 'label' => $style);
	}

	return $result;
}

VP_Security::instance()->whitelist_function('vp_get_gwf_subset');

function vp_get_gwf_subset($face)
{
	if(empty($face))
		return array();
	
	$fonts   = file_get_contents(dirname(__FILE__) . '/gwf.json');
	$fonts   = json_decode($fonts);
	if( !property_exists($fonts, $face) )
		return null;
	$subsets = $fonts->{$face}->subsets;

	foreach ($subsets as $subset)
	{
		$result[] = array('value' => $subset, 'label' => $subset);
	}

	return $result;
}

function vp_get_social_medias() {
	$socmeds = array(
		array('value' => 'blogger', 'label' => 'Blogger'),
		array('value' => 'delicious', 'label' => 'Delicious'),
		array('value' => 'deviantart', 'label' => 'DeviantArt'),
		array('value' => 'digg', 'label' => 'Digg'),
		array('value' => 'dribbble', 'label' => 'Dribbble'),
		array('value' => 'email', 'label' => 'Email'),
		array('value' => 'facebook', 'label' => 'Facebook'),
		array('value' => 'flickr', 'label' => 'Flickr'),
		array('value' => 'forrst', 'label' => 'Forrst'),
		array('value' => 'foursquare', 'label' => 'Foursquare'),
		array('value' => 'github', 'label' => 'Github'),
		array('value' => 'googleplus', 'label' => 'Google+'),
		array('value' => 'instagram', 'label' => 'Instagram'),
		array('value' => 'lastfm', 'label' => 'Last.FM'),
		array('value' => 'linkedin', 'label' => 'LinkedIn'),
		array('value' => 'myspace', 'label' => 'MySpace'),
		array('value' => 'pinterest', 'label' => 'Pinterest'),
		array('value' => 'reddit', 'label' => 'Reddit'),
		array('value' => 'rss', 'label' => 'RSS'),
		array('value' => 'soundcloud', 'label' => 'SoundCloud'),
		array('value' => 'stumbleupon', 'label' => 'StumbleUpon'),
		array('value' => 'tumblr', 'label' => 'Tumblr'),
		array('value' => 'twitter', 'label' => 'Twitter'),
		array('value' => 'vimeo', 'label' => 'Vimeo'),
		array('value' => 'wordpress', 'label' => 'WordPress'),
		array('value' => 'yahoo', 'label' => 'Yahoo!'),
		array('value' => 'youtube', 'label' => 'Youtube'),
	);

	return $socmeds;
}

function vp_get_fontawesome_icons()
{
	// scrape list of icons from fontawesome css
	if( false === ( $icons  = get_transient( 'vp_fontawesome_icons' ) ) )
	{
		$pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s*{\s*content/';
		$subject = file_get_contents(VP_DIR . '/public/css/vendor/font-awesome.min.css');

		preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);

		$icons = array();

		foreach($matches as $match)
		{
		    $icons[] = array('value' => $match[1], 'label' => $match[1]);
		}
		set_transient( 'vp_fontawesome_icons', $icons, 60 * 60 * 24 );
	}

	return $icons;
}

VP_Security::instance()->whitelist_function('vp_dep_boolean');

function vp_dep_boolean($value)
{
	$args   = func_get_args();
	$result = true;

	foreach ($args as $val)
	{
		$result = ($result and !empty($val));
	}
	return $result;
}

function swt_cf_list() {
 
	$wp_posts = get_posts(array(
		'posts_per_page' => -1,
		'post_type' => 'wpcf7_contact_form'
	));

	$result = array();
	foreach ($wp_posts as $post)
	{
		$result[] = array('value' => $post->ID, 'label' => $post->post_title);
	}
	return $result;

}

function swt_cf_array() {
	
	$cf_array = array();
			
	if ( !function_exists( 'wpcf7' ) ) {
		
		$link = '<a target="_blank" href="'. admin_url( 'plugin-install.php?tab=search&s=contact+form+7' ) .'">'.__( 'Contact Form 7', 'swt' ) .'</a>';	
		
		$cf_message = array(
			'name'  => 'id',
			'type'  => 'notebox',
			'status' => 'warning',
			'label' => sprintf( __( 'You must install %s in order to use this shortcode!', 'swt'), $link ),
		);	
		$cf_array[] = $cf_message;
	} else { 	
		
		$cf_form = array(
			'name'  => 'id',
			'type'  => 'select',
			'label' => __('Choose Contact Form', 'swt'),
			'items' => swt_cf_list()
		);							

		$cf_array[] = $cf_form;

		$cf_color_scheme = array(
			'name'  => 'color',
			'type'  => 'select',
			'label' => __('Color Scheme', 'swt'),
			'items' => array(
				array(
					'value' => 'light',
					'label' => 'Light'
				),
				array(
					'value' => 'dark',
					'label' => 'Dark'
				),
			),
		);

		$cf_array[] = $cf_color_scheme;
	}
	
	return $cf_array;
}


function swt_shortcode_portfolio() {
	
	$ccp_portfolio = array();
			
	if ( !class_exists( 'CCP_Plugin' ) ) {
		
		$link = '<a target="_blank" href="'. admin_url( 'plugin-install.php?tab=search&s=custom+content+portfolio' ) .'">'.__( 'Custom Content Portfolio', 'swt' ) .'</a>';	
		
		$ccp_message = array(
			'name'  => 'id',
			'type'  => 'notebox',
			'status' => 'warning',
			'label' => sprintf( __( 'You must install %s plugin in order to use this shortcode!', 'swt'), $link ),
		);	
		
		$ccp_portfolio[] = $ccp_message;
		
	} else { 	
	
		$ccp_info = array(
			'name' => 'ccpinfo',
			'type'    => 'notebox',
			'status'    => 'info',
			'label'   => __('You must assign tags/categories to your portfolio items.', 'swt')
		);			 
		$ccp_cat = array(
			'name'    => 'cats',
			'type'    => 'multiselect',
			'label'   => __('Portfolio Tag/Category', 'swt'),
			'items' => swt_get_portfolio_categories()
		);		
		$ccp_items_number = array(
			'name'    => 'number',
			'type'    => 'textbox',
			'label'   => __('Number of Items to Show', 'swt')
		);
		$ccp_column_number = array(
			'name'  => 'cols',
			'type'  => 'select',
			'label' => __('How many columns to display per row?', 'swt'),
			'items' => array(
				array(
					'value' => 1,
					'label' => __( '1 Column', 'swt' )
				),
				array(
					'value' => 2,
					'label' => __( '2 Columns', 'swt' )
				),
				array(
					'value' => 3,
					'label' => __( '3 Columns', 'swt' )
				),
				array(
					'value' => 4,
					'label' => __( '4 Columns', 'swt' )
				),
				array(
					'value' => 5,
					'label' => __( '5 Columns', 'swt' )
				),
				array(
					'value' => 6,
					'label' => __( '6 Columns', 'swt' )
				),
			), 'default' => array('3'),
		);	
 
 		$ccp_portfolio[] = $ccp_info;		
 		$ccp_portfolio[] = $ccp_cat;		
 		$ccp_portfolio[] = $ccp_items_number;		
		$ccp_portfolio[] = $ccp_column_number;		
	}
	
	return $ccp_portfolio;
}
 
function swt_animation_list() {

	$animations = array(
		'bounce' => 'bounce',
		'flash' => 'flash',
		'pulse' => 'pulse',
		'rubberBand' => 'rubberBand',
		'shake' => 'shake', 
		'swing' => 'swing',
		'tada' => 'tada',
		'wobble' => 'wooble',
		'bounceIn' => 'bounceIn',
		'bounceInDown' => 'bounceInDown',
		'bounceInLeft' => 'bounceInLeft',
		'bounceInRight' => 'bounceInRight',
		'bounceInUp' => 'bounceInUp',		
		'fadeIn' => 'fadeIn',		
		'fadeInDown' => 'fadeInDown',		
		'fadeInDownBig' => 'fadeInDownBig',		
		'fadeInLeft' => 'fadeInLeft',		
		'fadeInLeftBig' => 'fadeInLeftBig',		
		'fadeInRight' => 'fadeInRight',		
		'fadeInRightBig' => 'fadeInRightBig',		
		'fadeInUp' => 'fadeInUp',		
		'fadeInUpBig' => 'fadeInUpBig',				
		'flip' => 'flip',
		'flipInX' => 'flipInX',
		'flipInY' => 'flipInY',
		'lightSpeedIn' => 'lightSpeedIn	',
		'rotateIn' => 'rotateIn',
		'rotateInDownLeft' => 'rotateInDownLeft',
		'rotateInDownRight' => 'rotateInDownRight',
		'rotateInUpLeft' => 'rotateInUpLeft',
		'rotateInUpRight' => 'rotateInUpRight',		
		'rollIn' => 'rollIn',
		'zoomIn' => 'zoomIn',
		'zoomInDown' => 'zoomInDown',
		'zoomInLeft' => 'zoomInLeft',
		'zoomInRight' => 'zoomInRight',
		'zoomInUp' => 'zoomInUp',	
	);
	
	$animation_list = array();
	foreach ($animations as $key => $value )
	{
		$animation_list[] = array('value' => $key, 'label' => $value );
	}
	return $animation_list;
	
}

function swt_get_portfolio_categories() {

	$cats = get_transient( 'swt_portfolio_cats' );

	if ( false === $cats )
		return;
	else
		return $cats;	
}


/**
 * EOF
 */