<?php

class swt_recent_comments extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 'classname' => 'swt_recent_comments', 'description' => __( 'Displays recent comments.', 'swt' ) );
		
		parent::WP_Widget( 'swt_recent_comments', __( 'SWT - Recent Comments', 'swt' ), $widget_options );
				
	}
		
	function form( $instance ) {
 	
		/* Defaults */
		$defaults = array( 
					'title' 		=> '',  
					'comments_number' 	=> 3
					);
		
		/* Merge $defaults with saved options */
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title 				= 	$instance['title'];
 		$comments_number 	= 	$instance['comments_number'];
 
 		?>
				 			 								
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>			
		
		<p>
			<label for="<?php echo $this->get_field_id( 'comments_number' ); ?>"><?php _e( 'Number of posts to show:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'comments_number' ); ?>" name="<?php echo $this->get_field_name( 'comments_number' ); ?>" value="<?php echo esc_attr( $comments_number ); ?>" />
		</p>
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
				
		$instance['title'] = strip_tags( $new_instance['title'] );
 							
		$instance['comments_number'] = ( empty( $new_instance['comments_number'] ) ? 1 : $new_instance['comments_number'] );

		
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$title 				= 	$instance['title'];
 		$comments_number 	= 	$instance['comments_number'];
 		
		echo $before_widget;
 
		if ( !empty( $title ) )
 			echo $title = $before_title . apply_filters( 'widget_title', $title ) . $after_title;
		
		global $comments, $comment;

		$args = array(
			'post_status' 	 => 'publish',
			'status'         => 'approve',
			'type'           => 'comment',
			'number'         => $comments_number				
		);	
		
		$comments = get_comments( $args );
 

 		if ( $comments ) {
		
			$output = '<ul>';

			foreach ( $comments as $comment ) {
			
				$output .= '<li class="recentcomments">';
								
				$output .= sprintf( _x( '%1$s %2$s on %3$s %4$s', 'swt' ),
						'<i class="fa fa-comments"></i>',
						'<div class="content-holder"><span class="comment-author-link">' . get_comment_author_link() . '</span>',
						'<a href="' . esc_url( get_comment_link( $comment->comment_ID ) ) . '">' . get_the_title( $comment->comment_post_ID ) . '</a>',
						'<span class="entry-time">'. strftime( '%B %d, %Y', get_comment_time( 'U' ) ) .'</span></div>'
						);
								
				$output .= '</li>';
			}
			
			$output .= '</ul>';		
			
			echo $output;
			
		} else {
			_e( 'No comments yet!', 'swt' );
		}
		
		echo $after_widget;
		
	}

}

?>