<article <?php hybrid_attr( 'post' ); ?>>
				
	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>
							
		<header class="entry-header">		
			
			<h1 <?php hybrid_attr( 'entry-title' ); ?>><?php single_post_title(); ?></h1>		

			<div class="entry-byline">				
				<?php hybrid_post_format_link(); ?> 				
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>				
				<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link', __( 'Off', 'swt' ) ); ?>			
				<?php edit_post_link(); ?>				
			</div>	
			
		</header>
		
		<div <?php hybrid_attr( 'entry-content' ); ?>>		
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->
		
		<footer class="entry-footer">
			<?php hybrid_post_terms( array( 'taxonomy' => 'category', 'text' => __( 'Posted in %s', 'swt' ) ) ); ?>			
			<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'text' => __( 'Tagged With: %s', 'swt' ), 'before' => '<br>' ) ); ?>			
		</footer><!-- .entry-footer -->		
	 	
	<?php else : ?>
	 		
		<?php echo ( $video = hybrid_media_grabber( array( 'type' => 'video', 'split_media' => true ) ) ); ?>
		
		<header class="entry-header">	
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>		
		</header><!-- .entry-header -->
		
		<div class="entry-byline">				
			<?php hybrid_post_format_link(); ?> 				
			<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>				
			<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link', __( 'Off', 'swt' ) ); ?>			
			<?php edit_post_link(); ?>				
		</div>			
	
		<div <?php hybrid_attr( 'entry-summary' ); ?>>		
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
				
	<?php endif; // End single post check. ?>
	 	
</article><!-- .entry -->