<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

		<header class="entry-header">		
			
			<h1 <?php hybrid_attr( 'entry-title' ); ?>><?php single_post_title(); ?></h1>					

		</header>

		<div <?php hybrid_attr( 'entry-content' ); ?>>			
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<footer class="entry-footer">
			<?php hybrid_post_format_link(); ?> 
			<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date('F d, Y'); ?></time>	
			<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>						
			<?php edit_post_link(); ?>			
			<?php hybrid_post_terms( array( 'taxonomy' => 'category', 'text' => __( 'Posted in %s', 'swt' ), 'before' => '<br>' ) ); ?>			
			<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'text' => __( 'Tagged With: %s', 'swt' ), 'before' => '<br>' ) ); ?>			
		</footer><!-- .entry-footer -->		

		
	<?php else : // If not viewing a single post. ?>
		
		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->
		
		<footer class="entry-footer">				
			<?php hybrid_post_format_link(); ?> 
			<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date('F d, Y'); ?></time>	
			<a class="entry-permalink" href="<?php the_permalink(); ?>" rel="bookmark" itemprop="url"><?php _e( 'Permalink', 'swt' ); ?></a>		
			<?php edit_post_link(); ?>				
		</footer>		
	
	<?php endif; // End single post check. ?>

</article><!-- .entry -->