<?php 

$tab_general = array( 
	
	array( 
		'type' => 'section',
		'title' => __('Site Title Coloring', 'swt'),
		'description' => __('If turned on, first site title letter will turn orange. You can also increase the number of letters in orange, once this option is turned on.', 'swt'),		
		'fields' => array( 
			
			array(
				'type' => 'toggle',
				'name' => 'site_title_span',
				'label' => __('Site Title Coloring', 'swt'),
				'default' => 0,
			),

			array(
				'type' => 'slider',
				'name' => 'site_title_span_letters_num',
				'label' => __('Number Of Letters In Orange?', 'swt'),
				'default' => 1,
				'dependency' => array(
					'field' => 'site_title_span',
					'function' => 'vp_dep_boolean',
				),			
				'min' => '1',
				'max' => strlen( get_bloginfo( 'name' ) ),
				'step' => '1',
				'default' => '1',								
			),		
		),
	),
	
	array( 
		'type' => 'section',
		'title' => __('Header Call To Action Button', 'swt'),
		'description' => __( 'Call to action button, located in the header of a site. Suitable for phone number, link to specific page, plain text, email or similar.', 'swt' ),
		'fields' => array( 			
			
			array(
				'type' => 'toggle',
				'name' => 'swt_header_button',
				'label' => __( "Header Button", "swt" ),
				'default' => 0,
			),	
			
			array(
				'type' => 'textbox',
				'name' => 'swt_header_button_text',
				'label' => __('Header Button Text', 'swt'),
				'dependency' => array(
					'field' => 'swt_header_button',
					'function' => 'vp_dep_boolean',
				),				
				'default' => 'Call Us: 888-234-444'	
			),		
			
			array(
				'type' => 'textbox',
				'name' => 'swt_header_button_link',
				'label' => __('Header Button Link', 'swt'),
				'default' => '',
				'dependency' => array(
					'field' => 'swt_header_button',
					'function' => 'vp_dep_boolean',
				),	
				'validation' => 'url'		
			),
		),
	),
	array( 
		'type' => 'section',
		'title' => __('Favicon', 'swt'),
		'description' => __( 'A favicon (short for Favorite icon), is also known as a shortcut icon, Web site icon, URL icon or bookmark icon, most commonly 16x16 pixels, associated with a particular Web site or Web page. Accepted formats: .ico, .png and .gif.', 'swt' ),
		'fields' => array( 
 
			array(
				'type' => 'upload',
				'name' => 'favicon',
				'label' => __('Upload Favicon', 'swt'),				
				'default' => '',
			),
			
		),
	)
);


$tab_layout = array( 
	
	array( 
		'type' => 'section',
		'title' => __('Site Layout', 'swt'),
		'fields' => array( 
		
			array(
				'type' => 'radioimage',
				'name' => 'site_layout',
				'label' => __('Default Site Layout', 'swt'),
				'items' => 
					array(
						array(
							'value' => 'layout-1c',
							'label' => __('Full Width', 'swt'),
							'img' => VP_URL.'/options/img/1cl.png',
						),
						array(
							'value' => 'layout-2c-l',
							'label' => __('Content / Sidebar', 'swt'),
							'img' => VP_URL.'/options/img/2cl.png',
						),
						array(
							'value' => 'layout-2c-r',
							'label' => __('Sidebar / Content', 'swt'),
							'img' => VP_URL.'/options/img/2cr.png',
						), 
					), 'default' => array( 'layout-2c-l' )
			),	
		),
	),
	
	array( 
		'type' => 'section',
		'title' => __('Footer Columns', 'swt'),
		'fields' => array( 
			
			array(
				'type' => 'toggle',
				'name' => 'sidebar_subsidiary',
				'label' => __( "Use Footer Sidebar?", "swt" ),
				'default' => 1,
			),		
			
			array(
				'type' => 'radioimage',
				'name' => 'sidebar_subsidiary_cols_number',
				'label' => __('Number Of Columns In Footer Sidebar?', 'swt'),
				'dependency' => array(
					'field' => 'sidebar_subsidiary',
					'function' => 'vp_dep_boolean',
				),			
				'items' => array(
					array(
					'value' => 1,
					'label' => __('One', 'swt'),
					'img' => VP_URL.'/options/img/1cl.png',			
					),
					array(
					'value' => 2,
					'label' => __('Two', 'swt'),
					'img' => VP_URL.'/options/img/2col.png',						
					),
					array(
					'value' => 3,
					'label' => __('Three', 'swt'),
					'img' => VP_URL.'/options/img/3col.png',						
					),
				),
				'default' => array( 3 ),
			),
		),
	),

);

$tab_scripts = array( 
	
	array(
		'type' => 'codeeditor',
		'name' => 'header_scripts',
		'label' => __('Header Scripts', 'swt'),
		'description' => __('Add scripts before &lt;/head&gt; tag (ie tracking code or custom Javascript).', 'swt'),
		'theme' => 'github',
	),		

	array(
		'type' => 'codeeditor',
		'name' => 'footer_scripts',
		'label' => __('Footer Scripts', 'swt'),
		'description' => __('Add scripts before &lt;/body&gt; tag (ie tracking code or custom Javascript).', 'swt'),
		'theme' => 'github',
	),
	
	array(
		'type' => 'codeeditor',
		'name' => 'custom_css',
		'label' => __('Custom CSS', 'swt'),
		'description' => __('Write your custom CSS here.', 'swt'),
		'theme' => 'github',
		'mode' => 'css',
	),		

);
 

?>