<article <?php hybrid_attr( 'post' ); ?>>

	<?php $images = get_post_gallery( get_the_ID(), false ); ?>
	
	<?php if ( !empty( $images ) ) : ?>
	
		<div class="date-and-type">
			<time <?php hybrid_attr( 'entry-published' ); ?>><?php printf( '<span>%s</span> %s', get_the_date( 'd' ), get_the_date( 'M' ) ); ?></time>	
			<span class="fa fa-files-o"></span>
		</div>
		
		<div class="slider-wrap">
		
			<ul class="gallery-slider">
				<?php				
				// Default testing gallery post format doesn't have ids set, only src
				if ( array_key_exists( 'ids', $images ) ) {				
					$images_ids = explode( ",", $images['ids'] );
				
					foreach( $images_ids as $id ) {
						$image = wp_get_attachment_image( $id, 'swt-big' );				
						echo "<li>{$image}</li>";					
					}	
					
				} else {
					foreach( $images['src'] as $img ) {
					    $img = swt_get_attachment_id_from_url( $img );
						$image = wp_get_attachment_image( $img, 'swt-big' );	
						echo "<li>{$image}</li>";
					}
				}
			 
						
				?>		
			</ul><!-- .gallery-slider -->
			
		</div><!-- .slider-wrap-->
	
	<?php endif; ?>
	
	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>
  
		<header class="entry-header">		
			
			<h1 <?php hybrid_attr( 'entry-title' ); ?>><?php single_post_title(); ?></h1>		

			<div class="entry-byline">				
				<?php hybrid_post_format_link(); ?> 				
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>				
				<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link', __( 'Off', 'swt' ) ); ?>			
				<?php edit_post_link(); ?>				
			</div>	
			
		</header>

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<footer class="entry-footer">
			<?php hybrid_post_terms( array( 'taxonomy' => 'category', 'text' => __( 'Posted in %s', 'swt' ) ) ); ?>			
			<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'text' => __( 'Tagged With: %s', 'swt' ), 'before' => '<br>' ) ); ?>			
		</footer><!-- .entry-footer -->		
 
	<?php else : // If not viewing a single post. ?>
	
		<header class="entry-header">
		
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' );?>
			
			<div class="entry-byline">				
				<?php hybrid_post_format_link(); ?> 				
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>				
				<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link', __( 'Off', 'swt' ) ); ?>			
				<?php edit_post_link(); ?>				
			</div>			
			
		</header><!-- .entry-header -->
		
		<div <?php hybrid_attr( 'entry-summary' ); ?>>
			<?php the_excerpt(); ?>			
		</div><!-- .entry-summary -->
				
	<?php endif; // End single post check. ?>

</article><!-- .entry -->