<article <?php hybrid_attr( 'post' ); portfolio_data_groups(); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

	 	<?php get_the_image( array( 'size' => 'swt-full', 'order' => array( 'featured', 'attachment' ), 'link_to_post' => false, 'before' => '<figure class="featured-full">', 'after' => '</figure>' ) ); ?>

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_title( '<h1 ' . hybrid_get_attr( 'entry-title' ) . '>', '</h1>' ); ?>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>

			<div class="portfolio-item-details">

				<?php global $post; ?>

				<?php $date = get_post_meta( $post->ID, '_date', true ); ?>

				<?php if ( ! empty( $date ) ) : ?>

					<span class="portfolio-item-date">
						<strong><?php _e( 'Date:', 'swt' ); ?></strong>
						<?php echo $date; ?>
					</span>

				<?php endif; ?>

				<?php $client = get_post_meta( $post->ID, '_client', true ); ?>

				<?php if ( ! empty( $client ) ) : ?>

					<span class="portfolio-item-date">
						<strong><?php _e( 'Client:', 'swt' ); ?></strong>
						<?php echo $client; ?>
					</span>

				<?php endif; ?>

				<?php $portfolio_item_url = get_post_meta( $post->ID, 'portfolio_item_url', true ); ?>

				<?php if ( ! empty( $portfolio_item_url ) ) : ?>

					<span class="portfolio-item-url">
						<strong><?php _e( 'URL:', 'swt' ); ?></strong>
						<a href="<?php echo $portfolio_item_url; ?>"><?php echo $portfolio_item_url; ?></a>
					</span>

				<?php endif; ?>

			</div>

		</div><!-- .entry-content -->


	<?php else : // If not viewing a single post. ?>

	 	<?php get_the_image( array( 'size' => 'swt-portfolio-fp', 'order' => array( 'featured', 'attachment' ), 'link_to_post' => true, 'before' => '<figure>', 'after' => '</figure>' ) ); ?>

	<?php endif; // End single post check. ?>

</article><!-- .entry -->