<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>
	
		<?php get_the_image( array( 'size' => 'swt-full', 'order' => array( 'featured', 'attachment' ), 'link_to_post' => false ) ); ?>				
	
		<header class="entry-header">

			<?php the_title( '<h1 ' . hybrid_get_attr( 'entry-title' ) . '>', '</h1>' ); ?>			

		</header><!-- .entry-header -->

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<?php if ( !is_page() ) : ?>
		
			<footer class="entry-footer">							
				<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date('F d, Y'); ?></time>			
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>						
	 		</footer><!-- .entry-footer -->
		
		<?php endif; ?>
					
	<?php else : // If not viewing a single post. ?>
	
		<header class="entry-header">
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>
		</header><!-- .entry-header -->
	
		<div <?php hybrid_attr( 'entry-summary' ); ?>>			
			<?php the_excerpt(''); ?>			
		</div><!-- .entry-summary -->
		
		<footer class="entry-footer">							
			<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date('F d, Y'); ?></time>			
			<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>						
 		</footer><!-- .entry-footer -->
		
	<?php endif; // End single post check. ?>

</article><!-- .entry -->