<?php
/**
 * Template Name: Portfolio
**/

get_header(); // Loads the header.php template. ?>

<ul id="portfolio-nav">
	<li><a class="active" href="#" data-group="all">All</a></li>
		<?php $terms = get_terms( 'portfolio_category' );
		foreach ( $terms as $key => $object ) {
		    echo '<li><a href="#" data-group="'. $object->name .'">'. $object->name .'</a></li>';
		}
	?>
</ul>

<main <?php hybrid_attr( 'content' ); ?>>

	<?php $loop = new WP_Query(
		array(
			'post_type'      => 'portfolio_project',
			'posts_per_page' => of_get_option( 'portfolio_number_of_items', 8 ),
		)
	); ?>

	<?php if ( $loop->have_posts() ) : ?>

		<?php while( $loop->have_posts() ) : $loop->the_post(); ?>

			<?php get_template_part( 'content/portfolio_project' ); ?>

		<?php endwhile; ?>

	<?php endif; ?>


</main><!-- #content -->

<?php get_footer(); // Loads the footer.php template. ?>