<?php

class Portfolio_Widget extends WP_Widget {

	function __construct() {

		$widget_options = array( 'classname' => 'swt_portfolio_widget', 'description' => __( 'Displays your latest portfolio items.', 'swt' ) );

		parent::__construct( 'Portfolio_Widget', __( 'SWT - Portfolio Items', 'swt' ), $widget_options );

	}


	function form( $instance ) {

		/* Defaults */
		$defaults = array(
			'number_of_items' => 1,
			'hide_on_pt' => 1
		);

		/* Merge $defaults with saved options */
		$instance = wp_parse_args( (array) $instance, $defaults );

		$number_of_items 		= 	$instance['number_of_items'];
		$hide_on_pt 		    = 	$instance['hide_on_pt'];

 		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'number_of_items' ); ?>"><?php _e( 'Number of items to show:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'number_of_items' ); ?>" name="<?php echo $this->get_field_name( 'number_of_items' ); ?>" value="<?php echo esc_attr( $number_of_items ); ?>" />
		</p>

		<p>
			<input type="checkbox" id="<?php echo $this->get_field_id( 'hide_on_pt' ); ?>" name="<?php echo $this->get_field_name( 'hide_on_pt' ); ?>" value="<?php echo esc_attr( $hide_on_pt ); ?>" <?php checked( $hide_on_pt, 1 ); ?> />
			<label for="<?php echo $this->get_field_id( 'hide_on_pt' ); ?>"><?php _e( 'Hide on portfolio page?', 'swt' ); ?></label>
		</p>

		<?php

	}

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

 		$instance['number_of_items'] 		= strip_tags( $new_instance['number_of_items'] );
 		$instance['hide_on_pt'] = ( isset( $new_instance['hide_on_pt'] ) ? 1 : 0 );


	    return $instance;
	}

	function widget( $args, $instance ) {

		extract( $args );

 		$number_of_items 		= 	$instance['number_of_items'];
 		$hide_on_pt 		    = 	$instance['hide_on_pt'];

	    if ( $hide_on_pt == 1  && is_page_template( 'templates/template-portfolio.php' ) )
	        return;

		echo $before_widget;

		$args = array(
			'post_type' => 'portfolio_project',
			'posts_per_page' => $instance['number_of_items']
		);

		$portfolio_query = new WP_Query( $args );

		if ( $portfolio_query->have_posts() ) :

			while( $portfolio_query->have_posts() ) : $portfolio_query->the_post();

				the_title( '<h3 class="portfolio-title"><a title="'. get_the_title() .'" href="'. get_the_permalink() .'">', '</a></h3>', true ); ?>

				<article class="portfolio-entry">
					<?php
					echo '<p>'. substr( get_the_excerpt(), 0, 100 ) .'</p>';
					if ( current_theme_supports( 'get-the-image' ) && has_post_thumbnail() )
						get_the_image( array( 'size' => 'swt-portfolio-widget' ) );
					?>
				</article>

			<?php endwhile;

		endif;


		echo $after_widget;
	}

}

?>