<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
 		</div><!-- .entry-content -->
		
		<footer class="entry-footer">
				<time <?php hybrid_attr( 'entry-published' ); ?>><?php the_time( 'M jS Y' ); ?></time>					
				
				<div class="entry-info right">
					<a title="<?php _e( 'Share on Facebook!', 'swt' ); ?>"  class="fa fa-facebook-square" href="http://www.facebook.com/share.php?u=<?php the_permalink(); ?>&title=<?php the_title(); ?>"></a>
					<a title="<?php _e( 'Share on Twitter!', 'swt' ); ?>" class="fa fa-twitter-square" href="https://twitter.com/home?status=<?php echo wp_get_shortlink(); ?>"></a>
				</div>
		</footer><!-- .entry-footer -->
				
		<div class="loop-nav">
			<?php previous_post_link( '<div class="prev">' . __( '%link', 'swt' ) . '</div>', 'Previous Post' ); ?>
			<?php next_post_link( '<div class="next">' . __( '%link',     'swt' ) . '</div>', 'Next Post' ); ?>
		</div><!-- .loop-nav -->

		
	<?php else : // If not viewing a single post. ?>

		
		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->
		
		<footer class="entry-footer">
				<time <?php hybrid_attr( 'entry-published' ); ?>><?php the_time( 'M jS Y' ); ?></time>					
				<a class="pmlink" href="<?php the_permalink(); ?>"><?php _e( 'Permalink', 'swt' ); ?></a>
				<div class="entry-info right">
					<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link fa fa-comments', __( 'Off', 'swt' ) ); ?>
						<a title="<?php _e( 'Share on Facebook!', 'swt' ); ?>"  class="fa fa-facebook-square" href="http://www.facebook.com/share.php?u=<?php the_permalink(); ?>&title=<?php the_title(); ?>"></a>
						<a title="<?php _e( 'Share on Twitter!', 'swt' ); ?>" class="fa fa-twitter-square" href="https://twitter.com/home?status=<?php echo wp_get_shortlink(); ?>"></a>
				</div>
 		</footer><!-- .entry-footer -->
		
	<?php endif; // End single post check. ?>

</article><!-- .entry -->