<article <?php hybrid_attr( 'post' ); ?>>

	<?php get_the_image( array( 'size' => 'stargazer-full', 'split_content' => true, 'scan_raw' => true, 'scan' => true, 'order' => array( 'scan_raw', 'scan', 'featured', 'attachment' ) ) ); ?>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>
 
		<header class="entry-header">

			<?php the_title( '<h1 ' . hybrid_get_attr( 'entry-title' ) . '>', '</h1>' ); ?>			

		</header><!-- .entry-header -->

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<?php if ( !is_page() ) : ?>
		
			<footer class="entry-footer">
					<time <?php hybrid_attr( 'entry-published' ); ?>><?php the_time( 'M jS Y' ); ?></time>					
					
					<div class="entry-info right">
						<a title="<?php _e( 'Share on Facebook!', 'swt' ); ?>"  class="fa fa-facebook-square" href="http://www.facebook.com/share.php?u=<?php the_permalink(); ?>&title=<?php the_title(); ?>"></a>
						<a title="<?php _e( 'Share on Twitter!', 'swt' ); ?>" class="fa fa-twitter-square" href="https://twitter.com/home?status=<?php echo wp_get_shortlink(); ?>"></a>
					</div>
			</footer><!-- .entry-footer -->
		
		<?php endif; ?>
 
		
		<div class="loop-nav">
			<?php previous_post_link( '<div class="prev">' . __( '%link', 'swt' ) . '</div>', 'Previous Post' ); ?>
			<?php next_post_link( '<div class="next">' . __( '%link',     'swt' ) . '</div>', 'Next Post' ); ?>
		</div><!-- .loop-nav -->

		
	<?php else : // If not viewing a single post. ?>


		<header class="entry-header">
		
			<?php 		
			the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' );?>
 
		</header><!-- .entry-header -->
		
		<div <?php hybrid_attr( 'entry-summary' ); ?>>
			<?php the_excerpt(''); ?>			
		</div><!-- .entry-summary -->
		
		<footer class="entry-footer<?php echo ( strpos( $img['class'], 'portrait' ) === false ) ? '' : ' right'; ?>">
				<time <?php hybrid_attr( 'entry-published' ); ?>><?php the_time( 'M jS Y' ); ?></time>					
				
				<div class="entry-info right">
					<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link fa fa-comments', __( 'Off', 'swt' ) ); ?>
						<a title="<?php _e( 'Share on Facebook!', 'swt' ); ?>"  class="fa fa-facebook-square" href="http://www.facebook.com/share.php?u=<?php the_permalink(); ?>&title=<?php the_title(); ?>"></a>
						<a title="<?php _e( 'Share on Twitter!', 'swt' ); ?>" class="fa fa-twitter-square" href="https://twitter.com/home?status=<?php echo wp_get_shortlink(); ?>"></a>
				</div>
 		</footer><!-- .entry-footer -->
		
	<?php endif; // End single post check. ?>

</article><!-- .entry -->