<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option( 'optionsframework' );
	$optionsframework_settings['id'] = $themename;
	update_option( 'optionsframework', $optionsframework_settings );
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'swt'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

/* set some defaults */
$theme_dir = get_bloginfo( 'template_directory' );
 
$slider_mode = array(
	'fade' => __('Fade', 'swt'),
	'horizontal' => __('Horizontal', 'swt'),
	'vertical' => __('Vertical', 'swt')
);	

$slider_auto = array(
	'true' => __('Yes', 'swt'),
	'false' => __('No', 'swt')
);	

$slider_autohover = array(
	'true' => __('Yes', 'swt'),
	'false' => __('No', 'swt')
);	
	
// If using image radio buttons, define a directory path
$imagepath =  get_template_directory_uri() . '/admin/images/';

$options = array();
 
$options[] = array( "name" => __( "Header Scripts", "swt" ),
					"desc" => __( "Add scripts before &lt;/head&gt; tag", "swt" ),
					"id" => "header_scripts",					
					"type" => "textarea",
					"std" => "");

$options[] = array( "name" => __( "Footer Scripts", "swt" ),
					"desc" => __( "Add scripts before &lt;/body&gt; tag", "swt" ),
					"id" => "footer_scripts",					
					"type" => "textarea",
					"std" => "");

$options[] = array( "name" => __( "Custom CSS", "swt" ),
					"desc" => __( "Add your own CSS", "swt" ),
					"id" => "custom_css",
					"type" => "textarea",
					"std" => "");    							

$options[] = array( "name" => __( "Upload Favicon (16x16px)", "swt" ),
					"desc" => __( "A favicon (short for Favorite icon), is also known as a shortcut icon, Web site icon, URL icon or bookmark icon, most commonly 16x16 pixels, associated with a particular Web site or Web page. For example, you can generate your 16x16px favicon <a href='http://www.favicongenerator.com/'>here</a>.", "swt" ),
					"id" => "favicon",					
					"type" => "upload",
					"std" => "");	
					
$options[] = array( "name" => __( "Logo Image", "swt" ),
					"desc" => __( "Image that will show up before the site title.", "swt" ),
					"id" => "logo",					
					"type" => "upload",
					"std" => "");						
				
	
return $options;
	
}