<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

		<header class="entry-header">

			<?php the_title( '<h1 ' . hybrid_get_attr( 'entry-title' ) . '>', '</h1>' ); ?>			
			
			<div class="entry-byline">
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'Written by', 'swt' ); ?> <?php the_author_posts_link(); ?></span> 
				<span itemprop="articleSection" class="entry-terms category"><?php _e( 'Published in: ', 'swt' ); the_category(', '); ?></span> 
				<?php comments_popup_link( __( 'Be the first to comment!', 'swt' ), __( '1 comment', 'swt' ), __( '% comments', 'swt' ), 'comments-link', __( 'Comments off', 'swt' ) ); ?>
			</div>			

		</header><!-- .entry-header -->

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<?php if ( !is_page() ) : ?>
		
			<footer class="entry-footer">
  				<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'text' => __( '<i class="fa fa-tags"></i> Tagged: %s', 'swt' ), 'before' => '<br />' ) ); ?>			
			</footer><!-- .entry-footer -->
		
		<?php endif; ?>
 
		
	<?php else : // If not viewing a single post. ?>

	
		<header class="entry-header">

			<time <?php hybrid_attr( 'entry-published' ); ?>> 
				<span class="month"><?php echo get_the_date('M'); ?></span>
				<span class="day"><?php echo get_the_date('d'); ?></span>				
			</time>			
			
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>
			
			<div class="entry-byline">
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'Written by', 'swt' ); ?> <?php the_author_posts_link(); ?></span> 
				<span itemprop="articleSection" class="entry-terms category"><?php _e( 'Published in: ', 'swt' ); the_category(', '); ?></span> 
				<?php comments_popup_link( __( 'Be the first to comment!', 'swt' ), __( '1 comment', 'swt' ), __( '% comments', 'swt' ), 'comments-link', __( 'Comments off', 'swt' ) ); ?>
			</div>
			
		</header><!-- .entry-header -->
	
		
		<div <?php hybrid_attr( 'entry-summary' ); ?>>
			
			<?php 
			if ( has_post_thumbnail() ) {
				echo '<figure class="aligncenter swt-featured">';
					get_the_image( array( 'size' => 'swt-featured-image', 'order' => array( 'featured', 'attachment' ) ) );
				echo '</figure>'; 				
			}
				
			?>	
			<?php the_excerpt(''); ?>
			
		</div><!-- .entry-summary -->
		
		<footer class="entry-footer">
					
			<a class="more-link" href="<?php the_permalink(); ?>"><?php _e( 'Read More', 'swt' ); ?></a>									
																	
 		</footer><!-- .entry-footer -->
		
	<?php endif; // End single post check. ?>

</article><!-- .entry -->