<?php

class swt_newsletter extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 'classname' => 'swt_newsletter', 'description' => __( 'Newsletter widget for Mailchimp.', 'swt' ) );
		
		parent::WP_Widget( 'swt_newsletter', __( 'SWT - Newsletter', 'swt' ), $widget_options );
				
	}
	
	
	function form( $instance ) {
 
		/* Defaults */
		$defaults = array(  'title' 			=> __( 'Newsletter', 'swt' ), 
							'newsletter_text' 	=> __( 'Subscribe to our newsletter!', 'swt' ), 
							'mailchimp_api_key' => '', 
							'mailchimp_list_id' => '' 
						);
		
		/* Merge $defaults with saved options */
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title 				= 	$instance['title'];
 		$newsletter_text 	= 	$instance['newsletter_text'];
 		$mailchimp_api_key 	= 	$instance['mailchimp_api_key'];
 		$mailchimp_list_id 	= 	$instance['mailchimp_list_id'];
 
 		?>
 
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>			
		
		<p>
			<label for="<?php echo $this->get_field_id( 'newsletter_text' ); ?>"><?php _e( 'Newsletter text:', 'swt' ); ?></label>
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'newsletter_text' ); ?>" name="<?php echo $this->get_field_name( 'newsletter_text' ); ?>"><?php echo esc_textarea( $newsletter_text ); ?></textarea>			
		</p>		
		
		<p>
			<label for="<?php echo $this->get_field_id( 'mailchimp_api_key' ); ?>"><?php _e( 'MailChimp API Key:', 'swt' ); ?></label>	
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'mailchimp_api_key' ); ?>" name="<?php echo $this->get_field_name( 'mailchimp_api_key' ); ?>" value="<?php echo esc_attr( $mailchimp_api_key ); ?>" />	
			<br />
			<small><a target="_blank" href="https://admin.mailchimp.com/account/api-key-popup"><?php _e( 'Grab it here', 'swt' ); ?></a></small>
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'mailchimp_list_id' ); ?>"><?php _e( 'MailChimp List ID:', 'swt' ); ?></label>	
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'mailchimp_list_id' ); ?>" name="<?php echo $this->get_field_name( 'mailchimp_list_id' ); ?>" value="<?php echo esc_attr( $mailchimp_list_id ); ?>" />	
			<br />
			<small><a target="_blank" href="http://kb.mailchimp.com/article/how-can-i-find-my-list-id/"><?php _e( 'Grab it here', 'swt' ); ?></a></small>
		</p>		
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
				
		$instance['title'] = strip_tags( $new_instance['title'] );
 		
		if ( current_user_can( 'unfiltered_html' ) ) 
			$instance['newsletter_text'] = $new_instance['newsletter_text'];
		else
			$instance['newsletter_text'] = stripslashes( wp_filter_post_kses( adslashes( $new_instance['newsletter_text'] ) ) ); 
						
 		$instance['mailchimp_api_key'] = strip_tags( $new_instance['mailchimp_api_key'] );
 		$instance['mailchimp_list_id'] = strip_tags( $new_instance['mailchimp_list_id'] );
		
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$title 				= 	$instance['title']; 
 		$newsletter_text 	= 	$instance['newsletter_text'];
		$mailchimp_api_key	= 	$instance['mailchimp_api_key'];		 		
		$mailchimp_list_id	= 	$instance['mailchimp_list_id'];		 		
		
		/* Setup mailchimp form */
		wp_enqueue_script( 'mailing-list', trailingslashit( get_template_directory_uri() ) . 'js/mailing-list.js', array( 'jquery' ), null, true );

		echo $before_widget;
		
		if ( !empty( $title ) )
			echo $title = $before_title . apply_filters( 'widget_title', $title ) . $after_title;
 		
		if ( !empty( $newsletter_text ) ) 
			echo '<p class="newsletter-text">'. $newsletter_text .'</p>';
					
		?>
		
		<form id="signup" action="<?php echo esc_url( $_SERVER['PHP_SELF'] ); ?>" method="get">
		
			<input type="text" name="email" id="email"  class="newsletter-email" value="<?php esc_attr_e( 'enter your email address...', 'swt' ); ?>" onfocus="if(this.value==this.defaultValue)this.value='';" onblur="if(this.value=='')this.value=this.defaultValue;" />
			<input type="hidden" name="_mailchimp_key" id="_mailchimp_key" value="<?php echo $mailchimp_api_key ?>" />
			<input type="hidden" name="_mailchimp_list" id="_mailchimp_list" value="<?php echo $mailchimp_list_id ?>" />
			<input type="submit" name="submit" value="<?php _e( 'Subscribe', 'swt' ); ?>" class="newsletter-submit" />
			
			<input type="text" style="display: none" value="<?php echo get_template_directory_uri() . '/inc/mailchimp/store-address.php' ?>" name="hidden_path" class="hidden_path" />

			<label for="email" id="address-label">
				<span id="response">
					<?php require_once('mailchimp/store-address.php');
					if ( isset( $_GET['submit'] ) ) {
						echo storeAddress();
					} ?>
				</span>
			</label>                            
		</form>
		
		<?php 		
		echo $after_widget;
		
	}
	
}

?>